% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SnnsRObjectFactory.R
\docType{methods}
\name{SnnsRObjectMethodCaller}
\alias{$}
\alias{$,SnnsR-method}
\alias{SnnsRObjectMethodCaller}
\title{Method caller for SnnsR objects}
\usage{
\S4method{$}{SnnsR}(x, name)
}
\arguments{
\item{x}{object of class \link{SnnsR-class}}

\item{name}{function to call}
}
\description{
Enable calling of C++ functions as methods of \code{SnnsR-class} objects.
}
\details{
This function makes methods of SnnsR__ and SnnsCLib__ accessible via "$". If
no SnnsR__ method is present, then the according SnnsCLib__ method is
called. This enables a very flexible method handling. To mask a method from
SnnsCLib, e.g. to do some parameter checking or postprocessing, only a method
with the same name, but beginning with SnnsR__ has to be present in R.  See
e.g. \code{\link{SnnsRObject$initializeNet}} for such an implementation.

Error handling is also done within the method caller. If the result of a
function is a list with a member \code{err},  then \code{SnnsCLib__error} is
called to use the SNNS kernel function to get the corresponding error message
code and an R warning is thrown containing this message.

Furthermore, a serialization mechanism is implemented which all models
present in the package use to be able to be saved and loaded by R's normal
save/load mechanism (as RData files).

The completely trained object can be serialized with

\code{s <- snnsObject$serializeNet("RSNNS_untitled")}

\code{snnsObject@variables$serialization <- s$serialization}

For the models implemented, this is done in \code{\link{SnnsRObject$train}}. If the S4 object is then saved and loaded,
the calling mechanism will notice on the next use of a function that the pointer to the C++ SnnsCLib object is \code{nil},
and if a serialization is present, the object is restored from this serialization before the method is called.
}

