% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{src_sqlserver}
\alias{src_sqlserver}
\title{Connect to SQLServer or Sybase}
\usage{
src_sqlserver(server, file = NULL, database = "", type = "sqlserver",
  port = "", properties = list())
}
\arguments{
\item{server}{the server address or recognised alias thereof.}

\item{file}{defaults to using the server details file in
\code{$HOME/sql.yaml}. The server details including \code{type}, \code{port}
and any optional \code{properties} can be sourced from this file. If the
\code{server} name is found in \code{file}, the details therein are used
(and in particular, those provided in other arguments to this function are
ignored). The connection method prefers server details to be provided in
a \code{"sql.yaml"} file rather than provided as arguments to this function.
If you wish to specify the details as parameters, ensure that either the
\code{file} does not exist or that the \code{server} details are not in the
YAML file.}

\item{database}{the name of the database hosted on the \code{server}. If an
empty string, a connection to the default database on \code{server} is
assumed.}

\item{type}{the server type. Must be either \code{"sqlserver"} or
\code{"sybase"}. Defaults to \code{"sqlserver"}.}

\item{port}{the TCP/IP default port. This will be coerced to a string.
Defaults to \code{1433} if an empty string (jTDS behaviour).}

\item{properties}{One or more \href{http://jtds.sourceforge.net/faq.html}{optional connection properties.}
in a named list. Note if you intend to set the \code{useNTLMv2} property to \code{'true'}
from the default API value of \code{'false'}, you will need to make a specific
authentication driver available to the SQL Server driver, although this hasn't
worked particularly well in testing. See \code{\link{RSQLServer}} for more
details. Should you wish to use Windows authentication to connect to the server,
I recommend you set the following optional parameters: set \code{useNTLMv2} to
\code{'true'}, \code{domain} to your domain and \code{user} and
\code{password} to your username and password on \code{domain}. jTDS'
SSO functionality is flaky.}
}
\value{
a dplyr SQL based src with subclass \code{sqlserver}
}
\description{
Use \code{src_sqlserver} to connect to an existing SQL Server or Sybase
database, and \code{tbl} to connect to tables within that database.
}
\examples{
\dontrun{
library(dplyr)
# Connection basics ---------------------------------------------------------
# To connect to TEST database, assumed to be specified in your ~/sql.yaml
# file (see \\code{\\link{have_test_server}}), first create a src:
my_src <- src_sqlserver("TEST")
# Then reference a tbl within that src
my_tbl <- tbl(my_src, "my_table")
# Methods -------------------------------------------------------------------
# You can then inspect table and perform actions on it
dim(my_tbl)
colnames(my_tbl)
head(my_tbl)
# Data manipulation verbs ---------------------------------------------------
filter(my_tbl, this.field == "that.value")
select(my_tbl, from.this.field:to.that.field)
arrange(my_tbl, this.field)
mutate(my_tbl, squared.field = field ^ 2)
# Group by operations -------------------------------------------------------
by_field <- group_by(my_tbl, field)
group_size(by_field)
by_field \%>\% summarise(ave = mean(numeric.field))
# See dplyr documentation for further information on data operations
}
}

