% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\docType{methods}
\name{sqlite-meta}
\alias{sqlite-meta}
\alias{dbColumnInfo,SQLiteResult-method}
\alias{dbGetRowsAffected,SQLiteResult-method}
\alias{dbGetRowCount,SQLiteResult-method}
\alias{dbHasCompleted,SQLiteResult-method}
\alias{dbGetStatement,SQLiteResult-method}
\title{Result information}
\usage{
\S4method{dbColumnInfo}{SQLiteResult}(res, ...)

\S4method{dbGetRowsAffected}{SQLiteResult}(res, ...)

\S4method{dbGetRowCount}{SQLiteResult}(res, ...)

\S4method{dbHasCompleted}{SQLiteResult}(res, ...)

\S4method{dbGetStatement}{SQLiteResult}(res, ...)
}
\arguments{
\item{res}{An object of class \code{\linkS4class{SQLiteResult}}}

\item{...}{Ignored. Needed for compatibility with generic}
}
\description{
For a result object, returns information about the SQL statement used,
the available columns and number of already fetched rows for a query,
the number of affected rows for a statement,
and the completion status.
}
\examples{
library(DBI)
db <- RSQLite::datasetsDb()
rs <- dbSendQuery(db, "SELECT * FROM USArrests WHERE UrbanPop >= 80")
dbGetStatement(rs)
dbColumnInfo(rs)
dbHasCompleted(rs)
dbGetRowCount(rs)

dbFetch(rs, n = 2)
dbHasCompleted(rs)
dbGetRowCount(rs)

invisible(dbFetch(rs))
dbHasCompleted(rs)
dbGetRowCount(rs)
dbClearResult(rs)

dbDisconnect(db)

con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbExecute(con, "CREATE TABLE test (a INTEGER)")
rs <- dbSendStatement(con, "INSERT INTO test VALUES (:a)", list(a = 1:3))
dbGetRowsAffected(rs)
dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
The corresponding generic functions
\code{\link[DBI:dbColumnInfo]{DBI::dbColumnInfo()}}, \code{\link[DBI:dbGetRowsAffected]{DBI::dbGetRowsAffected()}}, \code{\link[DBI:dbGetRowCount]{DBI::dbGetRowCount()}},
\code{\link[DBI:dbHasCompleted]{DBI::dbHasCompleted()}}, and \code{\link[DBI:dbGetStatement]{DBI::dbGetStatement()}}.
}

