% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLiteConnection.R, R/query.R, R/table.R
\docType{class}
\name{SQLiteConnection-class}
\alias{SQLiteConnection-class}
\alias{show,SQLiteConnection-method}
\alias{dbIsValid,SQLiteConnection-method}
\alias{dbQuoteIdentifier,SQLiteConnection,character-method}
\alias{dbQuoteIdentifier,SQLiteConnection,SQL-method}
\alias{dbUnquoteIdentifier,SQLiteConnection,SQL-method}
\alias{dbGetException,SQLiteConnection-method}
\alias{dbSendQuery,SQLiteConnection,character-method}
\alias{sqlData,SQLiteConnection-method}
\alias{dbRemoveTable,SQLiteConnection,character-method}
\alias{dbExistsTable,SQLiteConnection,character-method}
\alias{dbListTables,SQLiteConnection-method}
\alias{dbListFields,SQLiteConnection,character-method}
\alias{dbDataType,SQLiteConnection-method}
\title{Class SQLiteConnection (and methods)}
\usage{
\S4method{show}{SQLiteConnection}(object)

\S4method{dbIsValid}{SQLiteConnection}(dbObj, ...)

\S4method{dbQuoteIdentifier}{SQLiteConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{SQLiteConnection,SQL}(conn, x, ...)

\S4method{dbUnquoteIdentifier}{SQLiteConnection,SQL}(conn, x, ...)

\S4method{dbGetException}{SQLiteConnection}(conn, ...)

\S4method{dbSendQuery}{SQLiteConnection,character}(conn, statement,
  params = NULL, ...)

\S4method{sqlData}{SQLiteConnection}(con, value,
  row.names = pkgconfig::get_config("RSQLite::row.names.query", FALSE), ...)

\S4method{dbRemoveTable}{SQLiteConnection,character}(conn, name, ...)

\S4method{dbExistsTable}{SQLiteConnection,character}(conn, name, ...)

\S4method{dbListTables}{SQLiteConnection}(conn, ...)

\S4method{dbListFields}{SQLiteConnection,character}(conn, name, ...)

\S4method{dbDataType}{SQLiteConnection}(dbObj, obj, ...)
}
\description{
SQLiteConnection objects are created by passing \code{\link[=SQLite]{SQLite()}} as first
argument to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.
They are a superclass of the \linkS4class{DBIConnection} class.
The "Usage" section lists the class methods overridden by \pkg{RSQLite}.
}
\seealso{
The corresponding generic functions
\code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}, \code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}},
\code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}, \code{\link[DBI:dbExecute]{DBI::dbExecute()}},
\code{\link[DBI:dbExistsTable]{DBI::dbExistsTable()}}, \code{\link[DBI:dbListTables]{DBI::dbListTables()}}, \code{\link[DBI:dbListFields]{DBI::dbListFields()}},
\code{\link[DBI:dbRemoveTable]{DBI::dbRemoveTable()}}, and \code{\link[DBI:sqlData]{DBI::sqlData()}}.
}
\keyword{internal}
