% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accountMethods.R
\name{createUser}
\alias{createUser}
\title{Create a sub account}
\usage{
createUser(account, username = Sys.getenv("SLUSER"), newUsername, password,
  name, email, ...)
}
\arguments{
\item{account}{An object of class "account". An account object see \code{\link{account}}.}

\item{username}{SauceLabs username}

\item{newUsername}{The username of the new user you wish to create}

\item{password}{The password for the new user you wish to create}

\item{name}{The name of the new user you wish to create}

\item{email}{The email of the new user you wish to create}

\item{...}{Additonal function arguments - Currently unused.}
}
\description{
Create a sub account
}
\examples{
\dontrun{
myAcc <- account()
appData <- getUser(myAcc)

createUser(myAcc, newUsername = "superstartester", password = "johndoe"
           , name = "John", email = "superstartester@example.com")
# $errors
# [1] "Subaccount capacity exhausted."
uC <- getUserConcurrency(myAcc)
#> rbindlist(uC$concurrency$self[c("allowed", "current")], fill = TRUE)
#manual mac overall real_device
#1:      5   5       5           0
#2:      0   0       0          NA
users <- getListOfSubAccounts(myAcc)
#> users$users_total
#[1] 1
siblings <- getListOfSiblingAccounts(myAcc)
#> getListOfSiblingAccounts(myAcc)
#list()
subAcc <- getSubAccountInformation(myAcc)

# change accesskey for a user
# changeAccessKey(myAcc, "rsaucelabs")
}
}
\seealso{
Other accountMethods: \code{\link{changeAccessKey}},
  \code{\link{getListOfSiblingAccounts}},
  \code{\link{getListOfSubAccounts}},
  \code{\link{getSubAccountInformation}},
  \code{\link{getUserConcurrency}}, \code{\link{getUser}}
}

