% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/topCor.R
\name{topCor}
\alias{topCor}
\title{Topographic Illumination Correction}
\usage{
topCor(img, dem, metaData, solarAngles = c(), method = "C",
  stratImg = NULL, nStrat = 5, illu)
}
\arguments{
\item{img}{Raster*. Imagery to correct}

\item{dem}{Raster*. Either a digital elevation model as a RasterLayer or a RasterStack/Brick with pre-calculated slope and aspect (see \link[raster]{terrain}) in which case the layers must be named 'slope' and 'aspect'.
Must have the same dimensions as \code{img}.}

\item{metaData}{Character, ImageMetaData. Either a path to a Landsat meta-data file (MTL) or an ImageMetaData object (see \link{readMeta})}

\item{solarAngles}{Numeric vector containing sun azimuth and sun zenith (in radians and in that order). Not needed if metaData is provided}

\item{method}{Character. One of c("cos", "avgcos", "minnaert", "C", "stat", "illu"). Choosing 'illu' will return only the local illumination map.}

\item{stratImg}{RasterLayer to define strata, e.g. NDVI. Or the string 'slope' in which case stratification will be on \code{nStrat} slope classes. Only relevant if \code{method = 'minnaert'}.}

\item{nStrat}{Integer. Number of bins or quantiles to stratify by. If a bin has less than 50 samples it will be merged with the next bin. Only relevant if \code{method = 'minnaert'}.}

\item{illu}{Raster*. Optional pre-calculated ilumination map. Run topCor with method="illu" to calculate an ilumination map}
}
\description{
account and correct for changes in illumination due to terrain elevation.
}
\details{
For detailed discussion of the various approaches please see Riano et al. (2003).

The minnaert correction can be stratified for different landcover characteristics. If \code{stratImg = 'slope'} the analysis is stratified by the slope,
i.e. the slope values are divided into \code{nStrat} classes and the correction coefficient k is calculated and applied separately for each slope class.
An alternative could be to stratify by a vegetation index in which case an additional raster layer has to be provided via the \code{stratImg} argument.
}
\examples{
## Load example data
metaData <- system.file("external/landsat/LT52240631988227CUB02_MTL.txt", package="RStoolbox")
metaData <- readMeta(metaData)
lsat     <- stackMeta(metaData)
data(srtm)
\dontshow{
data(lsat)
}

## Minnaert correction, solar angles from metaData
lsat_minnaert <- topCor(lsat, dem = srtm, metaData = metaData, method = "minnaert")

## C correction, solar angles provided manually
lsat_C <- topCor(lsat, dem = srtm, solarAngles = c(1.081533, 0.7023922), method = "C")
}
\references{
Riano et al. (2003) Assessment of different topographic correction in Landsat-TM data for mapping vegetation types. IEEE Transactions on Geoscience and Remote Sensing.
}

