% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getValidation.R
\name{getValidation}
\alias{getValidation}
\title{Extract validation results from superClass objects}
\usage{
getValidation(x, from = "testset", metrics = "overall")
}
\arguments{
\item{x}{superClass object or caret::confusionMatrix}

\item{from}{Character. 'testset' extracts the results from independent validation with testset. 'cv' extracts cross-validation results.}

\item{metrics}{Character. Only relevant in classification mode (ignored for regression models). 
Select 'overall' for overall accuracy metrics, 'classwise' for classwise metrics, 
'confmat' for the confusion matrix itself and 'caret' to return the whole caret::confusionMatrix object.}
}
\value{
Returns a data.frame with validation results. 
If metrics = 'confmat' or 'caret' wil return a table or the full caret::confusionMatrix object, respectively.
}
\description{
Extract validation results from superClass objects
}
\examples{
library(pls)
## Fit classifier (splitting training into 70\\\% training data, 30\\\% validation data)
train <- readRDS(system.file("external/trainingPoints.rds", package="RStoolbox"))
SC   <- superClass(rlogo, trainData = train, responseCol = "class", 
                    model="pls", trainPartition = 0.7)
## Independent testset-validation
getValidation(SC)
getValidation(SC, metrics = "classwise")
## Cross-validation based 
getValidation(SC, from = "cv")
}

