% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveRSTBX.R
\name{saveRSTBX}
\alias{saveRSTBX}
\alias{saveRSTBX}
\alias{readRSTBX}
\title{Save and Read RStoolbox Classification Results}
\usage{
saveRSTBX(x, filename, format = "raster", ...)

readRSTBX(filename)
}
\arguments{
\item{x}{RStoolbox object of classes c("fCover", "rasterPCA", "superClass", "unsuperClass")}

\item{filename}{Character. Path and filename. Any file extension will be ignored.}

\item{format}{Character. Driver to use for the raster file}

\item{...}{further arguments passed to writeRaster}
}
\value{
The output of writeRSTBX will be at least two files written to disk:
a) an .rds file containing the object itself and 
b) the raster file (depending on the driver you choose this can be more than two files).
}
\description{
Saves objects of classes unsuperClass, superClass, rasterPCA and fCover to
file. Useful to archive the fitted models.
}
\section{Functions}{
\itemize{
\item \code{saveRSTBX}: Save RStoolbox object to file

\item \code{readRSTBX}: Read files saved with saveRSTBX
}}

\note{
All files must be kept in the same directory to read the full object back into R
by means of readRSTBX. You can move them to another location but you'll have to move *all* of them 
(just like you would with Shapefiles). In case the raster file(s) is missing, readRSTBX will still
return the object but the raster will be missing.

writeRSTBX and readRSTBX are convenience wrappers around saveRDS, readRDS. This means 
you can read all files created this way also with base functionality as long as you don't move your files.
This is because x$map is a Raster* object and hence contains only a static link to the file on disk.
}
\examples{
\dontrun{
input <- brick(system.file("external/rlogo.grd", package="raster"))
## Create filename
file  <- paste0(tempdir(), "/test", runif(1))
## Run PCA
rpc   <- rasterPCA(input, filename = file, nSample = 100)
## Save object
saveRSTBX(rpc, filename=file)
## Which files were written?
list.files(tempdir(), pattern = basename(file))
## Re-read files
re_rpc <- readRSTBX(file)
## Compare 
all.equal(re_rpc, rpc)
file.remove(file)
}
}
