% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneHotEncode.R
\name{oneHotEncode}
\alias{oneHotEncode}
\title{One-hot encode a raster or vector}
\usage{
oneHotEncode(img, classes, background = 0, foreground = 1, na.rm = FALSE, ...)
}
\arguments{
\item{img}{RasterLayer or integer/numeric vector containing multiple classes}

\item{classes}{integer: vector of classes which should be extracted}

\item{background}{integer: background value (default = 0)}

\item{foreground}{integer: foreground value (default = 1)}

\item{na.rm}{logical: if \code{TRUE}, \code{NA}s will be coerced to the \code{background} value.}

\item{...}{further arguments passed to \link[raster]{writeRaster}. Ignored if img is not a RasterLayer, but a numeric/integer vector}
}
\value{
A RasterBrick with as many layers as there are classes. 
Pixels matching the class of interest are set to 1, backround values by default are set to 0 (see background argument)
}
\description{
Splits a categorical raster layer (or a vector) into a multilayer raster (or matrix).
}
\examples{
library(raster)

## example data
data(rlogo)
sc <- unsuperClass(rlogo, nClasses = 3)

## one-hot encode 
sc_oneHot <- oneHotEncode(sc$map, classes = c(1,2,3))

## check results
sc_oneHot
plot(sc_oneHot)
}
