% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_mng_remove}
\alias{repo_mng_remove}
\title{Removes packages from the repository.}
\usage{
repo_mng_remove(repo_manager, toremove, pkg_type = .Platform$pkgType)
}
\arguments{
\item{repo_manager}{repo manager to remove packages from.
(type: rsuite_repo_manager)}

\item{toremove}{data.frame with same structure as available.packages returns.
At lease Package and Version columns must be present. (type: data.frame)}

\item{pkg_type}{type of packages to remove.
(type: character, default: .Platform$pkgType)}
}
\description{
Removes packages from the repository.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # set it to use in project repository and CRAN
  prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = prj)

  # start managing in project repository
  rmgr <- repo_mng_start("Dir", prj = prj, ix = 1)

  # upload logging package from CRAN into the repository
  repo_upload_ext_packages(rmgr, pkgs = "logging", prj = prj)

  # list available packages before removal
  avail_pkgs <- repo_mng_list(rmgr)
  avail_pkgs

  # remove logging from the repository
  repo_mng_remove(rmgr, avail_pkgs[avail_pkgs$Package == "logging", ])

  # list available packages after removal
  repo_mng_list(rmgr)

  # stop repository management
  repo_mng_stop(rmgr)
}

}
\seealso{
Other in repository management: \code{\link{repo_mng_init}},
  \code{\link{repo_mng_list}},
  \code{\link{repo_mng_start}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_ext_packages}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_package_files}},
  \code{\link{repo_upload_pkgzip}},
  \code{\link{repo_upload_prj_packages}}
}
