% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_based_functions.R
\name{sep.rb.hypergeo}
\alias{sep.rb.hypergeo}
\title{Hypergeometric risk-based population sensitivity}
\usage{
sep.rb.hypergeo(pstar, rr, N, n, se)
}
\arguments{
\item{pstar}{design prevalence (scalar)}

\item{rr}{relative risk values (vector of values corresponding 
to the number of risk strata)}

\item{N}{Population size per risk category (vector same length 
as rr and ppr)}

\item{n}{sample size per risk category (vector same length as 
rr and ppr)}

\item{se}{unit sensitivity, can vary among risk strata (fixed value or a vector the same 
length as rr, ppr, n)}
}
\value{
list of 3 elements, a scalar of population-level sensitivity
  a vector of EPI values and a vector of corresponding adjusted risks
}
\description{
Calculates risk-based population sensitivity with a 
  single risk factor, using the hypergeometric method 
  (assuming a finite and known population size),
  allows for unit sensitivity to vary among risk strata
}
\examples{
# examples for sep.rb.bin
sep.rb.hypergeo(0.1, c(5, 3, 1), c(10, 10, 80), c(5, 5, 5), 0.9)
sep.rb.hypergeo(0.1, c(5, 1), c(15, 140), c(10, 5), c(0.95, 0.9))
sep.rb.hypergeo(0.1, c(5, 1), c(23, 180), c(10, 5), c(0.9, 0.9))
sep.rb.hypergeo(0.01, c(5, 1), c(100, 900), c(90, 50), c(0.9, 0.9))
}
\keyword{methods}

