% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\name{Data}
\alias{Data}
\title{Set or Query Data and Parameters}
\usage{
Data(option, value, which.attr = NULL, clear.proj = FALSE,
  clear.data = FALSE, replace.all = NULL)
}
\arguments{
\item{option}{character.
Parameter name, see \sQuote{Parameters} section.}

\item{value}{Parameter value specified for \code{option} (optional)}

\item{which.attr}{character.
A non-empty character string specifying which attribute is to be accessed.}

\item{clear.proj}{logical.
If true, basic graphical user interface (\acronym{GUI}) preferences will be saved and all other data removed.}

\item{clear.data}{logical.
If true, only datasets will be removed.}

\item{replace.all}{list.
A replacement list of parameter values.}
}
\value{
If \code{value} is given, the object specified by \code{option} is returned.
A \code{NULL} value is returned for objects not yet assigned a value and where no default value is available.
Default values are specified internally within this function.
}
\description{
This function is used to set or query parameters and their attributes.
}
\section{Data}{

Imported unprocessed data is saved to the data frame \code{data.raw}, see \code{\link{ImportText}}.
Processed point data is saved to the data frame \code{data.pts},
and interpolated surface data is saved to the list \code{data.grd}.
}

\section{Parameters}{

Parameters undefined elsewhere in the help documentation include:
\describe{
  \item{\code{ver}}{package version number}
  \item{\code{win.loc}}{default horizontal and vertical location for \acronym{GUI} placement in pixels.}
}
}

\examples{
# set a parameter
Data("test1", 3.14159265)
Data("test2", list(id = "PI", val = 3.14159265))

# retrieve a parameter value
Data("test1")
Data("test2")
Data(c("test2", "id"))
Data(c("test2", "val"))

# get all parameter values
d <- Data()

# remove all saved parameter values
Data(replace.all = list())

# recover saved parameter values
Data(replace.all = d)

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{sysdata}
