% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown_rtl.R
\name{markdown_rtl}
\alias{markdown_rtl}
\title{Enable Right-to-Left (RTL) Formatting for Markdown Documents}
\usage{
markdown_rtl(...)
}
\arguments{
\item{...}{Additional arguments to be passed to the underlying \code{knit_hooks$set} function.}
}
\value{
The function has no explicit return value. It modifies the behavior of \code{knit_hooks} for RTL formatting.
}
\description{
This function modifies the behavior of \code{\link{knitr}} output hooks to handle RTL (right-to-left)
text formatting for Markdown documents, particularly for languages like Persian and Arabic.
}
\details{
The \code{markdown_rtl} function wraps the existing \code{knit_hooks} with custom commands that switch
the text direction between Latin and Persian. It enhances the appearance of the output,
messages, warnings, and errors in RTL languages.
}
\examples{
# Enable RTL formatting for the current R Markdown document
markdown_rtl()

# After enabling RTL formatting, proceed to knit the R Markdown document as usual.
# The output and messages will be formatted for RTL languages.

}
\references{
Xie, Y. (2014). Dynamic Documents with R and knitr. Chapman & Hall/CRC. ISBN: 978-1482203530.
}
\seealso{
Use \code{\link{hooks_rtl}} for handling RTL formatting within code chunks.
}
