% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advector.R
\name{AD}
\alias{AD}
\title{Convert R object to AD}
\usage{
AD(x, force = FALSE)
}
\arguments{
\item{x}{Object to be converted.}

\item{force}{Logical; Force AD conversion even if no AD context? (for debugging)}
}
\description{
Signify that this object should be given an AD interpretation if evaluated in an active AD context. Otherwise, keep object as is.
}
\details{
\code{AD} is a generic constructor, converting plain R structures to RTMB objects if in an autodiff context. Otherwise, it does nothing (and adds virtually no computational overhead).

\code{AD} knows the following R objects:
\itemize{
\item Numeric objects from \pkg{base}, such as \code{numeric()}, \code{matrix()}, \code{array()}, are converted to class \link{advector} with other attributes kept intact.
\item Complex objects from \pkg{base}, such as \code{complex()}, are converted to class \link{adcomplex}.
\item Sparse matrices from \pkg{Matrix}, such as \code{Matrix()}, \code{Diagonal()}, are converted to \code{adsparse} which is essentially a \code{dgCMatrix} with \link{advector} x-slot.
}

\code{AD} provides a reliable way to avoid problems with method dispatch when mixing operand types. For instance, sub assigning \code{x[i] <- y} may be problematic when \code{x} is numeric and \code{y} is \code{advector}. A prior statement \code{x <- AD(x)} solves potential method dispatch issues and can therefore be used as a reliable alternative to \link{ADoverload}.
}
\examples{
## numeric object to AD
AD(numeric(4), force=TRUE)
## complex object to AD
AD(complex(4), force=TRUE)
## Convert sparse matrices (Matrix package) to AD representation
F <- MakeTape(function(x) {
  M <- AD(Matrix::Matrix(0,4,4))
  M[1,] <- x
  D <- AD(Matrix::Diagonal(4))
  D@x[] <- x
  M + D
}, 0)
F(2)
}
