% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.xmlWrite.R
\name{xmlFromList}
\alias{xmlFromList}
\title{Creat an XML Node from a list}
\usage{
xmlFromList(node, sublist)
}
\arguments{
\item{node}{(\code{XMLNode}) A Node created by XML package}

\item{sublist}{(\code{list}) Any list}
}
\value{
node (\code{XMLNode}) A node where the list is attached to the first XML Node
}
\description{
This function appends a list as an XML object to an item. The function allows
setting attributes of XML items by using the "attributes" list name, therefore
it can never write tags with the name "attributes"
}
\examples{

root <- XML::newXMLNode("root")
li <- list(a = list(aa = 1, ab=2), 
			b=list(ba = 1,
                bb=list(x=4,
                       attributes=c(value=3)),
               bb= 2,
              bc =3))
xmlFromList(root,li)

# The result is an XML Node like this
#<root>
#  <a>
#    <aa>1</aa>
#    <ab>2</ab>
#  </a>
#  <b>
#    <ba>1</ba>
#    <bb value="3">
#      <x>4</x>
#    </bb>
#    <bb>2</bb>
#    <bc>3</bc>
#  </b>
#</root> 

}
\author{
Sebastian Wolf \email{sebastian.wolf.sw1@roche.com}
}
