\name{create_analytics}
\alias{create_analytics}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
creates an object of class analytics given classification results.
}
\description{
Takes the results from functions \code{\link{classify_model}} or \code{\link{classify_models}} and computes various statistics to help interpret the data.
}
\usage{
create_analytics(corpus, classification_results, b=1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{corpus}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_corpus}} function.
}
  \item{classification_results}{
A \code{cbind()} of result objects returned by \code{\link{classify_model}}, or the object returned by \code{\link{classify_models}}.
}
  \item{b}{
b-value for generating precision, recall, and F-scores statistics.
}
}
\value{
Object of class \code{\link{analytics_container_virgin-class}} or \code{\link{analytics_container-class}} has either two or four slots respectively, depending on whether the \code{virgin} flag is set to \code{TRUE} or \code{FALSE} in \code{\link{create_corpus}}. They can be accessed using the \code{@} operator 
for S4 classes (e.g. \code{analytics@document_summary}).
}
\author{
Timothy P. Jurka <tpjurka@ucdavis.edu>, Loren Collingwood <lorenc2@uw.edu>
}
\examples{
library(RTextTools)
data <- read_data(system.file("data/NYTimes.csv.gz",package="RTextTools"),type="csv")
data <- data[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data$Title,data$Subject), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=weightTfIdf)
corpus <- create_corpus(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
models <- train_models(corpus, algorithms=c("MAXENT","SVM"))
results <- classify_models(corpus, models)
analytics <- create_analytics(corpus, results)
}
\keyword{method}
