\name{train_model}
\alias{train_model}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
makes a model object using the specified algorithm.
}
\description{
Creates a trained model using the specified algorithm.
}
\usage{
train_model(container, algorithm=c("SVM","SLDA","BOOSTING","BAGGING",
"RF","GLMNET","TREE","NNET","MAXENT"), method = "C-classification", 
cross = 0, cost = 100, kernel = "radial", maxitboost = 100, 
maxitglm = 10^5, size = 1, maxitnnet = 1000, MaxNWts = 10000, 
rang = 0.1, decay = 5e-04, trace=FALSE, ntree = 200, 
l1_regularizer = 0, l2_regularizer = 0, use_sgd = FALSE, 
set_heldout = 0, verbose = FALSE,
...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{container}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_container}} function.
}
  \item{algorithm}{
Character vector (i.e. a string) specifying which algorithm to use. Use \code{\link{print_algorithms}} to see a list of options. 
}
  \item{method}{
Method parameter for SVM implentation. See \pkg{e1071} documentation for more details.
}
  \item{cross}{
Cross parameter for SVM implentation. See \pkg{e1071} documentation for more details.
}
  \item{cost}{
Cost parameter for SVM implentation. See \pkg{e1071} documentation for more details.
}
  \item{kernel}{
Kernel parameter for SVM implentation. See \pkg{e1071} documentation for more details.
}
  \item{maxitboost}{
Maximum iterations parameter for boosting implentation. See \pkg{caTools} documentation for more details.
}
  \item{maxitglm}{
Maximum iterations parameter for glmnet implentation. See \pkg{glmnet} documentation for more details.
}
  \item{size}{
Size parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{maxitnnet}{
Maximum iterations for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{MaxNWts}{
Maximum number of weights parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{rang}{
Range parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{decay}{
Decay parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{trace}{
Trace parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{ntree}{
Number of trees parameter for RandomForests implentation. See \pkg{randomForest} documentation for more details.
}
  \item{l1_regularizer}{
An \code{numeric} turning on L1 regularization and setting the regularization parameter. A value of 0 will disable L1 regularization. See \pkg{maxent} documentation for more details.
}
  \item{l2_regularizer}{
An \code{numeric} turning on L2 regularization and setting the regularization parameter. A value of 0 will disable L2 regularization. See \pkg{maxent} documentation for more details.
}
  \item{use_sgd}{
A \code{logical} indicating that SGD parameter estimation should be used. Defaults to \code{FALSE}. See \pkg{maxent} documentation for more details.
}
  \item{set_heldout}{
An \code{integer} specifying the number of documents to hold out. Sets a held-out subset of your data to test against and prevent overfitting. See \pkg{maxent} documentation for more details.
}
  \item{verbose}{
A \code{logical} specifying whether to provide descriptive output about the training process. Defaults to \code{FALSE}, or no output. See \pkg{maxent} documentation for more details.
}
  \item{\dots}{
Additional arguments to be passed on to algorithm function calls.
}
}
\details{
Only one algorithm may be selected for training. See \code{\link{train_models}} and \code{\link{classify_models}} to train and classify using multiple algorithms.
}
\value{
Returns a trained model that can be subsequently used in \code{\link{classify_model}} to classify new data.
}

\author{
Timothy P. Jurka <tpjurka@ucdavis.edu>, Loren Collingwood <lorenc2@uw.edu>
}
\examples{
library(RTextTools)
data(NYTimes)
data <- NYTimes[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data["Title"],data["Subject"]), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=tm::weightTfIdf)
container <- create_container(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
maxent_model <- train_model(container,"MAXENT")
svm_model <- train_model(container,"SVM")
}
\keyword{method}
