% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.CI.R
\name{duration.CI}
\alias{duration.CI}
\title{Bootstrapped confidence intervals - Duration}
\usage{
duration.CI(genMat,portWgts,nHorizon,sim)
}
\arguments{
\item{genMat}{generator matrix}

\item{portWgts}{list containing weights of each rating class}

\item{nHorizon}{horizon}

\item{sim}{number of simulations}
}
\value{
Returns the default probabilites values for the n ratings at the 2.5, 5, 25, 50, 75, 95, 97.5 percentiles.
}
\description{
estimate confidence intervals for the transition probabilities using a bootstrapping procedure for duration method
}
\details{
The general idea of bootstrapping is to use resampling methods to estimate features of the sampling distribution of
an estimator, especially in situations where asymptotic approximations may provide poor results. In the case of a
parametric bootstrap method one samples from the estimated distribution derived using maximum likelihood estimation.
In summary,

\enumerate{
\item Estimate the distribution from the observed sample using maximum likelihood
\item Draw samples from the estimated distribution
\item Calculate the parameter of interest from each of the samples
\item Construct an empirical distribution for the parameter of interest
\item Select percentiles from the empirical distribution
}

One can contrast this method with a \emph{nonparametric bootstrap} in which one samples with replacement from the
empirical cumulative distribution function of the observed sample.

A parametric bootstrapping method is employed for the time-homogeneous continuous-time Markov model.  The elements of the
infinitesimal generator matrix, provide most of the information one needs to perform the parametric bootstrap. The outline of the
bootstrapping is provided below.

For each obligor in a given assigned credit grade:
\enumerate{
\item Start by drawing a (sojourn) time from the exponential distribution with parameter, \eqn{-\hat{\lambda}_{kk}}
\item If the time is greater than or equal to the time left to horizon then stop
\item If the time is less than the time left to horizon
 \itemize{
    \item Draw from the multinomial distribution associated with the possible transition states using the vector of probabilities
    \item Determine the state to which the obligor moves, for example, \eqn{i}
    \item Repeat the process in 1. now using the diagonal element, \eqn{-\hat{\lambda}_{ii}}
    \item Continue until the sampled time exceeds the time to horizon
}
}
}
\examples{
portWgts <-  c(100, 100, 100, 100, 100, 100, 100, 100)
sim <- 100
nHorizon <- 1.0
\dontrun{
t<-duration.CI(AverageGeneratorMatrices,portWgts,nHorizon,sim)
}

}
\references{
Hanson, S. and Schuermann, T. 2005 Confidence Intervals for Probabilities of Default,
Federal Reserve Bank of New York

Jafry, Y. and Schuermann, T. 2003 Metrics for Comparing Credit Migration Matrices,
Wharton Financial Institutions Working Paper 03-08.

Loffler, G., P. N. Posch. 2007 Credit Risk Modeling Using Excel and VBA.
West Sussex, England, Wiley Finance

Trueck, Stefan, (February 16, 2009) Simulating Dependent Credit Migrations. Available at SSRN:
https://ssrn.com/abstract=1344897
}
\author{
Abdoulaye (Ab) N'Diaye
}
