% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetOperations.R, R/RVenn.R
\docType{methods}
\name{discern,Venn-method}
\alias{discern,Venn-method}
\alias{discern}
\title{Set difference.}
\usage{
\S4method{discern}{Venn}(venn, slice1, slice2 = "all")
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{slice1}{(Required) The name or the index of the set of interest.
Multiple sets can be selected.}

\item{slice2}{(Optional) The name or the index of the set of interest.
Multiple sets can be selected. Default is all the sets except the sets of
slice1.}
}
\value{
A vector showing the difference between slice1 and slice2.
}
\description{
\code{discern} returns the difference between two group of sets selected from
  a \code{Venn} object. If multiple sets are chosen for the slices, union of
  those sets will be used.
}
\examples{
venn = Venn(list(letters[1:10], letters[3:12], letters[6:15]))
discern(venn, slice1 = 1)
discern(venn, slice1 = c(1, 2), slice2 = 3)
}
