/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.lmt.LMTNode;
import weka.classifiers.trees.lmt.ResidualModelSelection;
import weka.core.AdditionalMeasureProducer;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class LMT
extends Classifier
implements OptionHandler,
AdditionalMeasureProducer,
Drawable {
    protected ReplaceMissingValues m_replaceMissing;
    protected NominalToBinary m_nominalToBinary;
    protected LMTNode m_tree;
    protected boolean m_fastRegression = true;
    protected boolean m_convertNominal;
    protected boolean m_splitOnResiduals;
    protected boolean m_errorOnProbabilities;
    protected int m_minNumInstances = 15;
    protected int m_numBoostingIterations = -1;

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("Nominal class, please.");
        }
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        if (instances2.numInstances() == 0) {
            throw new Exception("No instances in training file!");
        }
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_replaceMissing.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, this.m_replaceMissing);
        if (this.m_convertNominal) {
            this.m_nominalToBinary = new NominalToBinary();
            this.m_nominalToBinary.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, this.m_nominalToBinary);
        }
        int n = 2;
        ModelSelection modelSelection = this.m_splitOnResiduals ? new ResidualModelSelection(n) : new C45ModelSelection(n, instances2);
        this.m_tree = new LMTNode(modelSelection, this.m_numBoostingIterations, this.m_fastRegression, this.m_errorOnProbabilities, this.m_minNumInstances);
        this.m_tree.buildClassifier(instances2);
        if (modelSelection instanceof C45ModelSelection) {
            ((C45ModelSelection)modelSelection).cleanup();
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_replaceMissing.input(instance);
        instance = this.m_replaceMissing.output();
        if (this.m_convertNominal) {
            this.m_nominalToBinary.input(instance);
            instance = this.m_nominalToBinary.output();
        }
        return this.m_tree.distributionForInstance(instance);
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = -1.0;
        int n = 0;
        double[] dArray = this.distributionForInstance(instance);
        for (int i = 0; i < instance.numClasses(); ++i) {
            if (!Utils.gr(dArray[i], d)) continue;
            n = i;
            d = dArray[i];
        }
        return n;
    }

    public String toString() {
        if (this.m_tree != null) {
            return "Logistic model tree \n------------------\n" + this.m_tree.toString();
        }
        return "No tree build";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(8);
        vector.addElement(new Option("\tBinary splits (convert nominal attributes to binary ones)\n", "B", 0, "-B"));
        vector.addElement(new Option("\tSplit on residuals instead of class values\n", "R", 0, "-R"));
        vector.addElement(new Option("\tUse cross-validation for boosting at all nodes (i.e., disable heuristic)\n", "C", 0, "-C"));
        vector.addElement(new Option("\tUse error on probabilities instead of misclassification error for stopping criterion of LogitBoost.\n", "P", 0, "-P"));
        vector.addElement(new Option("\tSet fixed number of iterations for LogitBoost (instead of using cross-validation)\n", "I", 1, "-I <numIterations>"));
        vector.addElement(new Option("\tSet minimum number of instances at which a node can be split (default 15)\n", "M", 1, "-M <numInstances>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setConvertNominal(Utils.getFlag('B', stringArray));
        this.setSplitOnResiduals(Utils.getFlag('R', stringArray));
        this.setFastRegression(!Utils.getFlag('C', stringArray));
        this.setErrorOnProbabilities(Utils.getFlag('P', stringArray));
        String string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setNumBoostingIterations(new Integer(string));
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            this.setMinNumInstances(new Integer(string));
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[8];
        int n = 0;
        if (this.getConvertNominal()) {
            stringArray[n++] = "-B";
        }
        if (this.getSplitOnResiduals()) {
            stringArray[n++] = "-R";
        }
        if (!this.getFastRegression()) {
            stringArray[n++] = "-C";
        }
        if (this.getErrorOnProbabilities()) {
            stringArray[n++] = "-P";
        }
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getNumBoostingIterations();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMinNumInstances();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean getConvertNominal() {
        return this.m_convertNominal;
    }

    public boolean getSplitOnResiduals() {
        return this.m_splitOnResiduals;
    }

    public boolean getFastRegression() {
        return this.m_fastRegression;
    }

    public boolean getErrorOnProbabilities() {
        return this.m_errorOnProbabilities;
    }

    public int getNumBoostingIterations() {
        return this.m_numBoostingIterations;
    }

    public int getMinNumInstances() {
        return this.m_minNumInstances;
    }

    public void setConvertNominal(boolean bl) {
        this.m_convertNominal = bl;
    }

    public void setSplitOnResiduals(boolean bl) {
        this.m_splitOnResiduals = bl;
    }

    public void setFastRegression(boolean bl) {
        this.m_fastRegression = bl;
    }

    public void setErrorOnProbabilities(boolean bl) {
        this.m_errorOnProbabilities = bl;
    }

    public void setNumBoostingIterations(int n) {
        this.m_numBoostingIterations = n;
    }

    public void setMinNumInstances(int n) {
        this.m_minNumInstances = n;
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        return this.m_tree.graph();
    }

    public int measureTreeSize() {
        return this.m_tree.numNodes();
    }

    public int measureNumLeaves() {
        return this.m_tree.numLeaves();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(2);
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (string.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(string + " not supported (LMT)");
    }

    public String globalInfo() {
        return "Classifier for building 'logistic model trees', which are classification trees with logistic regression functions at the leaves. The algorithm can deal with binary and multi-class target variables, numeric and nominal attributes and missing values. For more information see: N.Landwehr, M.Hall, E. Frank 'Logistic Model Trees' (ECML 2003).";
    }

    public String convertNominalTipText() {
        return "Convert all nominal attributes to binary ones before building the tree. This means that all splits in the final tree will be binary.";
    }

    public String splitOnResidualsTipText() {
        return "Set splitting criterion based on the residuals of LogitBoost. There are two possible splitting criteria for LMT: the default is to use the C4.5 splitting criterion that uses information gain on the class variable. The other splitting criterion tries to improve the purity in the residuals produces when fitting the logistic regression functions. The choice of the splitting criterion does not usually affect classification accuracy much, but can produce different trees.";
    }

    public String fastRegressionTipText() {
        return "Use heuristic that avoids cross-validating the number of Logit-Boost iterations at every node. When fitting the logistic regression functions at a node, LMT has to determine the number of LogitBoost iterations to run. Originally, this number was cross-validated at every node in the tree. To save time, this heuristic cross-validates the number only once and then uses that number at every node in the tree. Usually this does not decrease accuracy but improves runtime considerably.";
    }

    public String errorOnProbabilitiesTipText() {
        return "Minimize error on probabilities instead of misclassification error when cross-validating the number of LogitBoost iterations. When set, the number of LogitBoost iterations is chosen that minimizes the root mean squared error instead of the misclassification error.";
    }

    public String numBoostingIterationsTipText() {
        return "Set a fixed number of iterations for LogitBoost. If >= 0, this sets a fixed number of LogitBoost iterations that is used everywhere in the tree. If < 0, the number is cross-validated.";
    }

    public String minNumInstancesTipText() {
        return "Set the minimum number of instances at which a node is considered for splitting. The default value is 15.";
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(Evaluation.evaluateModel(new LMT(), stringArray));
    }
}

