/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.j48.NBTreeClassifierTree;
import weka.classifiers.trees.j48.NBTreeModelSelection;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.WeightedInstancesHandler;

public class NBTree
extends Classifier
implements WeightedInstancesHandler,
Drawable,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = -4716005707058256086L;
    private int m_minNumObj = 30;
    private NBTreeClassifierTree m_root;

    public String globalInfo() {
        return "Class for generating a decision tree with naive Bayes classifiers at the leaves.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ron Kohavi");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Scaling Up the Accuracy of Naive-Bayes Classifiers: A Decision-Tree Hybrid");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Second International Conference on Knoledge Discovery and Data Mining");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1996");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "202-207");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        return new NBTreeClassifierTree(null).getCapabilities();
    }

    public void buildClassifier(Instances instances) throws Exception {
        NBTreeModelSelection nBTreeModelSelection = new NBTreeModelSelection(this.m_minNumObj, instances);
        this.m_root = new NBTreeClassifierTree(nBTreeModelSelection);
        this.m_root.buildClassifier(instances);
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_root.classifyInstance(instance);
    }

    public final double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_root.distributionForInstance(instance, false);
    }

    public String toString() {
        if (this.m_root == null) {
            return "No classifier built";
        }
        return "NBTree\n------------------\n" + this.m_root.toString();
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        return this.m_root.graph();
    }

    public String toSummaryString() {
        return "Number of leaves: " + this.m_root.numLeaves() + "\n" + "Size of the tree: " + this.m_root.numNodes() + "\n";
    }

    public double measureTreeSize() {
        return this.m_root.numNodes();
    }

    public double measureNumLeaves() {
        return this.m_root.numLeaves();
    }

    public double measureNumRules() {
        return this.m_root.numLeaves();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (string.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(string + " not supported (j48)");
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        vector.addElement("measureNumRules");
        return vector.elements();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new NBTree(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

