/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.associations.ItemSet;
import weka.core.ContingencyTables;
import weka.core.FastVector;
import weka.core.Instances;

public class AprioriItemSet
extends ItemSet
implements Serializable {
    public AprioriItemSet(int n) {
        super(n);
    }

    public static double confidenceForRule(AprioriItemSet aprioriItemSet, AprioriItemSet aprioriItemSet2) {
        return (double)aprioriItemSet2.m_counter / (double)aprioriItemSet.m_counter;
    }

    public double liftForRule(AprioriItemSet aprioriItemSet, AprioriItemSet aprioriItemSet2, int n) {
        double d = AprioriItemSet.confidenceForRule(aprioriItemSet, aprioriItemSet2);
        return d / ((double)n / (double)this.m_totalTransactions);
    }

    public double leverageForRule(AprioriItemSet aprioriItemSet, AprioriItemSet aprioriItemSet2, int n, int n2) {
        double d = (double)aprioriItemSet2.m_counter / (double)this.m_totalTransactions;
        double d2 = (double)n / (double)this.m_totalTransactions * ((double)n2 / (double)this.m_totalTransactions);
        double d3 = d - d2;
        return d3;
    }

    public double convictionForRule(AprioriItemSet aprioriItemSet, AprioriItemSet aprioriItemSet2, int n, int n2) {
        double d = (double)n * (double)(this.m_totalTransactions - n2) / (double)this.m_totalTransactions;
        double d2 = n - aprioriItemSet2.m_counter + 1;
        if (d < 0.0 || d2 < 0.0) {
            System.err.println("*** " + d + " " + d2);
            System.err.println("premis count: " + n + " consequence count " + n2 + " total trans " + this.m_totalTransactions);
        }
        return d / d2;
    }

    public FastVector[] generateRules(double d, FastVector fastVector, int n) {
        int n2;
        FastVector fastVector2 = new FastVector();
        FastVector fastVector3 = new FastVector();
        FastVector fastVector4 = new FastVector();
        FastVector[] fastVectorArray = new FastVector[3];
        Hashtable hashtable = (Hashtable)fastVector.elementAt(n - 2);
        for (n2 = 0; n2 < this.m_items.length; ++n2) {
            if (this.m_items[n2] == -1) continue;
            AprioriItemSet aprioriItemSet = new AprioriItemSet(this.m_totalTransactions);
            AprioriItemSet aprioriItemSet2 = new AprioriItemSet(this.m_totalTransactions);
            aprioriItemSet.m_items = new int[this.m_items.length];
            aprioriItemSet2.m_items = new int[this.m_items.length];
            aprioriItemSet2.m_counter = this.m_counter;
            for (int i = 0; i < this.m_items.length; ++i) {
                aprioriItemSet2.m_items[i] = -1;
            }
            System.arraycopy(this.m_items, 0, aprioriItemSet.m_items, 0, this.m_items.length);
            aprioriItemSet.m_items[n2] = -1;
            aprioriItemSet2.m_items[n2] = this.m_items[n2];
            aprioriItemSet.m_counter = (Integer)hashtable.get(aprioriItemSet);
            fastVector2.addElement(aprioriItemSet);
            fastVector3.addElement(aprioriItemSet2);
            fastVector4.addElement(new Double(AprioriItemSet.confidenceForRule(aprioriItemSet, aprioriItemSet2)));
        }
        fastVectorArray[0] = fastVector2;
        fastVectorArray[1] = fastVector3;
        fastVectorArray[2] = fastVector4;
        AprioriItemSet.pruneRules(fastVectorArray, d);
        FastVector[] fastVectorArray2 = this.moreComplexRules(fastVectorArray, n, 1, d, fastVector);
        if (fastVectorArray2 != null) {
            for (n2 = 0; n2 < fastVectorArray2[0].size(); ++n2) {
                fastVectorArray[0].addElement(fastVectorArray2[0].elementAt(n2));
                fastVectorArray[1].addElement(fastVectorArray2[1].elementAt(n2));
                fastVectorArray[2].addElement(fastVectorArray2[2].elementAt(n2));
            }
        }
        return fastVectorArray;
    }

    public final FastVector[] generateRulesBruteForce(double d, int n, FastVector fastVector, int n2, int n3, double d2) throws Exception {
        FastVector fastVector2 = new FastVector();
        FastVector fastVector3 = new FastVector();
        FastVector fastVector4 = new FastVector();
        FastVector fastVector5 = new FastVector();
        FastVector fastVector6 = new FastVector();
        FastVector fastVector7 = new FastVector();
        FastVector[] fastVectorArray = new FastVector[6];
        double[][] dArray = new double[2][2];
        int n4 = (int)Math.pow(2.0, n2);
        for (int i = 1; i < n4; ++i) {
            double d3;
            int n5;
            int n6 = 0;
            for (n5 = i; n5 > 0; n5 /= 2) {
                if (n5 % 2 != 1) continue;
                ++n6;
            }
            if (n6 >= n2) continue;
            Hashtable hashtable = (Hashtable)fastVector.elementAt(n6 - 1);
            Hashtable hashtable2 = (Hashtable)fastVector.elementAt(n2 - n6 - 1);
            AprioriItemSet aprioriItemSet = new AprioriItemSet(this.m_totalTransactions);
            AprioriItemSet aprioriItemSet2 = new AprioriItemSet(this.m_totalTransactions);
            aprioriItemSet.m_items = new int[this.m_items.length];
            aprioriItemSet2.m_items = new int[this.m_items.length];
            aprioriItemSet2.m_counter = this.m_counter;
            n5 = i;
            for (int j = 0; j < this.m_items.length; ++j) {
                if (this.m_items[j] != -1) {
                    if (n5 % 2 == 1) {
                        aprioriItemSet.m_items[j] = this.m_items[j];
                        aprioriItemSet2.m_items[j] = -1;
                    } else {
                        aprioriItemSet.m_items[j] = -1;
                        aprioriItemSet2.m_items[j] = this.m_items[j];
                    }
                    n5 /= 2;
                    continue;
                }
                aprioriItemSet.m_items[j] = -1;
                aprioriItemSet2.m_items[j] = -1;
            }
            aprioriItemSet.m_counter = (Integer)hashtable.get(aprioriItemSet);
            int n7 = (Integer)hashtable2.get(aprioriItemSet2);
            if (n == 0) {
                dArray[0][0] = aprioriItemSet2.m_counter;
                dArray[0][1] = aprioriItemSet.m_counter - aprioriItemSet2.m_counter;
                dArray[1][0] = n7 - aprioriItemSet2.m_counter;
                dArray[1][1] = n3 - aprioriItemSet.m_counter - n7 + aprioriItemSet2.m_counter;
                double d4 = ContingencyTables.chiSquared(dArray, false);
                d3 = AprioriItemSet.confidenceForRule(aprioriItemSet, aprioriItemSet2);
                if (d3 < d || d4 > d2) continue;
                fastVector2.addElement(aprioriItemSet);
                fastVector3.addElement(aprioriItemSet2);
                fastVector4.addElement(new Double(d3));
                fastVector5.addElement(new Double(this.liftForRule(aprioriItemSet, aprioriItemSet2, n7)));
                fastVector6.addElement(new Double(this.leverageForRule(aprioriItemSet, aprioriItemSet2, aprioriItemSet.m_counter, n7)));
                fastVector7.addElement(new Double(this.convictionForRule(aprioriItemSet, aprioriItemSet2, aprioriItemSet.m_counter, n7)));
                continue;
            }
            double d5 = AprioriItemSet.confidenceForRule(aprioriItemSet, aprioriItemSet2);
            double d6 = this.liftForRule(aprioriItemSet, aprioriItemSet2, n7);
            double d7 = this.leverageForRule(aprioriItemSet, aprioriItemSet2, aprioriItemSet.m_counter, n7);
            double d8 = this.convictionForRule(aprioriItemSet, aprioriItemSet2, aprioriItemSet.m_counter, n7);
            switch (n) {
                case 1: {
                    d3 = d6;
                    break;
                }
                case 2: {
                    d3 = d7;
                    break;
                }
                case 3: {
                    d3 = d8;
                    break;
                }
                default: {
                    throw new Exception("ItemSet: Unknown metric type!");
                }
            }
            if (d3 < d) continue;
            fastVector2.addElement(aprioriItemSet);
            fastVector3.addElement(aprioriItemSet2);
            fastVector4.addElement(new Double(d5));
            fastVector5.addElement(new Double(d6));
            fastVector6.addElement(new Double(d7));
            fastVector7.addElement(new Double(d8));
        }
        fastVectorArray[0] = fastVector2;
        fastVectorArray[1] = fastVector3;
        fastVectorArray[2] = fastVector4;
        fastVectorArray[3] = fastVector5;
        fastVectorArray[4] = fastVector6;
        fastVectorArray[5] = fastVector7;
        return fastVectorArray;
    }

    public final AprioriItemSet subtract(AprioriItemSet aprioriItemSet) {
        AprioriItemSet aprioriItemSet2 = new AprioriItemSet(this.m_totalTransactions);
        aprioriItemSet2.m_items = new int[this.m_items.length];
        for (int i = 0; i < this.m_items.length; ++i) {
            aprioriItemSet2.m_items[i] = aprioriItemSet.m_items[i] == -1 ? this.m_items[i] : -1;
        }
        aprioriItemSet2.m_counter = 0;
        return aprioriItemSet2;
    }

    private final FastVector[] moreComplexRules(FastVector[] fastVectorArray, int n, int n2, double d, FastVector fastVector) {
        FastVector fastVector2 = new FastVector();
        FastVector fastVector3 = new FastVector();
        if (n > n2 + 1) {
            Hashtable hashtable = (Hashtable)fastVector.elementAt(n - n2 - 2);
            FastVector fastVector4 = AprioriItemSet.mergeAllItemSets(fastVectorArray[1], n2 - 1, this.m_totalTransactions);
            Enumeration enumeration = fastVector4.elements();
            while (enumeration.hasMoreElements()) {
                AprioriItemSet aprioriItemSet = (AprioriItemSet)enumeration.nextElement();
                aprioriItemSet.m_counter = this.m_counter;
                AprioriItemSet aprioriItemSet2 = this.subtract(aprioriItemSet);
                aprioriItemSet2.m_counter = (Integer)hashtable.get(aprioriItemSet2);
                fastVector2.addElement(aprioriItemSet2);
                fastVector3.addElement(new Double(AprioriItemSet.confidenceForRule(aprioriItemSet2, aprioriItemSet)));
            }
            FastVector[] fastVectorArray2 = new FastVector[]{fastVector2, fastVector4, fastVector3};
            AprioriItemSet.pruneRules(fastVectorArray2, d);
            FastVector[] fastVectorArray3 = this.moreComplexRules(fastVectorArray2, n, n2 + 1, d, fastVector);
            if (fastVectorArray3 != null) {
                for (int i = 0; i < fastVectorArray3[0].size(); ++i) {
                    fastVectorArray2[0].addElement(fastVectorArray3[0].elementAt(i));
                    fastVectorArray2[1].addElement(fastVectorArray3[1].elementAt(i));
                    fastVectorArray2[2].addElement(fastVectorArray3[2].elementAt(i));
                }
            }
            return fastVectorArray2;
        }
        return null;
    }

    public final String toString(Instances instances) {
        return super.toString(instances);
    }

    public static FastVector singletons(Instances instances) throws Exception {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            int n = 0;
            while (n < instances.attribute(i).numValues()) {
                AprioriItemSet aprioriItemSet = new AprioriItemSet(instances.numInstances());
                aprioriItemSet.m_items = new int[instances.numAttributes()];
                for (int j = 0; j < instances.numAttributes(); ++j) {
                    aprioriItemSet.m_items[j] = -1;
                }
                aprioriItemSet.m_items[i] = n++;
                fastVector.addElement(aprioriItemSet);
            }
        }
        return fastVector;
    }

    public static FastVector mergeAllItemSets(FastVector fastVector, int n, int n2) {
        FastVector fastVector2 = new FastVector();
        block0: for (int i = 0; i < fastVector.size(); ++i) {
            ItemSet itemSet = (ItemSet)fastVector.elementAt(i);
            for (int j = i + 1; j < fastVector.size(); ++j) {
                ItemSet itemSet2 = (ItemSet)fastVector.elementAt(j);
                AprioriItemSet aprioriItemSet = new AprioriItemSet(n2);
                aprioriItemSet.m_items = new int[itemSet.m_items.length];
                int n3 = 0;
                int n4 = 0;
                while (n3 < n) {
                    if (itemSet.m_items[n4] != itemSet2.m_items[n4]) continue block0;
                    if (itemSet.m_items[n4] != -1) {
                        ++n3;
                    }
                    aprioriItemSet.m_items[n4] = itemSet.m_items[n4];
                    ++n4;
                }
                while (n4 < itemSet.m_items.length && (itemSet.m_items[n4] == -1 || itemSet2.m_items[n4] == -1)) {
                    aprioriItemSet.m_items[n4] = itemSet.m_items[n4] != -1 ? itemSet.m_items[n4] : itemSet2.m_items[n4];
                    ++n4;
                }
                if (n4 != itemSet.m_items.length) continue;
                aprioriItemSet.m_counter = 0;
                fastVector2.addElement(aprioriItemSet);
            }
        }
        return fastVector2;
    }
}

