/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.BorderLayout;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;

public class InstanceTable
extends JPanel
implements Serializable,
InstanceListener {
    private JTable m_InstanceTable;
    private boolean m_Debug;
    private boolean m_Clear;
    private String m_UpdateString;
    private Instances m_Instances;

    public void inputFormat(Instances instances) {
        if (this.m_Debug) {
            System.err.println("InstanceTable::inputFormat()\n" + instances.toString());
        }
        this.m_Instances = instances;
    }

    public void input(Instance instance) throws Exception {
        if (this.m_Debug) {
            System.err.println("InstanceTable::input(" + instance + ")");
        }
        this.m_Instances.add(instance);
    }

    public void batchFinished() {
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public String getColumnName(int n) {
                return InstanceTable.this.m_Instances.attribute(n).name();
            }

            public Class getColumnClass(int n) {
                return "".getClass();
            }

            public int getColumnCount() {
                return InstanceTable.this.m_Instances.numAttributes();
            }

            public int getRowCount() {
                return InstanceTable.this.m_Instances.numInstances();
            }

            public Object getValueAt(int n, int n2) {
                return new String(InstanceTable.this.m_Instances.instance(n).toString(n2));
            }
        };
        this.m_InstanceTable.setModel(abstractTableModel);
        if (this.m_Debug) {
            System.err.println("InstanceTable::batchFinished()");
        }
    }

    public InstanceTable() {
        this.setLayout(new BorderLayout());
        this.m_InstanceTable = new JTable();
        this.add("Center", new JScrollPane(this.m_InstanceTable));
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void instanceProduced(InstanceEvent instanceEvent) {
        Object object = instanceEvent.getSource();
        if (object instanceof InstanceProducer) {
            try {
                InstanceProducer instanceProducer = (InstanceProducer)object;
                switch (instanceEvent.getID()) {
                    case 1: {
                        this.inputFormat(instanceProducer.outputFormat());
                        break;
                    }
                    case 2: {
                        this.input(instanceProducer.outputPeek());
                        break;
                    }
                    case 3: {
                        this.batchFinished();
                        break;
                    }
                    default: {
                        System.err.println("InstanceTable::instanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            System.err.println("InstanceTable::instanceProduced() - Unknown source object type");
        }
    }
}

