/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLDocument {
    public static final String PI = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    public static final String DTD_DOCTYPE = "DOCTYPE";
    public static final String DTD_ELEMENT = "ELEMENT";
    public static final String DTD_ATTLIST = "ATTLIST";
    public static final String DTD_OPTIONAL = "?";
    public static final String DTD_AT_LEAST_ONE = "+";
    public static final String DTD_ZERO_OR_MORE = "*";
    public static final String DTD_SEPARATOR = "|";
    public static final String DTD_CDATA = "CDATA";
    public static final String DTD_ANY = "ANY";
    public static final String DTD_PCDATA = "#PCDATA";
    public static final String DTD_IMPLIED = "#IMPLIED";
    public static final String DTD_REQUIRED = "#REQUIRED";
    public static final String ATT_VERSION = "version";
    public static final String ATT_NAME = "name";
    public static final String VAL_YES = "yes";
    public static final String VAL_NO = "no";
    protected DocumentBuilderFactory m_Factory = DocumentBuilderFactory.newInstance();
    protected DocumentBuilder m_Builder = null;
    protected boolean m_Validating = false;
    protected Document m_Document = null;
    protected String m_DocType = null;
    protected String m_RootNode = null;

    public XMLDocument() throws Exception {
        this.setDocType(null);
        this.setRootNode(null);
        this.setValidating(false);
    }

    public XMLDocument(String string) throws Exception {
        this();
        this.read(string);
    }

    public XMLDocument(File file) throws Exception {
        this();
        this.read(file);
    }

    public XMLDocument(InputStream inputStream) throws Exception {
        this();
        this.read(inputStream);
    }

    public XMLDocument(Reader reader) throws Exception {
        this();
        this.read(reader);
    }

    public DocumentBuilderFactory getFactory() {
        return this.m_Factory;
    }

    public DocumentBuilder getBuilder() {
        return this.m_Builder;
    }

    public boolean getValidating() {
        return this.m_Validating;
    }

    public void setValidating(boolean bl) throws Exception {
        this.m_Validating = bl;
        this.m_Factory.setValidating(bl);
        this.m_Builder = this.m_Factory.newDocumentBuilder();
        this.clear();
    }

    public Document getDocument() {
        return this.m_Document;
    }

    public void setDocument(Document document) {
        this.m_Document = document;
    }

    public void setDocType(String string) {
        this.m_DocType = string;
    }

    public String getDocType() {
        return this.m_DocType;
    }

    public void setRootNode(String string) {
        this.m_RootNode = string == null ? "root" : string;
    }

    public String getRootNode() {
        return this.m_RootNode;
    }

    public void clear() {
        this.newDocument(this.getDocType(), this.getRootNode());
    }

    public Document newDocument(String string, String string2) {
        this.m_Document = this.getBuilder().newDocument();
        this.m_Document.appendChild(this.m_Document.createElement(string2));
        this.setDocType(string);
        return this.getDocument();
    }

    public Document read(String string) throws Exception {
        if (string.toLowerCase().indexOf("<?xml") > -1) {
            return this.read(new ByteArrayInputStream(string.getBytes()));
        }
        return this.read(new File(string));
    }

    public Document read(File file) throws Exception {
        this.m_Document = this.getBuilder().parse(file);
        return this.getDocument();
    }

    public Document read(InputStream inputStream) throws Exception {
        this.m_Document = this.getBuilder().parse(inputStream);
        return this.getDocument();
    }

    public Document read(Reader reader) throws Exception {
        this.m_Document = this.getBuilder().parse(new InputSource(reader));
        return this.getDocument();
    }

    public void write(String string) throws Exception {
        this.write(new File(string));
    }

    public void write(File file) throws Exception {
        this.write(new BufferedWriter(new FileWriter(file)));
    }

    public void write(OutputStream outputStream) throws Exception {
        String string = this.toString();
        outputStream.write(string.getBytes(), 0, string.length());
        outputStream.flush();
    }

    public void write(Writer writer) throws Exception {
        writer.write(this.toString());
        writer.flush();
    }

    public static Vector getChildTags(Node node) {
        return XMLDocument.getChildTags(node, "");
    }

    public static Vector getChildTags(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element) || string.length() != 0 && !((Element)nodeList.item(i)).getTagName().equals(string)) continue;
            vector.add(nodeList.item(i));
        }
        return vector;
    }

    public static String getContent(Element element) {
        String string = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            string = string + node.getNodeValue();
        }
        return string.trim();
    }

    protected StringBuffer toString(StringBuffer stringBuffer, Node node, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "   ";
        }
        if (node.getNodeType() == 3) {
            if (!node.getNodeValue().trim().equals("")) {
                stringBuffer.append(string + node.getNodeValue().trim() + "\n");
            }
        } else if (node.getNodeType() == 8) {
            stringBuffer.append(string + "<!--" + node.getNodeValue() + "-->\n");
        } else {
            Node node2;
            int n2;
            stringBuffer.append(string + "<" + node.getNodeName());
            if (node.hasAttributes()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                    node2 = namedNodeMap.item(n2);
                    stringBuffer.append(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                }
            }
            if (node.hasChildNodes()) {
                NodeList nodeList = node.getChildNodes();
                if (nodeList.getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    stringBuffer.append(">");
                    stringBuffer.append(nodeList.item(0).getNodeValue().trim());
                    stringBuffer.append("</" + node.getNodeName() + ">\n");
                } else {
                    stringBuffer.append(">\n");
                    for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                        node2 = nodeList.item(n2);
                        this.toString(stringBuffer, node2, n + 1);
                    }
                    stringBuffer.append(string + "</" + node.getNodeName() + ">\n");
                }
            } else {
                stringBuffer.append("/>\n");
            }
        }
        return stringBuffer;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        String string = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n";
        if (this.getDocType() != null) {
            string = string + this.getDocType() + "\n\n";
        }
        return this.toString(new StringBuffer(string), this.getDocument().getDocumentElement(), 0).toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            XMLDocument xMLDocument = new XMLDocument();
            xMLDocument.read(stringArray[0]);
            xMLDocument.print();
            if (stringArray.length > 1) {
                xMLDocument.write(stringArray[1]);
            }
        }
    }
}

