/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import weka.classifiers.rules.Rule;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RuleStats
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -5708153367675298624L;
    private Instances m_Data = null;
    private FastVector m_Ruleset = null;
    private FastVector m_SimpleStats = null;
    private FastVector m_Filtered = null;
    private double m_Total = -1.0;
    private static double REDUNDANCY_FACTOR = 0.5;
    private double MDL_THEORY_WEIGHT = 1.0;
    private FastVector m_Distributions = null;

    public RuleStats() {
    }

    public RuleStats(Instances instances, FastVector fastVector) {
        this();
        this.m_Data = instances;
        this.m_Ruleset = fastVector;
    }

    public void setNumAllConds(double d) {
        this.m_Total = d < 0.0 ? RuleStats.numAllConditions(this.m_Data) : d;
    }

    public void setData(Instances instances) {
        this.m_Data = instances;
    }

    public Instances getData() {
        return this.m_Data;
    }

    public void setRuleset(FastVector fastVector) {
        this.m_Ruleset = fastVector;
    }

    public FastVector getRuleset() {
        return this.m_Ruleset;
    }

    public int getRulesetSize() {
        return this.m_Ruleset.size();
    }

    public double[] getSimpleStats(int n) {
        if (this.m_SimpleStats != null && n < this.m_SimpleStats.size()) {
            return (double[])this.m_SimpleStats.elementAt(n);
        }
        return null;
    }

    public Instances[] getFiltered(int n) {
        if (this.m_Filtered != null && n < this.m_Filtered.size()) {
            return (Instances[])this.m_Filtered.elementAt(n);
        }
        return null;
    }

    public double[] getDistributions(int n) {
        if (this.m_Distributions != null && n < this.m_Distributions.size()) {
            return (double[])this.m_Distributions.elementAt(n);
        }
        return null;
    }

    public void setMDLTheoryWeight(double d) {
        this.MDL_THEORY_WEIGHT = d;
    }

    public static double numAllConditions(Instances instances) {
        double d = 0.0;
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.isNominal()) {
                d += (double)attribute.numValues();
                continue;
            }
            d += 2.0 * (double)instances.numDistinctValues(attribute);
        }
        return d;
    }

    public void countData() {
        if (this.m_Filtered != null || this.m_Ruleset == null || this.m_Data == null) {
            return;
        }
        int n = this.m_Ruleset.size();
        this.m_Filtered = new FastVector(n);
        this.m_SimpleStats = new FastVector(n);
        this.m_Distributions = new FastVector(n);
        Instances instances = new Instances(this.m_Data);
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[6];
            double[] dArray2 = new double[this.m_Data.classAttribute().numValues()];
            Instances[] instancesArray = this.computeSimpleStats(i, instances, dArray, dArray2);
            this.m_Filtered.addElement(instancesArray);
            this.m_SimpleStats.addElement(dArray);
            this.m_Distributions.addElement(dArray2);
            instances = instancesArray[1];
        }
    }

    public void countData(int n, Instances instances, double[][] dArray) {
        int n2;
        if (this.m_Filtered != null || this.m_Ruleset == null) {
            return;
        }
        int n3 = this.m_Ruleset.size();
        this.m_Filtered = new FastVector(n3);
        this.m_SimpleStats = new FastVector(n3);
        Instances[] instancesArray = new Instances[2];
        instancesArray[1] = instances;
        for (n2 = 0; n2 < n; ++n2) {
            this.m_SimpleStats.addElement(dArray[n2]);
            if (n2 + 1 == n) {
                this.m_Filtered.addElement(instancesArray);
                continue;
            }
            this.m_Filtered.addElement(new Object());
        }
        for (n2 = n; n2 < n3; ++n2) {
            double[] dArray2 = new double[6];
            Instances[] instancesArray2 = this.computeSimpleStats(n2, instancesArray[1], dArray2, null);
            this.m_Filtered.addElement(instancesArray2);
            this.m_SimpleStats.addElement(dArray2);
            instancesArray = instancesArray2;
        }
    }

    private Instances[] computeSimpleStats(int n, Instances instances, double[] dArray, double[] dArray2) {
        Rule rule = (Rule)this.m_Ruleset.elementAt(n);
        Instances[] instancesArray = new Instances[]{new Instances(instances, instances.numInstances()), new Instances(instances, instances.numInstances())};
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            double d = instance.weight();
            if (rule.covers(instance)) {
                instancesArray[0].add(instance);
                dArray[0] = dArray[0] + d;
                if ((int)instance.classValue() == (int)rule.getConsequent()) {
                    dArray[2] = dArray[2] + d;
                } else {
                    dArray[4] = dArray[4] + d;
                }
                if (dArray2 == null) continue;
                int n2 = (int)instance.classValue();
                dArray2[n2] = dArray2[n2] + d;
                continue;
            }
            instancesArray[1].add(instance);
            dArray[1] = dArray[1] + d;
            if ((int)instance.classValue() != (int)rule.getConsequent()) {
                dArray[3] = dArray[3] + d;
                continue;
            }
            dArray[5] = dArray[5] + d;
        }
        return instancesArray;
    }

    public void addAndUpdate(Rule rule) {
        if (this.m_Ruleset == null) {
            this.m_Ruleset = new FastVector();
        }
        this.m_Ruleset.addElement(rule);
        Instances instances = this.m_Filtered == null ? this.m_Data : ((Instances[])this.m_Filtered.lastElement())[1];
        double[] dArray = new double[6];
        double[] dArray2 = new double[this.m_Data.classAttribute().numValues()];
        Instances[] instancesArray = this.computeSimpleStats(this.m_Ruleset.size() - 1, instances, dArray, dArray2);
        if (this.m_Filtered == null) {
            this.m_Filtered = new FastVector();
        }
        this.m_Filtered.addElement(instancesArray);
        if (this.m_SimpleStats == null) {
            this.m_SimpleStats = new FastVector();
        }
        this.m_SimpleStats.addElement(dArray);
        if (this.m_Distributions == null) {
            this.m_Distributions = new FastVector();
        }
        this.m_Distributions.addElement(dArray2);
    }

    public static double subsetDL(double d, double d2, double d3) {
        double d4 = Utils.gr(d3, 0.0) ? -d2 * Utils.log2(d3) : 0.0;
        return d4 -= (d - d2) * Utils.log2(1.0 - d3);
    }

    public double theoryDL(int n) {
        double d = ((Rule)this.m_Ruleset.elementAt(n)).size();
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = Utils.log2(d);
        if (d > 1.0) {
            d2 += 2.0 * Utils.log2(d2);
        }
        return this.MDL_THEORY_WEIGHT * REDUNDANCY_FACTOR * (d2 += RuleStats.subsetDL(this.m_Total, d, d / this.m_Total));
    }

    public static double dataDL(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8 = Utils.log2(d2 + d3 + 1.0);
        if (Utils.gr(d2, d3)) {
            double d9 = d * (d4 + d5);
            d7 = RuleStats.subsetDL(d2, d4, d9 / d2);
            d6 = Utils.gr(d3, 0.0) ? RuleStats.subsetDL(d3, d5, d5 / d3) : 0.0;
        } else {
            double d10 = (1.0 - d) * (d4 + d5);
            d7 = Utils.gr(d2, 0.0) ? RuleStats.subsetDL(d2, d4, d4 / d2) : 0.0;
            d6 = RuleStats.subsetDL(d3, d5, d10 / d3);
        }
        return d8 + d7 + d6;
    }

    public double potential(int n, double d, double[] dArray, double[] dArray2, boolean bl) {
        double d2 = dArray[0] - dArray2[0];
        double d3 = dArray[1] + dArray2[0];
        double d4 = dArray[4] - dArray2[4];
        double d5 = dArray[5] + dArray2[2];
        double d6 = RuleStats.dataDL(d, dArray[0], dArray[1], dArray[4], dArray[5]);
        double d7 = this.theoryDL(n);
        double d8 = RuleStats.dataDL(d, d2, d3, d4, d5);
        double d9 = d6 + d7 - d8;
        double d10 = dArray2[4] / dArray2[0];
        boolean bl2 = Utils.grOrEq(d10, 0.5);
        if (!bl) {
            bl2 = false;
        }
        if (Utils.grOrEq(d9, 0.0) || bl2) {
            dArray[0] = d2;
            dArray[1] = d3;
            dArray[4] = d4;
            dArray[5] = d5;
            return d9;
        }
        return Double.NaN;
    }

    public double minDataDLIfDeleted(int n, double d, boolean bl) {
        double[] dArray = new double[6];
        int n2 = this.m_Ruleset.size() - 1 - n;
        FastVector fastVector = new FastVector(n2);
        for (int i = 0; i < n; ++i) {
            dArray[0] = dArray[0] + ((double[])this.m_SimpleStats.elementAt(i))[0];
            dArray[2] = dArray[2] + ((double[])this.m_SimpleStats.elementAt(i))[2];
            dArray[4] = dArray[4] + ((double[])this.m_SimpleStats.elementAt(i))[4];
        }
        Instances instances = n == 0 ? this.m_Data : ((Instances[])this.m_Filtered.elementAt(n - 1))[1];
        for (int i = n + 1; i < this.m_Ruleset.size(); ++i) {
            double[] dArray2 = new double[6];
            Instances[] instancesArray = this.computeSimpleStats(i, instances, dArray2, null);
            fastVector.addElement(dArray2);
            dArray[0] = dArray[0] + dArray2[0];
            dArray[2] = dArray[2] + dArray2[2];
            dArray[4] = dArray[4] + dArray2[4];
            instances = instancesArray[1];
        }
        if (n2 > 0) {
            dArray[1] = ((double[])fastVector.lastElement())[1];
            dArray[3] = ((double[])fastVector.lastElement())[3];
            dArray[5] = ((double[])fastVector.lastElement())[5];
        } else if (n > 0) {
            dArray[1] = ((double[])this.m_SimpleStats.elementAt(n - 1))[1];
            dArray[3] = ((double[])this.m_SimpleStats.elementAt(n - 1))[3];
            dArray[5] = ((double[])this.m_SimpleStats.elementAt(n - 1))[5];
        } else {
            dArray[1] = ((double[])this.m_SimpleStats.elementAt(0))[0] + ((double[])this.m_SimpleStats.elementAt(0))[1];
            dArray[3] = ((double[])this.m_SimpleStats.elementAt(0))[3] + ((double[])this.m_SimpleStats.elementAt(0))[4];
            dArray[5] = ((double[])this.m_SimpleStats.elementAt(0))[2] + ((double[])this.m_SimpleStats.elementAt(0))[5];
        }
        double d2 = 0.0;
        for (int i = n + 1; i < this.m_Ruleset.size(); ++i) {
            double[] dArray3 = (double[])fastVector.elementAt(i - n - 1);
            double d3 = this.potential(i, d, dArray, dArray3, bl);
            if (Double.isNaN(d3)) continue;
            d2 += d3;
        }
        double d4 = RuleStats.dataDL(d, dArray[0], dArray[1], dArray[4], dArray[5]);
        return d4 - d2;
    }

    public double minDataDLIfExists(int n, double d, boolean bl) {
        double[] dArray = new double[6];
        for (int i = 0; i < this.m_SimpleStats.size(); ++i) {
            dArray[0] = dArray[0] + ((double[])this.m_SimpleStats.elementAt(i))[0];
            dArray[2] = dArray[2] + ((double[])this.m_SimpleStats.elementAt(i))[2];
            dArray[4] = dArray[4] + ((double[])this.m_SimpleStats.elementAt(i))[4];
            if (i != this.m_SimpleStats.size() - 1) continue;
            dArray[1] = ((double[])this.m_SimpleStats.elementAt(i))[1];
            dArray[3] = ((double[])this.m_SimpleStats.elementAt(i))[3];
            dArray[5] = ((double[])this.m_SimpleStats.elementAt(i))[5];
        }
        double d2 = 0.0;
        for (int i = n + 1; i < this.m_SimpleStats.size(); ++i) {
            double[] dArray2 = this.getSimpleStats(i);
            double d3 = this.potential(i, d, dArray, dArray2, bl);
            if (Double.isNaN(d3)) continue;
            d2 += d3;
        }
        double d4 = RuleStats.dataDL(d, dArray[0], dArray[1], dArray[4], dArray[5]);
        return d4 - d2;
    }

    public double relativeDL(int n, double d, boolean bl) {
        return this.minDataDLIfExists(n, d, bl) + this.theoryDL(n) - this.minDataDLIfDeleted(n, d, bl);
    }

    public void reduceDL(double d, boolean bl) {
        int n;
        boolean bl2 = false;
        double[] dArray = new double[6];
        for (n = 0; n < this.m_SimpleStats.size(); ++n) {
            dArray[0] = dArray[0] + ((double[])this.m_SimpleStats.elementAt(n))[0];
            dArray[2] = dArray[2] + ((double[])this.m_SimpleStats.elementAt(n))[2];
            dArray[4] = dArray[4] + ((double[])this.m_SimpleStats.elementAt(n))[4];
            if (n != this.m_SimpleStats.size() - 1) continue;
            dArray[1] = ((double[])this.m_SimpleStats.elementAt(n))[1];
            dArray[3] = ((double[])this.m_SimpleStats.elementAt(n))[3];
            dArray[5] = ((double[])this.m_SimpleStats.elementAt(n))[5];
        }
        for (n = this.m_SimpleStats.size() - 1; n >= 0; --n) {
            double[] dArray2 = (double[])this.m_SimpleStats.elementAt(n);
            double d2 = this.potential(n, d, dArray, dArray2, bl);
            if (Double.isNaN(d2)) continue;
            if (n == this.m_SimpleStats.size() - 1) {
                this.removeLast();
                continue;
            }
            this.m_Ruleset.removeElementAt(n);
            bl2 = true;
        }
        if (bl2) {
            this.m_Filtered = null;
            this.m_SimpleStats = null;
            this.countData();
        }
    }

    public void removeLast() {
        int n = this.m_Ruleset.size() - 1;
        this.m_Ruleset.removeElementAt(n);
        this.m_Filtered.removeElementAt(n);
        this.m_SimpleStats.removeElementAt(n);
        if (this.m_Distributions != null) {
            this.m_Distributions.removeElementAt(n);
        }
    }

    public static Instances rmCoveredBySuccessives(Instances instances, FastVector fastVector, int n) {
        Instances instances2 = new Instances(instances, 0);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            boolean bl = false;
            for (int j = n + 1; j < fastVector.size(); ++j) {
                Rule rule = (Rule)fastVector.elementAt(j);
                if (!rule.covers(instance)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            instances2.add(instance);
        }
        return instances2;
    }

    public static final Instances stratify(Instances instances, int n, Random random) {
        int n2;
        if (!instances.classAttribute().isNominal()) {
            return instances;
        }
        Instances instances2 = new Instances(instances, 0);
        Instances[] instancesArray = new Instances[instances.numClasses()];
        for (n2 = 0; n2 < instancesArray.length; ++n2) {
            instancesArray[n2] = new Instances(instances, 0);
        }
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            Instance instance = instances.instance(n2);
            instancesArray[(int)instance.classValue()].add(instance);
        }
        for (n2 = 0; n2 < instancesArray.length; ++n2) {
            instancesArray[n2].randomize(random);
        }
        block3: for (n2 = 0; n2 < n; ++n2) {
            int n3 = n2;
            int n4 = 0;
            while (true) {
                if (n3 >= instancesArray[n4].numInstances()) {
                    n3 -= instancesArray[n4].numInstances();
                    if (++n4 < instancesArray.length) continue;
                    continue block3;
                }
                instances2.add(instancesArray[n4].instance(n3));
                n3 += n;
            }
        }
        return instances2;
    }

    public double combinedDL(double d, double d2) {
        double d3 = 0.0;
        if (this.getRulesetSize() > 0) {
            double[] dArray = (double[])this.m_SimpleStats.lastElement();
            for (int i = this.getRulesetSize() - 2; i >= 0; --i) {
                dArray[0] = dArray[0] + this.getSimpleStats(i)[0];
                dArray[2] = dArray[2] + this.getSimpleStats(i)[2];
                dArray[4] = dArray[4] + this.getSimpleStats(i)[4];
            }
            d3 += RuleStats.dataDL(d, dArray[0], dArray[1], dArray[4], dArray[5]);
        } else {
            double d4 = 0.0;
            for (int i = 0; i < this.m_Data.numInstances(); ++i) {
                if ((int)this.m_Data.instance(i).classValue() != (int)d2) continue;
                d4 += this.m_Data.instance(i).weight();
            }
            d3 += RuleStats.dataDL(d, 0.0, this.m_Data.sumOfWeights(), 0.0, d4);
        }
        for (int i = 0; i < this.getRulesetSize(); ++i) {
            d3 += this.theoryDL(i);
        }
        return d3;
    }

    public static final Instances[] partition(Instances instances, int n) {
        Instances[] instancesArray = new Instances[2];
        int n2 = instances.numInstances() * (n - 1) / n;
        instancesArray[0] = new Instances(instances, 0, n2);
        instancesArray[1] = new Instances(instances, n2, instances.numInstances() - n2);
        return instancesArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

