/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.InputStreamReader;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.classifiers.evaluation.TwoClassStats;
import weka.classifiers.functions.Logistic;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ThresholdCurve
implements RevisionHandler {
    public static final String RELATION_NAME = "ThresholdCurve";
    public static final String TRUE_POS_NAME = "True Positives";
    public static final String FALSE_NEG_NAME = "False Negatives";
    public static final String FALSE_POS_NAME = "False Positives";
    public static final String TRUE_NEG_NAME = "True Negatives";
    public static final String FP_RATE_NAME = "False Positive Rate";
    public static final String TP_RATE_NAME = "True Positive Rate";
    public static final String PRECISION_NAME = "Precision";
    public static final String RECALL_NAME = "Recall";
    public static final String FALLOUT_NAME = "Fallout";
    public static final String FMEASURE_NAME = "FMeasure";
    public static final String THRESHOLD_NAME = "Threshold";

    public Instances getCurve(FastVector fastVector) {
        if (fastVector.size() == 0) {
            return null;
        }
        return this.getCurve(fastVector, ((NominalPrediction)fastVector.elementAt(0)).distribution().length - 1);
    }

    public Instances getCurve(FastVector fastVector, int n) {
        Object object;
        if (fastVector.size() == 0 || ((NominalPrediction)fastVector.elementAt(0)).distribution().length <= n) {
            return null;
        }
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = this.getProbabilities(fastVector, n);
        for (int i = 0; i < dArray.length; ++i) {
            object = (NominalPrediction)fastVector.elementAt(i);
            if (((NominalPrediction)object).actual() == Prediction.MISSING_VALUE) {
                System.err.println(this.getClass().getName() + " Skipping prediction with missing class value");
                continue;
            }
            if (((NominalPrediction)object).weight() < 0.0) {
                System.err.println(this.getClass().getName() + " Skipping prediction with negative weight");
                continue;
            }
            if (((NominalPrediction)object).actual() == (double)n) {
                d += ((NominalPrediction)object).weight();
                continue;
            }
            d2 += ((NominalPrediction)object).weight();
        }
        Instances instances = this.makeHeader();
        object = Utils.sort(dArray);
        TwoClassStats twoClassStats = new TwoClassStats(d, d2, 0.0, 0.0);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < ((Object)object).length; ++i) {
            NominalPrediction nominalPrediction;
            if (i == 0 || dArray[object[i]] > d3) {
                twoClassStats.setTruePositive(twoClassStats.getTruePositive() - d4);
                twoClassStats.setFalseNegative(twoClassStats.getFalseNegative() + d4);
                twoClassStats.setFalsePositive(twoClassStats.getFalsePositive() - d5);
                twoClassStats.setTrueNegative(twoClassStats.getTrueNegative() + d5);
                d3 = dArray[object[i]];
                instances.add(this.makeInstance(twoClassStats, d3));
                d4 = 0.0;
                d5 = 0.0;
                if (i == ((Object)object).length - 1) break;
            }
            if ((nominalPrediction = (NominalPrediction)fastVector.elementAt((int)object[i])).actual() == Prediction.MISSING_VALUE) {
                System.err.println(this.getClass().getName() + " Skipping prediction with missing class value");
                continue;
            }
            if (nominalPrediction.weight() < 0.0) {
                System.err.println(this.getClass().getName() + " Skipping prediction with negative weight");
                continue;
            }
            if (nominalPrediction.actual() == (double)n) {
                d4 += nominalPrediction.weight();
                continue;
            }
            d5 += nominalPrediction.weight();
        }
        return instances;
    }

    public static double getNPointPrecision(Instances instances, int n) {
        if (!RELATION_NAME.equals(instances.relationName()) || instances.numInstances() == 0) {
            return Double.NaN;
        }
        int n2 = instances.attribute(RECALL_NAME).index();
        int n3 = instances.attribute(PRECISION_NAME).index();
        double[] dArray = instances.attributeToDoubleArray(n2);
        int[] nArray = Utils.sort(dArray);
        double d = 1.0 / (double)(n - 1);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n4 = ThresholdCurve.binarySearch(nArray, dArray, (double)i * d);
            double d3 = dArray[nArray[n4]];
            double d4 = instances.instance(nArray[n4]).value(n3);
            while (n4 != 0 && n4 < nArray.length - 1) {
                double d5;
                if ((d5 = dArray[nArray[++n4]]) == d3) continue;
                double d6 = instances.instance(nArray[n4]).value(n3);
                double d7 = (d6 - d4) / (d5 - d3);
                double d8 = d4 - d3 * d7;
                d4 = d * (double)i * d7 + d8;
                break;
            }
            d2 += d4;
        }
        return d2 / (double)n;
    }

    public static double getROCArea(Instances instances) {
        int n = instances.numInstances();
        if (!RELATION_NAME.equals(instances.relationName()) || n == 0) {
            return Double.NaN;
        }
        int n2 = instances.attribute(TRUE_POS_NAME).index();
        int n3 = instances.attribute(FALSE_POS_NAME).index();
        double[] dArray = instances.attributeToDoubleArray(n2);
        double[] dArray2 = instances.attributeToDoubleArray(n3);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = dArray[0];
        double d4 = dArray2[0];
        for (int i = 0; i < n; ++i) {
            double d5;
            double d6;
            if (i < n - 1) {
                d6 = dArray[i] - dArray[i + 1];
                d5 = dArray2[i] - dArray2[i + 1];
            } else {
                d6 = dArray[n - 1];
                d5 = dArray2[n - 1];
            }
            d += d6 * (d2 + 0.5 * d5);
            d2 += d5;
        }
        return d /= d4 * d3;
    }

    public static int getThresholdInstance(Instances instances, double d) {
        if (!RELATION_NAME.equals(instances.relationName()) || instances.numInstances() == 0 || d < 0.0 || d > 1.0) {
            return -1;
        }
        if (instances.numInstances() == 1) {
            return 0;
        }
        double[] dArray = instances.attributeToDoubleArray(instances.numAttributes() - 1);
        int[] nArray = Utils.sort(dArray);
        return ThresholdCurve.binarySearch(nArray, dArray, d);
    }

    private static int binarySearch(int[] nArray, double[] dArray, double d) {
        int n = 0;
        int n2 = nArray.length - 1;
        while (n2 - n > 1) {
            int n3 = n + (n2 - n) / 2;
            double d2 = dArray[nArray[n3]];
            if (d > d2) {
                n = n3;
                continue;
            }
            if (d < d2) {
                n2 = n3;
                continue;
            }
            while (n3 > 0 && dArray[nArray[n3 - 1]] == d) {
                --n3;
            }
            return n3;
        }
        return n;
    }

    private double[] getProbabilities(FastVector fastVector, int n) {
        double[] dArray = new double[fastVector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            NominalPrediction nominalPrediction = (NominalPrediction)fastVector.elementAt(i);
            dArray[i] = nominalPrediction.distribution()[n];
        }
        return dArray;
    }

    private Instances makeHeader() {
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Attribute(TRUE_POS_NAME));
        fastVector.addElement(new Attribute(FALSE_NEG_NAME));
        fastVector.addElement(new Attribute(FALSE_POS_NAME));
        fastVector.addElement(new Attribute(TRUE_NEG_NAME));
        fastVector.addElement(new Attribute(FP_RATE_NAME));
        fastVector.addElement(new Attribute(TP_RATE_NAME));
        fastVector.addElement(new Attribute(PRECISION_NAME));
        fastVector.addElement(new Attribute(RECALL_NAME));
        fastVector.addElement(new Attribute(FALLOUT_NAME));
        fastVector.addElement(new Attribute(FMEASURE_NAME));
        fastVector.addElement(new Attribute(THRESHOLD_NAME));
        return new Instances(RELATION_NAME, fastVector, 100);
    }

    private Instance makeInstance(TwoClassStats twoClassStats, double d) {
        int n = 0;
        double[] dArray = new double[11];
        dArray[n++] = twoClassStats.getTruePositive();
        dArray[n++] = twoClassStats.getFalseNegative();
        dArray[n++] = twoClassStats.getFalsePositive();
        dArray[n++] = twoClassStats.getTrueNegative();
        dArray[n++] = twoClassStats.getFalsePositiveRate();
        dArray[n++] = twoClassStats.getTruePositiveRate();
        dArray[n++] = twoClassStats.getPrecision();
        dArray[n++] = twoClassStats.getRecall();
        dArray[n++] = twoClassStats.getFallout();
        dArray[n++] = twoClassStats.getFMeasure();
        dArray[n++] = d;
        return new Instance(1.0, dArray);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.23 $");
    }

    public static void main(String[] stringArray) {
        try {
            Instances instances = new Instances(new InputStreamReader(System.in));
            instances.setClassIndex(instances.numAttributes() - 1);
            ThresholdCurve thresholdCurve = new ThresholdCurve();
            EvaluationUtils evaluationUtils = new EvaluationUtils();
            Logistic logistic = new Logistic();
            FastVector fastVector = new FastVector();
            for (int i = 0; i < 2; ++i) {
                evaluationUtils.setSeed(i);
                fastVector.appendElements(evaluationUtils.getCVPredictions(logistic, instances, 10));
            }
            Instances instances2 = thresholdCurve.getCurve(fastVector);
            System.out.println(instances2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

