/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.kdtrees.KDTreeNode;
import weka.core.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class SlidingMidPointOfWidestSide
extends KDTreeNodeSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 852857628205680562L;
    protected static double ERR = 0.001;

    public String globalInfo() {
        return "The class that splits a node into two based on the midpoint value of the dimension in which the node's rectangle is widest. If after splitting one side is empty then it is slided towards the non-empty side until there is at least one point on the empty side.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MANUAL);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "David M. Mount");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "ANN Programming Manual");
        technicalInformation.setValue(TechnicalInformation.Field.ORGANIZATION, "Department of Computer Science, University of Maryland");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "College Park, MD, USA");
        technicalInformation.setValue(TechnicalInformation.Field.HTTP, "Available from http://www.cs.umd.edu/~mount/ANN/");
        return technicalInformation;
    }

    public void splitNode(KDTreeNode kDTreeNode, int n, double[][] dArray, double[][] dArray2) throws Exception {
        double d;
        int n2;
        this.correctlyInitialized();
        if (kDTreeNode.m_NodesRectBounds == null) {
            kDTreeNode.m_NodesRectBounds = new double[2][kDTreeNode.m_NodeRanges.length];
            for (int i = 0; i < kDTreeNode.m_NodeRanges.length; ++i) {
                kDTreeNode.m_NodesRectBounds[0][i] = kDTreeNode.m_NodeRanges[i][0];
                kDTreeNode.m_NodesRectBounds[1][i] = kDTreeNode.m_NodeRanges[i][1];
            }
        }
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n3 = -1;
        int n4 = this.m_Instances.classIndex();
        for (n2 = 0; n2 < kDTreeNode.m_NodesRectBounds[0].length; ++n2) {
            if (n2 == n4) continue;
            d = kDTreeNode.m_NodesRectBounds[1][n2] - kDTreeNode.m_NodesRectBounds[0][n2];
            if (this.m_NormalizeNodeWidth) {
                d /= dArray2[n2][2];
            }
            if (!(d > d2) || !(kDTreeNode.m_NodeRanges[n2][2] > 0.0)) continue;
            d2 = d;
        }
        for (n2 = 0; n2 < kDTreeNode.m_NodesRectBounds[0].length; ++n2) {
            if (n2 == n4) continue;
            d = kDTreeNode.m_NodesRectBounds[1][n2] - kDTreeNode.m_NodesRectBounds[0][n2];
            if (this.m_NormalizeNodeWidth) {
                d /= dArray2[n2][2];
            }
            if (!(d >= d2 * (1.0 - ERR)) || !(kDTreeNode.m_NodeRanges[n2][2] > 0.0) || !(kDTreeNode.m_NodeRanges[n2][2] > d3)) continue;
            d3 = kDTreeNode.m_NodeRanges[n2][2];
            if (this.m_NormalizeNodeWidth) {
                d3 /= dArray2[n2][2];
            }
            n3 = n2;
        }
        double d4 = kDTreeNode.m_NodesRectBounds[0][n3] + (kDTreeNode.m_NodesRectBounds[1][n3] - kDTreeNode.m_NodesRectBounds[0][n3]) * 0.5;
        if (d4 < kDTreeNode.m_NodeRanges[n3][0]) {
            d4 = kDTreeNode.m_NodeRanges[n3][0];
        } else if (d4 >= kDTreeNode.m_NodeRanges[n3][1]) {
            d4 = kDTreeNode.m_NodeRanges[n3][1] - kDTreeNode.m_NodeRanges[n3][2] * 0.001;
        }
        int n5 = this.rearrangePoints(this.m_InstList, kDTreeNode.m_Start, kDTreeNode.m_End, n3, d4);
        if (n5 == kDTreeNode.m_Start || n5 > kDTreeNode.m_End) {
            if (n5 == kDTreeNode.m_Start) {
                throw new Exception("Left child is empty in node " + kDTreeNode.m_NodeNumber + ". Not possible with " + "SlidingMidPointofWidestSide splitting method. Please " + "check code.");
            }
            throw new Exception("Right child is empty in node " + kDTreeNode.m_NodeNumber + ". Not possible with " + "SlidingMidPointofWidestSide splitting method. Please " + "check code.");
        }
        kDTreeNode.m_SplitDim = n3;
        kDTreeNode.m_SplitValue = d4;
        double[][] dArray3 = new double[2][kDTreeNode.m_NodesRectBounds[0].length];
        System.arraycopy(kDTreeNode.m_NodesRectBounds[0], 0, dArray3[0], 0, kDTreeNode.m_NodesRectBounds[0].length);
        System.arraycopy(kDTreeNode.m_NodesRectBounds[1], 0, dArray3[1], 0, kDTreeNode.m_NodesRectBounds[1].length);
        dArray3[1][n3] = d4;
        kDTreeNode.m_Left = new KDTreeNode(n + 1, kDTreeNode.m_Start, n5 - 1, this.m_EuclideanDistance.initializeRanges(this.m_InstList, kDTreeNode.m_Start, n5 - 1), dArray3);
        dArray3 = new double[2][kDTreeNode.m_NodesRectBounds[0].length];
        System.arraycopy(kDTreeNode.m_NodesRectBounds[0], 0, dArray3[0], 0, kDTreeNode.m_NodesRectBounds[0].length);
        System.arraycopy(kDTreeNode.m_NodesRectBounds[1], 0, dArray3[1], 0, kDTreeNode.m_NodesRectBounds[1].length);
        dArray3[0][n3] = d4;
        kDTreeNode.m_Right = new KDTreeNode(n + 2, n5, kDTreeNode.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, n5, kDTreeNode.m_End), dArray3);
    }

    protected int rearrangePoints(int[] nArray, int n, int n2, int n3, double d) {
        int n4 = n - 1;
        for (int i = n; i <= n2; ++i) {
            if (!this.m_EuclideanDistance.valueIsSmallerEqual(this.m_Instances.instance(nArray[i]), n3, d)) continue;
            int n5 = nArray[++n4];
            nArray[n4] = nArray[i];
            nArray[i] = n5;
        }
        return n4 + 1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

