/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.xml.XMLDocument;

public class XMLOptions
implements RevisionHandler {
    public static final String TAG_OPTION = "option";
    public static final String TAG_OPTIONS = "options";
    public static final String ATT_NAME = "name";
    public static final String ATT_TYPE = "type";
    public static final String ATT_VALUE = "value";
    public static final String VAL_TYPE_FLAG = "flag";
    public static final String VAL_TYPE_SINGLE = "single";
    public static final String VAL_TYPE_HYPHENS = "hyphens";
    public static final String VAL_TYPE_QUOTES = "quotes";
    public static final String VAL_TYPE_CLASSIFIER = "classifier";
    public static final String VAL_TYPE_OPTIONHANDLER = "optionhandler";
    public static final String ROOT_NODE = "options";
    public static final String DOCTYPE = "<!DOCTYPE options\n[\n   <!ELEMENT options (option)*>\n   <!ATTLIST options type CDATA \"optionhandler\">\n   <!ATTLIST options value CDATA \"\">\n   <!ELEMENT option (#PCDATA | options)*>\n   <!ATTLIST option name CDATA #REQUIRED>\n   <!ATTLIST option type (flag | single | hyphens | quotes) \"single\">\n]\n>";
    protected XMLDocument m_XMLDocument = new XMLDocument();

    public XMLOptions() throws Exception {
        this.m_XMLDocument.setRootNode("options");
        this.m_XMLDocument.setDocType(DOCTYPE);
        this.setValidating(true);
    }

    public XMLOptions(String string) throws Exception {
        this();
        this.getXMLDocument().read(string);
    }

    public XMLOptions(File file) throws Exception {
        this();
        this.getXMLDocument().read(file);
    }

    public XMLOptions(InputStream inputStream) throws Exception {
        this();
        this.getXMLDocument().read(inputStream);
    }

    public XMLOptions(Reader reader) throws Exception {
        this();
        this.getXMLDocument().read(reader);
    }

    public boolean getValidating() {
        return this.m_XMLDocument.getValidating();
    }

    public void setValidating(boolean bl) throws Exception {
        this.m_XMLDocument.setValidating(bl);
    }

    public Document getDocument() {
        this.fixHyphens();
        return this.m_XMLDocument.getDocument();
    }

    public XMLDocument getXMLDocument() {
        this.fixHyphens();
        return this.m_XMLDocument;
    }

    protected void fixHyphens() {
        int n;
        NodeList nodeList = this.m_XMLDocument.findNodes("//option");
        Vector<Node> vector = new Vector<Node>();
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (!((Element)nodeList.item(n)).getAttribute(ATT_TYPE).equals(VAL_TYPE_HYPHENS)) continue;
            vector.add(nodeList.item(n));
        }
        for (n = 0; n < vector.size(); ++n) {
            Node node = (Node)vector.get(n);
            boolean bl = true;
            Node node2 = node;
            while (node2.getNextSibling() != null) {
                if (node2.getNextSibling().getNodeType() == 1) {
                    bl = false;
                    break;
                }
                node2 = node2.getNextSibling();
            }
            if (bl) continue;
            node2 = node.getParentNode();
            node2.removeChild(node);
            node2.appendChild(node);
        }
    }

    protected String toCommandLine(Element element) {
        Vector<String> vector = new Vector<String>();
        if (element.getNodeName().equals("options")) {
            Vector vector2 = XMLDocument.getChildTags(element);
            if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_CLASSIFIER)) {
                System.err.println("Type 'classifier' is deprecated, use 'optionhandler' instead!");
                element.setAttribute(ATT_TYPE, VAL_TYPE_OPTIONHANDLER);
            }
            if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_OPTIONHANDLER)) {
                vector.add(element.getAttribute(ATT_VALUE));
                if (vector2.size() > 0 && element.getParentNode() != null && element.getParentNode() instanceof Element && ((Element)element.getParentNode()).getNodeName().equals(TAG_OPTION) && ((Element)element.getParentNode()).getAttribute(ATT_TYPE).equals(VAL_TYPE_HYPHENS)) {
                    vector.add("--");
                }
            }
            for (int i = 0; i < vector2.size(); ++i) {
                String string = this.toCommandLine((Element)vector2.get(i));
                try {
                    String[] stringArray = Utils.splitOptions(string);
                    for (int j = 0; j < stringArray.length; ++j) {
                        vector.add(stringArray[j]);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Error splitting: " + string);
                    exception.printStackTrace();
                }
            }
        } else if (element.getNodeName().equals(TAG_OPTION)) {
            Vector vector3 = XMLDocument.getChildTags(element);
            NodeList nodeList = element.getChildNodes();
            vector.add("-" + element.getAttribute(ATT_NAME));
            if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_SINGLE)) {
                if (nodeList.getLength() > 0 && nodeList.item(0).getNodeValue().trim().length() > 0) {
                    vector.add(nodeList.item(0).getNodeValue());
                }
            } else if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_QUOTES)) {
                vector.add(this.toCommandLine((Element)vector3.get(0)));
            } else if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_HYPHENS)) {
                String string = this.toCommandLine((Element)vector3.get(0));
                try {
                    String[] stringArray = Utils.splitOptions(string);
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.add(stringArray[i]);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error splitting: " + string);
                    exception.printStackTrace();
                }
            }
        } else {
            System.err.println("Unsupported tag '" + element.getNodeName() + "' - skipped!");
        }
        return Utils.joinOptions(vector.toArray(new String[vector.size()]));
    }

    public String toCommandLine() throws Exception {
        return this.toCommandLine(this.getDocument().getDocumentElement());
    }

    public String[] toArray() throws Exception {
        return Utils.splitOptions(this.toCommandLine());
    }

    public String toString() {
        return this.getXMLDocument().toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            System.out.println("\nXML:\n\n" + new XMLOptions(stringArray[0]).toString());
            System.out.println("\nCommandline:\n\n" + new XMLOptions(stringArray[0]).toCommandLine());
            System.out.println("\nString array:\n");
            String[] stringArray2 = new XMLOptions(stringArray[0]).toArray();
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println(stringArray2[i]);
            }
        }
    }
}

