/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class NBTreeClassifierTree
extends ClassifierTree {
    private static final long serialVersionUID = -4472639447877404786L;

    public NBTreeClassifierTree(ModelSelection modelSelection) {
        super(modelSelection);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        super.buildClassifier(instances);
        this.cleanup(new Instances(instances, 0));
        this.assignIDs(-1);
    }

    protected ClassifierTree getNewTree(Instances instances) throws Exception {
        NBTreeClassifierTree nBTreeClassifierTree = new NBTreeClassifierTree(this.m_toSelectModel);
        nBTreeClassifierTree.buildTree(instances, false);
        return nBTreeClassifierTree;
    }

    protected ClassifierTree getNewTree(Instances instances, Instances instances2) throws Exception {
        NBTreeClassifierTree nBTreeClassifierTree = new NBTreeClassifierTree(this.m_toSelectModel);
        nBTreeClassifierTree.buildTree(instances, instances2, false);
        return nBTreeClassifierTree;
    }

    public String printLeafModels() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_isLeaf) {
            stringBuffer.append("\nLeaf number: " + this.m_id + " ");
            stringBuffer.append(this.m_localModel.toString());
            stringBuffer.append("\n");
        } else {
            for (int i = 0; i < this.m_sons.length; ++i) {
                stringBuffer.append(((NBTreeClassifierTree)this.m_sons[i]).printLeafModels());
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_isLeaf) {
                stringBuffer.append(": NB");
                stringBuffer.append(this.m_id);
            } else {
                this.dumpTreeNB(0, stringBuffer);
            }
            stringBuffer.append("\n" + this.printLeafModels());
            stringBuffer.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            stringBuffer.append("\nSize of the tree : \t" + this.numNodes() + "\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Can't print nb tree.";
        }
    }

    private void dumpTreeNB(int n, StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("\n");
            for (int j = 0; j < n; ++j) {
                stringBuffer.append("|   ");
            }
            stringBuffer.append(this.m_localModel.leftSide(this.m_train));
            stringBuffer.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf) {
                stringBuffer.append(": NB ");
                stringBuffer.append(this.m_sons[i].m_id);
                continue;
            }
            ((NBTreeClassifierTree)this.m_sons[i]).dumpTreeNB(n + 1, stringBuffer);
        }
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph J48Tree {\n");
        if (this.m_isLeaf) {
            stringBuffer.append("N" + this.m_id + " [label=\"" + "NB model" + "\" " + "shape=box style=filled ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append("data =\n" + this.m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
        } else {
            stringBuffer.append("N" + this.m_id + " [label=\"" + this.m_localModel.leftSide(this.m_train) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append("data =\n" + this.m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
            this.graphTree(stringBuffer);
        }
        return stringBuffer.toString() + "}\n";
    }

    private void graphTree(StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("N" + this.m_id + "->" + "N" + this.m_sons[i].m_id + " [label=\"" + this.m_localModel.rightSide(i, this.m_train).trim() + "\"]\n");
            if (this.m_sons[i].m_isLeaf) {
                stringBuffer.append("N" + this.m_sons[i].m_id + " [label=\"" + "NB Model" + "\" " + "shape=box style=filled ");
                if (this.m_train != null && this.m_train.numInstances() > 0) {
                    stringBuffer.append("data =\n" + this.m_sons[i].m_train + "\n");
                    stringBuffer.append(",\n");
                }
                stringBuffer.append("]\n");
                continue;
            }
            stringBuffer.append("N" + this.m_sons[i].m_id + " [label=\"" + this.m_sons[i].m_localModel.leftSide(this.m_train) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append("data =\n" + this.m_sons[i].m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
            ((NBTreeClassifierTree)this.m_sons[i]).graphTree(stringBuffer);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }
}

