/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class XStream
implements RevisionHandler {
    protected static boolean m_Present = false;
    public static final String FILE_EXTENSION = ".xstream";

    private static void checkForXStream() {
        try {
            Class.forName("com.thoughtworks.xstream.XStream");
            m_Present = true;
        }
        catch (Exception exception) {
            m_Present = false;
        }
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public static String serialize(Object object) throws Exception {
        String string;
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        Class<?> clazz = Class.forName("com.thoughtworks.xstream.XStream");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        classArray[0] = Object.class;
        objectArray[0] = object;
        Method method = clazz.getMethod("toXML", classArray);
        try {
            string = (String)method.invoke(obj, objectArray);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public static boolean write(String string, Object object) throws Exception {
        return XStream.write(new File(string), object);
    }

    public static boolean write(File file, Object object) throws Exception {
        return XStream.write(new BufferedOutputStream(new FileOutputStream(file)), object);
    }

    public static boolean write(OutputStream outputStream, Object object) throws Exception {
        Class[] classArray = new Class[2];
        Object[] objectArray = new Object[2];
        boolean bl = false;
        Class<?> clazz = Class.forName("com.thoughtworks.xstream.XStream");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        classArray[0] = Object.class;
        classArray[1] = OutputStream.class;
        objectArray[0] = object;
        objectArray[1] = outputStream;
        Method method = clazz.getMethod("toXML", classArray);
        try {
            method.invoke(obj, objectArray);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean write(Writer writer, Object object) throws Exception {
        Class[] classArray = new Class[2];
        Object[] objectArray = new Object[2];
        boolean bl = false;
        Class<?> clazz = Class.forName("com.thoughtworks.xstream.XStream");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        classArray[0] = Object.class;
        classArray[1] = Writer.class;
        objectArray[0] = object;
        objectArray[1] = writer;
        Method method = clazz.getMethod("toXML", classArray);
        try {
            method.invoke(obj, objectArray);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static Object read(String string) throws Exception {
        return XStream.read(new File(string));
    }

    public static Object read(File file) throws Exception {
        return XStream.read(new BufferedInputStream(new FileInputStream(file)));
    }

    public static Object read(InputStream inputStream) throws Exception {
        Object object;
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        Class<?> clazz = Class.forName("com.thoughtworks.xstream.XStream");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        classArray[0] = InputStream.class;
        objectArray[0] = inputStream;
        Method method = clazz.getMethod("fromXML", classArray);
        try {
            object = method.invoke(obj, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = null;
        }
        return object;
    }

    public static Object read(Reader reader) throws Exception {
        Object object;
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        Class<?> clazz = Class.forName("com.thoughtworks.xstream.XStream");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        classArray[0] = Reader.class;
        objectArray[0] = reader;
        Method method = clazz.getMethod("fromXML", classArray);
        try {
            object = method.invoke(obj, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = null;
        }
        return object;
    }

    public static Object deSerialize(String string) throws Exception {
        Object object;
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        Class<?> clazz = Class.forName("com.thoughtworks.xstream.XStream");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        classArray[0] = String.class;
        objectArray[0] = string;
        Method method = clazz.getMethod("fromXML", classArray);
        try {
            object = method.invoke(obj, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = null;
        }
        return object;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5562 $");
    }

    static {
        XStream.checkForXStream();
    }
}

