/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.ListSelectorDialog;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SetInstancesPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ClustererPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = -2474932792950820990L;
    protected Explorer m_Explorer = null;
    public static String MODEL_FILE_EXTENSION = ".model";
    protected GenericObjectEditor m_ClustererEditor = new GenericObjectEditor();
    protected PropertyPanel m_CLPanel = new PropertyPanel(this.m_ClustererEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JRadioButton m_PercentBut = new JRadioButton("Percentage split");
    protected JRadioButton m_TrainBut = new JRadioButton("Use training set");
    protected JRadioButton m_TestSplitBut = new JRadioButton("Supplied test set");
    protected JRadioButton m_ClassesToClustersBut = new JRadioButton("Classes to clusters evaluation");
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JLabel m_PercentLab = new JLabel("%", 4);
    protected JTextField m_PercentText = new JTextField("66");
    protected JButton m_SetTestBut = new JButton("Set...");
    protected JFrame m_SetTestFrame;
    protected JButton m_ignoreBut = new JButton("Ignore attributes");
    protected DefaultListModel m_ignoreKeyModel = new DefaultListModel();
    protected JList m_ignoreKeyList = new JList(this.m_ignoreKeyModel);
    ActionListener m_RadioListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClustererPanel.this.updateRadioLinks();
        }
    };
    protected JButton m_StartBut = new JButton("Start");
    private Dimension COMBO_SIZE;
    protected JButton m_StopBut;
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected VisualizePanel m_CurrentVis;
    protected JCheckBox m_StorePredictionsBut;
    protected Thread m_RunThread;
    protected InstancesSummaryPanel m_Summary;
    protected FileFilter m_ModelFilter;
    protected JFileChooser m_FileChooser;

    public ClustererPanel() {
        this.COMBO_SIZE = new Dimension(250, this.m_StartBut.getPreferredSize().height);
        this.m_StopBut = new JButton("Stop");
        this.m_CurrentVis = null;
        this.m_StorePredictionsBut = new JCheckBox("Store clusters for visualization");
        this.m_ModelFilter = new ExtensionFileFilter(MODEL_FILE_EXTENSION, "Model object files");
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16) {
                    ClustererPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder(BorderFactory.createTitledBorder("Result list (right-click for options)"));
        this.m_ClustererEditor.setClassType(Clusterer.class);
        this.m_ClustererEditor.setValue(ExplorerDefaults.getClusterer());
        this.m_ClustererEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClustererPanel.this.m_StartBut.setEnabled(true);
                Capabilities capabilities = ClustererPanel.this.m_ClustererEditor.getCapabilitiesFilter();
                Clusterer clusterer = (Clusterer)ClustererPanel.this.m_ClustererEditor.getValue();
                Capabilities capabilities2 = null;
                if (clusterer != null && capabilities != null && clusterer instanceof CapabilitiesHandler && !(capabilities2 = ((CapabilitiesHandler)((Object)clusterer)).getCapabilities()).supportsMaybe(capabilities) && !capabilities2.supports(capabilities)) {
                    ClustererPanel.this.m_StartBut.setEnabled(false);
                }
                ClustererPanel.this.repaint();
            }
        });
        this.m_TrainBut.setToolTipText("Cluster the same set that the clusterer is trained on");
        this.m_PercentBut.setToolTipText("Train on a percentage of the data and cluster the remainder");
        this.m_TestSplitBut.setToolTipText("Cluster a user-specified dataset");
        this.m_ClassesToClustersBut.setToolTipText("Evaluate clusters with respect to a class");
        this.m_ClassCombo.setToolTipText("Select the class attribute for class based evaluation");
        this.m_StartBut.setToolTipText("Starts the clustering");
        this.m_StopBut.setToolTipText("Stops a running clusterer");
        this.m_StorePredictionsBut.setToolTipText("Store predictions in the result list for later visualization");
        this.m_ignoreBut.setToolTipText("Ignore attributes during clustering");
        this.m_FileChooser.setFileFilter(this.m_ModelFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setEnabled(false);
        this.m_PercentBut.setSelected(ExplorerDefaults.getClustererTestMode() == 2);
        this.m_TrainBut.setSelected(ExplorerDefaults.getClustererTestMode() == 3);
        this.m_TestSplitBut.setSelected(ExplorerDefaults.getClustererTestMode() == 4);
        this.m_ClassesToClustersBut.setSelected(ExplorerDefaults.getClustererTestMode() == 5);
        this.m_StorePredictionsBut.setSelected(ExplorerDefaults.getClustererStoreClustersForVis());
        this.updateRadioLinks();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_TrainBut);
        buttonGroup.add(this.m_PercentBut);
        buttonGroup.add(this.m_TestSplitBut);
        buttonGroup.add(this.m_ClassesToClustersBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_PercentBut.addActionListener(this.m_RadioListener);
        this.m_TestSplitBut.addActionListener(this.m_RadioListener);
        this.m_ClassesToClustersBut.addActionListener(this.m_RadioListener);
        this.m_SetTestBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.setTestSet();
            }
        });
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_ignoreBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.startClusterer();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.stopClusterer();
            }
        });
        this.m_ignoreBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.setIgnoreColumns();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                    int n = ClustererPanel.this.m_History.getList().locationToIndex(mouseEvent.getPoint());
                    if (n != -1) {
                        String string = ClustererPanel.this.m_History.getNameAtIndex(n);
                        ClustererPanel.this.visualizeClusterer(string, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        ClustererPanel.this.visualizeClusterer(null, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.m_ClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.updateCapabilitiesFilter(ClustererPanel.this.m_ClustererEditor.getCapabilitiesFilter());
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Clusterer"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_CLPanel, "North");
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Cluster mode"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_TrainBut, gridBagConstraints);
        jPanel2.add(this.m_TrainBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_TestSplitBut, gridBagConstraints);
        jPanel2.add(this.m_TestSplitBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        gridBagLayout.setConstraints(this.m_SetTestBut, gridBagConstraints);
        jPanel2.add(this.m_SetTestBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_PercentBut, gridBagConstraints);
        jPanel2.add(this.m_PercentBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagLayout.setConstraints(this.m_PercentLab, gridBagConstraints);
        jPanel2.add(this.m_PercentLab);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.ipadx = 20;
        gridBagLayout.setConstraints(this.m_PercentText, gridBagConstraints);
        jPanel2.add(this.m_PercentText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.m_ClassesToClustersBut, gridBagConstraints);
        jPanel2.add(this.m_ClassesToClustersBut);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.m_ClassCombo, gridBagConstraints);
        jPanel2.add(this.m_ClassCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.m_StorePredictionsBut, gridBagConstraints);
        jPanel2.add(this.m_StorePredictionsBut);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel4.add(this.m_StartBut);
        jPanel4.add(this.m_StopBut);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel5.setLayout(new GridLayout(1, 1, 5, 5));
        jPanel5.add(this.m_ignoreBut);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Clusterer output"));
        jPanel6.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_OutText);
        jPanel6.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                int n = jViewport.getViewSize().height;
                if (n != this.lastHeight) {
                    this.lastHeight = n;
                    int n2 = n - jViewport.getExtentSize().height;
                    jViewport.setViewPosition(new Point(0, n2));
                }
            }
        });
        JPanel jPanel7 = new JPanel();
        gridBagLayout = new GridBagLayout();
        jPanel7.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel7.add(jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel7.add(jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.m_History, gridBagConstraints);
        jPanel7.add(this.m_History);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel7.add(jPanel6);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel7, "Center");
    }

    protected void updateRadioLinks() {
        this.m_SetTestBut.setEnabled(this.m_TestSplitBut.isSelected());
        if (this.m_SetTestFrame != null && !this.m_TestSplitBut.isSelected()) {
            this.m_SetTestFrame.setVisible(false);
        }
        this.m_PercentText.setEnabled(this.m_PercentBut.isSelected());
        this.m_PercentLab.setEnabled(this.m_PercentBut.isSelected());
        this.m_ClassCombo.setEnabled(this.m_ClassesToClustersBut.isSelected());
    }

    public void setLog(Logger logger) {
        this.m_Log = logger;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_ignoreKeyModel.removeAllElements();
        String[] stringArray = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            String string = this.m_Instances.attribute(i).name();
            this.m_ignoreKeyModel.addElement(string);
            String string2 = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    string2 = "(Nom) ";
                    break;
                }
                case 0: {
                    string2 = "(Num) ";
                    break;
                }
                case 2: {
                    string2 = "(Str) ";
                    break;
                }
                case 3: {
                    string2 = "(Dat) ";
                    break;
                }
                case 4: {
                    string2 = "(Rel) ";
                    break;
                }
                default: {
                    string2 = "(???) ";
                }
            }
            String string3 = this.m_Instances.attribute(i).name();
            stringArray[i] = string2 + string3;
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
        this.m_ignoreBut.setEnabled(true);
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (instances.classIndex() == -1) {
            this.m_ClassCombo.setSelectedIndex(stringArray.length - 1);
        } else {
            this.m_ClassCombo.setSelectedIndex(instances.classIndex());
        }
        this.updateRadioLinks();
    }

    protected void setTestSet() {
        if (this.m_SetTestFrame == null) {
            final SetInstancesPanel setInstancesPanel = new SetInstancesPanel();
            setInstancesPanel.setReadIncrementally(false);
            this.m_Summary = setInstancesPanel.getSummary();
            if (this.m_TestInstances != null) {
                setInstancesPanel.setInstances(this.m_TestInstances);
            }
            setInstancesPanel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ClustererPanel.this.m_TestInstances = setInstancesPanel.getInstances();
                    ClustererPanel.this.m_TestInstances.setClassIndex(-1);
                }
            });
            this.m_SetTestFrame = new JFrame("Test Instances");
            setInstancesPanel.setParentFrame(this.m_SetTestFrame);
            this.m_SetTestFrame.getContentPane().setLayout(new BorderLayout());
            this.m_SetTestFrame.getContentPane().add((Component)setInstancesPanel, "Center");
            this.m_SetTestFrame.pack();
        }
        this.m_SetTestFrame.setVisible(true);
    }

    public static PlotData2D setUpVisualizableInstances(Instances instances, ClusterEvaluation clusterEvaluation) throws Exception {
        int n;
        int n2;
        int n3 = clusterEvaluation.getNumClusters();
        double[] dArray = clusterEvaluation.getClusterAssignments();
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector();
        for (n2 = 0; n2 < n3; ++n2) {
            fastVector2.addElement("cluster" + n2);
        }
        Attribute attribute = new Attribute("Cluster", fastVector2);
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            fastVector.addElement(instances.attribute(n2).copy());
        }
        fastVector.addElement(attribute);
        Instances instances2 = new Instances(instances.relationName() + "_clustered", fastVector, instances.numInstances());
        int[] nArray = null;
        int[] nArray2 = null;
        if (instances.classIndex() >= 0) {
            nArray2 = clusterEvaluation.getClassesToClusters();
            nArray = new int[instances.numInstances()];
            for (n = 0; n < instances.numInstances(); ++n) {
                nArray[n] = -1;
            }
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            double[] dArray2 = new double[instances2.numAttributes()];
            for (int i = 0; i < instances.numAttributes(); ++i) {
                dArray2[i] = instances.instance(n).value(i);
            }
            dArray2[i] = dArray[n];
            instances2.add(new Instance(1.0, dArray2));
            if (nArray == null || (int)instances.instance(n).classValue() == nArray2[(int)dArray[n]]) continue;
            nArray[n] = 1000;
        }
        PlotData2D plotData2D = new PlotData2D(instances2);
        if (nArray != null) {
            plotData2D.setShapeType(nArray);
        }
        plotData2D.addInstanceNumberAttribute();
        return plotData2D;
    }

    protected void startClusterer() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_ignoreBut.setEnabled(false);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block75: {
                        String string;
                        String string2;
                        Clusterer clusterer;
                        Object[] objectArray;
                        String string3;
                        boolean bl;
                        PlotData2D plotData2D;
                        Instances instances;
                        block72: {
                            int n;
                            Object object;
                            ClustererPanel.this.m_Log.statusMessage("Setting up...");
                            instances = new Instances(ClustererPanel.this.m_Instances);
                            instances.setClassIndex(-1);
                            Instances instances2 = null;
                            plotData2D = null;
                            if (ClustererPanel.this.m_TestInstances != null) {
                                instances2 = new Instances(ClustererPanel.this.m_TestInstances);
                            }
                            bl = ClustererPanel.this.m_StorePredictionsBut.isSelected();
                            string3 = null;
                            objectArray = null;
                            int n2 = 0;
                            int n3 = 66;
                            Clusterer clusterer2 = (Clusterer)ClustererPanel.this.m_ClustererEditor.getValue();
                            clusterer = null;
                            StringBuffer stringBuffer = new StringBuffer();
                            string2 = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                            string = clusterer2.getClass().getName();
                            string2 = string.startsWith("weka.clusterers.") ? string2 + string.substring("weka.clusterers.".length()) : string2 + string;
                            String string4 = ClustererPanel.this.m_ClustererEditor.getValue().getClass().getName();
                            if (ClustererPanel.this.m_ClustererEditor.getValue() instanceof OptionHandler) {
                                string4 = string4 + " " + Utils.joinOptions(((OptionHandler)ClustererPanel.this.m_ClustererEditor.getValue()).getOptions());
                            }
                            ClustererPanel.this.m_Log.logMessage("Started " + string);
                            ClustererPanel.this.m_Log.logMessage("Command: " + string4);
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskStarted();
                            }
                            if (ClustererPanel.this.m_PercentBut.isSelected()) {
                                n2 = 2;
                                n3 = Integer.parseInt(ClustererPanel.this.m_PercentText.getText());
                                if (n3 <= 0 || n3 >= 100) {
                                    throw new Exception("Percentage must be between 0 and 100");
                                }
                            } else if (ClustererPanel.this.m_TrainBut.isSelected()) {
                                n2 = 3;
                            } else if (ClustererPanel.this.m_TestSplitBut.isSelected()) {
                                n2 = 4;
                                if (instances2 == null) {
                                    throw new Exception("No user test set has been opened");
                                }
                                if (!instances.equalHeaders(instances2)) {
                                    throw new Exception("Train and test set are not compatible");
                                }
                            } else if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                n2 = 5;
                            } else {
                                throw new Exception("Unknown test mode");
                            }
                            Instances instances3 = new Instances(instances);
                            if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                instances3.setClassIndex(ClustererPanel.this.m_ClassCombo.getSelectedIndex());
                                instances.setClassIndex(ClustererPanel.this.m_ClassCombo.getSelectedIndex());
                                if (instances.classAttribute().isNumeric()) {
                                    throw new Exception("Class must be nominal for class based evaluation!");
                                }
                            }
                            if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                instances3 = ClustererPanel.this.removeIgnoreCols(instances3);
                            }
                            stringBuffer.append("=== Run information ===\n\n");
                            stringBuffer.append("Scheme:       " + string);
                            if (clusterer2 instanceof OptionHandler) {
                                object = ((OptionHandler)((Object)clusterer2)).getOptions();
                                stringBuffer.append(" " + Utils.joinOptions((String[])object));
                            }
                            stringBuffer.append("\n");
                            stringBuffer.append("Relation:     " + instances.relationName() + '\n');
                            stringBuffer.append("Instances:    " + instances.numInstances() + '\n');
                            stringBuffer.append("Attributes:   " + instances.numAttributes() + '\n');
                            if (instances.numAttributes() < 100) {
                                int n4;
                                object = new boolean[instances.numAttributes()];
                                for (n4 = 0; n4 < instances.numAttributes(); ++n4) {
                                    object[n4] = (String)true;
                                }
                                if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                    int[] nArray = ClustererPanel.this.m_ignoreKeyList.getSelectedIndices();
                                    for (n = 0; n < nArray.length; ++n) {
                                        object[nArray[n]] = (String)false;
                                    }
                                }
                                if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                    object[ClustererPanel.this.m_ClassCombo.getSelectedIndex()] = (String)false;
                                }
                                for (n4 = 0; n4 < instances.numAttributes(); ++n4) {
                                    if (object[n4] == false) continue;
                                    stringBuffer.append("              " + instances.attribute(n4).name() + '\n');
                                }
                                if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty() || ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                    stringBuffer.append("Ignored:\n");
                                    for (n4 = 0; n4 < instances.numAttributes(); ++n4) {
                                        if (object[n4] != false) continue;
                                        stringBuffer.append("              " + instances.attribute(n4).name() + '\n');
                                    }
                                }
                            } else {
                                stringBuffer.append("              [list of attributes omitted]\n");
                            }
                            if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                objectArray = ClustererPanel.this.m_ignoreKeyList.getSelectedIndices();
                            }
                            if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                if (objectArray == null) {
                                    objectArray = new int[]{ClustererPanel.this.m_ClassCombo.getSelectedIndex()};
                                } else {
                                    object = new int[objectArray.length + 1];
                                    System.arraycopy(objectArray, 0, object, 0, objectArray.length);
                                    object[objectArray.length] = (String)ClustererPanel.this.m_ClassCombo.getSelectedIndex();
                                    objectArray = (Object[])object;
                                }
                            }
                            stringBuffer.append("Test mode:    ");
                            switch (n2) {
                                case 3: {
                                    stringBuffer.append("evaluate on training data\n");
                                    break;
                                }
                                case 2: {
                                    stringBuffer.append("split " + n3 + "% train, remainder test\n");
                                    break;
                                }
                                case 4: {
                                    stringBuffer.append("user supplied test set: " + instances2.numInstances() + " instances\n");
                                    break;
                                }
                                case 5: {
                                    stringBuffer.append("Classes to clusters evaluation on training data");
                                }
                            }
                            stringBuffer.append("\n");
                            ClustererPanel.this.m_History.addResult(string2, stringBuffer);
                            ClustererPanel.this.m_History.setSingle(string2);
                            ClustererPanel.this.m_Log.statusMessage("Building model on training data...");
                            clusterer2.buildClusterer(ClustererPanel.this.removeClass(instances3));
                            if (n2 == 2) {
                                stringBuffer.append("\n=== Clustering model (full training set) ===\n\n");
                                stringBuffer.append(clusterer2.toString() + '\n');
                            }
                            ClustererPanel.this.m_History.updateResult(string2);
                            if (clusterer2 instanceof Drawable) {
                                try {
                                    string3 = ((Drawable)((Object)clusterer2)).graph();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            object = new SerializedObject(clusterer2);
                            clusterer = (Clusterer)((SerializedObject)object).getObject();
                            ClusterEvaluation clusterEvaluation = new ClusterEvaluation();
                            clusterEvaluation.setClusterer(clusterer2);
                            switch (n2) {
                                case 3: 
                                case 5: {
                                    ClustererPanel.this.m_Log.statusMessage("Clustering training data...");
                                    clusterEvaluation.evaluateClusterer(instances3);
                                    plotData2D = ClustererPanel.setUpVisualizableInstances(instances, clusterEvaluation);
                                    stringBuffer.append("=== Model and evaluation on training set ===\n\n");
                                    break;
                                }
                                case 2: {
                                    ClustererPanel.this.m_Log.statusMessage("Randomizing instances...");
                                    instances.randomize(new Random(1L));
                                    instances3.randomize(new Random(1L));
                                    n = instances3.numInstances() * n3 / 100;
                                    int n5 = instances3.numInstances() - n;
                                    Instances instances4 = new Instances(instances3, 0, n);
                                    Instances instances5 = new Instances(instances3, n, n5);
                                    Instances instances6 = new Instances(instances, n, n5);
                                    ClustererPanel.this.m_Log.statusMessage("Building model on training split...");
                                    clusterer2.buildClusterer(instances4);
                                    ClustererPanel.this.m_Log.statusMessage("Evaluating on test split...");
                                    clusterEvaluation.evaluateClusterer(instances5);
                                    plotData2D = ClustererPanel.setUpVisualizableInstances(instances6, clusterEvaluation);
                                    stringBuffer.append("=== Model and evaluation on test split ===\n");
                                    break;
                                }
                                case 4: {
                                    ClustererPanel.this.m_Log.statusMessage("Evaluating on test data...");
                                    Instances instances7 = new Instances(instances2);
                                    if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                        instances7 = ClustererPanel.this.removeIgnoreCols(instances7);
                                    }
                                    clusterEvaluation.evaluateClusterer(instances7);
                                    plotData2D = ClustererPanel.setUpVisualizableInstances(instances2, clusterEvaluation);
                                    stringBuffer.append("=== Model and evaluation on test set ===\n");
                                    break;
                                }
                                default: {
                                    throw new Exception("Test mode not implemented");
                                }
                            }
                            stringBuffer.append(clusterEvaluation.clusterResultsToString());
                            stringBuffer.append("\n");
                            ClustererPanel.this.m_History.updateResult(string2);
                            ClustererPanel.this.m_Log.logMessage("Finished " + string);
                            ClustererPanel.this.m_Log.statusMessage("OK");
                            Object var25_28 = null;
                            if (plotData2D == null) break block72;
                            ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                            ClustererPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                            ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                            plotData2D.setPlotName(string2 + " (" + instances.relationName() + ")");
                            try {
                                ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                            }
                            catch (Exception serializable) {
                                System.err.println(serializable);
                            }
                            serializable = new FastVector();
                            ((FastVector)serializable).addElement(clusterer);
                            Instances instances8 = new Instances(ClustererPanel.this.m_Instances, 0);
                            ((FastVector)serializable).addElement(instances8);
                            if (objectArray != null) {
                                ((FastVector)serializable).addElement(objectArray);
                            }
                            if (bl) {
                                ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                if (string3 != null) {
                                    ((FastVector)serializable).addElement(string3);
                                }
                            }
                            ClustererPanel.this.m_History.addObject(string2, serializable);
                        }
                        if (this.isInterrupted()) {
                            ClustererPanel.this.m_Log.logMessage("Interrupted " + string);
                            ClustererPanel.this.m_Log.statusMessage("See error log");
                        }
                        ClustererPanel.this.m_RunThread = null;
                        ClustererPanel.this.m_StartBut.setEnabled(true);
                        ClustererPanel.this.m_StopBut.setEnabled(false);
                        ClustererPanel.this.m_ignoreBut.setEnabled(true);
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                        }
                        break block75;
                        {
                            catch (Exception exception) {
                                exception.printStackTrace();
                                ClustererPanel.this.m_Log.logMessage(exception.getMessage());
                                JOptionPane.showMessageDialog(ClustererPanel.this, "Problem evaluating clusterer:\n" + exception.getMessage(), "Evaluate clusterer", 0);
                                ClustererPanel.this.m_Log.statusMessage("Problem evaluating clusterer");
                                Object var25_29 = null;
                                if (plotData2D != null) {
                                    ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClustererPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                                    ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                    plotData2D.setPlotName(string2 + " (" + instances.relationName() + ")");
                                    try {
                                        ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                                    }
                                    catch (Exception serializable) {
                                        System.err.println(serializable);
                                    }
                                    serializable = new FastVector();
                                    ((FastVector)serializable).addElement(clusterer);
                                    Instances instances9 = new Instances(ClustererPanel.this.m_Instances, 0);
                                    ((FastVector)serializable).addElement(instances9);
                                    if (objectArray != null) {
                                        ((FastVector)serializable).addElement(objectArray);
                                    }
                                    if (bl) {
                                        ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                        if (string3 != null) {
                                            ((FastVector)serializable).addElement(string3);
                                        }
                                    }
                                    ClustererPanel.this.m_History.addObject(string2, serializable);
                                }
                                if (this.isInterrupted()) {
                                    ClustererPanel.this.m_Log.logMessage("Interrupted " + string);
                                    ClustererPanel.this.m_Log.statusMessage("See error log");
                                }
                                ClustererPanel.this.m_RunThread = null;
                                ClustererPanel.this.m_StartBut.setEnabled(true);
                                ClustererPanel.this.m_StopBut.setEnabled(false);
                                ClustererPanel.this.m_ignoreBut.setEnabled(true);
                                if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var25_30 = null;
                            if (plotData2D != null) {
                                ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                ClustererPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                                ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                plotData2D.setPlotName(string2 + " (" + instances.relationName() + ")");
                                try {
                                    ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                                }
                                catch (Exception serializable) {
                                    System.err.println(serializable);
                                }
                                serializable = new FastVector();
                                ((FastVector)serializable).addElement(clusterer);
                                Instances instances10 = new Instances(ClustererPanel.this.m_Instances, 0);
                                ((FastVector)serializable).addElement(instances10);
                                if (objectArray != null) {
                                    ((FastVector)serializable).addElement(objectArray);
                                }
                                if (bl) {
                                    ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                    if (string3 != null) {
                                        ((FastVector)serializable).addElement(string3);
                                    }
                                }
                                ClustererPanel.this.m_History.addObject(string2, serializable);
                            }
                            if (this.isInterrupted()) {
                                ClustererPanel.this.m_Log.logMessage("Interrupted " + string);
                                ClustererPanel.this.m_Log.statusMessage("See error log");
                            }
                            ClustererPanel.this.m_RunThread = null;
                            ClustererPanel.this.m_StartBut.setEnabled(true);
                            ClustererPanel.this.m_StopBut.setEnabled(false);
                            ClustererPanel.this.m_ignoreBut.setEnabled(true);
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    private Instances removeClass(Instances instances) {
        Remove remove = new Remove();
        Instances instances2 = null;
        try {
            if (instances.classIndex() < 0) {
                instances2 = instances;
            } else {
                remove.setAttributeIndices("" + (instances.classIndex() + 1));
                remove.setInvertSelection(false);
                remove.setInputFormat(instances);
                instances2 = Filter.useFilter(instances, remove);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return instances2;
    }

    private Instances removeIgnoreCols(Instances instances) {
        int n;
        if (this.m_ClassesToClustersBut.isSelected() && this.m_ignoreKeyList.isSelectedIndex(n = this.m_ClassCombo.getSelectedIndex())) {
            this.m_ignoreKeyList.removeSelectionInterval(n, n);
        }
        int[] nArray = this.m_ignoreKeyList.getSelectedIndices();
        Remove remove = new Remove();
        Instances instances2 = null;
        try {
            remove.setAttributeIndicesArray(nArray);
            remove.setInvertSelection(false);
            remove.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, remove);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return instances2;
    }

    private Instances removeIgnoreCols(Instances instances, int[] nArray) {
        Remove remove = new Remove();
        Instances instances2 = null;
        try {
            remove.setAttributeIndicesArray(nArray);
            remove.setInvertSelection(false);
            remove.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, remove);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return instances2;
    }

    protected void stopClusterer() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void visualizeTree(String string, String string2) {
        final JFrame jFrame = new JFrame("Weka Classifier Tree Visualizer: " + string2);
        jFrame.setSize(500, 400);
        jFrame.getContentPane().setLayout(new BorderLayout());
        TreeVisualizer treeVisualizer = new TreeVisualizer(null, string, (NodePlace)new PlaceNode2());
        jFrame.getContentPane().add((Component)treeVisualizer, "Center");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setVisible(true);
        treeVisualizer.fitToScreen();
    }

    protected void visualizeClusterAssignments(VisualizePanel visualizePanel) {
        if (visualizePanel != null) {
            String string = visualizePanel.getName();
            final JFrame jFrame = new JFrame("Weka Clusterer Visualize: " + string);
            jFrame.setSize(500, 400);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)visualizePanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.setVisible(true);
        }
    }

    protected void visualizeClusterer(String string, int n, int n2) {
        Object object;
        final String string2 = string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("View in main window");
        if (string2 != null) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.m_History.setSingle(string2);
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("View in separate window");
        if (string2 != null) {
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.m_History.openFrame(string2);
                }
            });
        } else {
            jMenuItem2.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Save result buffer");
        if (string2 != null) {
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.saveBuffer(string2);
                }
            });
        } else {
            jMenuItem3.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Delete result buffer");
        if (string2 != null) {
            jMenuItem4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.m_History.removeResult(string2);
                }
            });
        } else {
            jMenuItem4.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem("Load model");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.loadClusterer();
            }
        });
        jPopupMenu.add(jMenuItem5);
        FastVector fastVector = null;
        if (string2 != null) {
            fastVector = (FastVector)this.m_History.getNamedObject(string2);
        }
        VisualizePanel visualizePanel = null;
        Object object2 = null;
        Clusterer clusterer = null;
        Instances instances = null;
        int[] nArray = null;
        if (fastVector != null) {
            for (int i = 0; i < fastVector.size(); ++i) {
                object = fastVector.elementAt(i);
                if (object instanceof Clusterer) {
                    clusterer = (Clusterer)object;
                    continue;
                }
                if (object instanceof Instances) {
                    instances = (Instances)object;
                    continue;
                }
                if (object instanceof int[]) {
                    nArray = (int[])object;
                    continue;
                }
                if (object instanceof VisualizePanel) {
                    visualizePanel = (VisualizePanel)object;
                    continue;
                }
                if (!(object instanceof String)) continue;
                object2 = (String)object;
            }
        }
        final VisualizePanel visualizePanel2 = visualizePanel;
        object = object2;
        final Clusterer clusterer2 = clusterer;
        final Instances instances2 = instances;
        final int[] nArray2 = nArray;
        JMenuItem jMenuItem6 = new JMenuItem("Save model");
        if (clusterer2 != null) {
            jMenuItem6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.saveClusterer(string2, clusterer2, instances2, nArray2);
                }
            });
        } else {
            jMenuItem6.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Re-evaluate model on current test set");
        if (clusterer2 != null && this.m_TestInstances != null) {
            jMenuItem7.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.reevaluateModel(string2, clusterer2, instances2, nArray2);
                }
            });
        } else {
            jMenuItem7.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem7);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem8 = new JMenuItem("Visualize cluster assignments");
        if (visualizePanel2 != null) {
            jMenuItem8.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.visualizeClusterAssignments(visualizePanel2);
                }
            });
        } else {
            jMenuItem8.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Visualize tree");
        if (object != null) {
            jMenuItem9.addActionListener(new ActionListener((String)object){
                final /* synthetic */ String val$grph;
                {
                    this.val$grph = string22;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = visualizePanel2 != null ? visualizePanel2.getName() : string2;
                    ClustererPanel.this.visualizeTree(this.val$grph, string);
                }
            });
        } else {
            jMenuItem9.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem9);
        jPopupMenu.show(this.m_History.getList(), n, n2);
    }

    protected void saveBuffer(String string) {
        StringBuffer stringBuffer = this.m_History.getNamedBuffer(string);
        if (stringBuffer != null && this.m_SaveOut.save(stringBuffer)) {
            this.m_Log.logMessage("Save successful.");
        }
    }

    private void setIgnoreColumns() {
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, this.m_ignoreKeyList);
        int n = listSelectorDialog.showDialog();
        if (n != 0) {
            this.m_ignoreKeyList.clearSelection();
        }
    }

    protected void saveClusterer(String string, Clusterer clusterer, Instances instances, int[] nArray) {
        File file = null;
        boolean bl = true;
        int n = this.m_FileChooser.showSaveDialog(this);
        if (n == 0) {
            file = this.m_FileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(MODEL_FILE_EXTENSION)) {
                file = new File(file.getParent(), file.getName() + MODEL_FILE_EXTENSION);
            }
            this.m_Log.statusMessage("Saving model to file...");
            try {
                OutputStream outputStream = new FileOutputStream(file);
                if (file.getName().endsWith(".gz")) {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(clusterer);
                if (instances != null) {
                    objectOutputStream.writeObject(instances);
                }
                if (nArray != null) {
                    objectOutputStream.writeObject(nArray);
                }
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception, "Save Failed", 0);
                bl = false;
            }
            if (bl) {
                this.m_Log.logMessage("Saved model (" + string + ") to file '" + file.getName() + "'");
            }
            this.m_Log.statusMessage("OK");
        }
    }

    protected void loadClusterer() {
        int n = this.m_FileChooser.showOpenDialog(this);
        if (n == 0) {
            Object object;
            Object object2;
            File file = this.m_FileChooser.getSelectedFile();
            Clusterer clusterer = null;
            Instances instances = null;
            int[] nArray = null;
            this.m_Log.statusMessage("Loading model from file...");
            try {
                object2 = new FileInputStream(file);
                if (file.getName().endsWith(".gz")) {
                    object2 = new GZIPInputStream((InputStream)object2);
                }
                object = new ObjectInputStream((InputStream)object2);
                clusterer = (Clusterer)((ObjectInputStream)object).readObject();
                try {
                    instances = (Instances)((ObjectInputStream)object).readObject();
                    nArray = (int[])((ObjectInputStream)object).readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((ObjectInputStream)object).close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception, "Load Failed", 0);
            }
            this.m_Log.statusMessage("OK");
            if (clusterer != null) {
                Object object3;
                this.m_Log.logMessage("Loaded model from file '" + file.getName() + "'");
                object2 = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                object = clusterer.getClass().getName();
                if (((String)object).startsWith("weka.clusterers.")) {
                    object = ((String)object).substring("weka.clusterers.".length());
                }
                object2 = (String)object2 + (String)object + " from file '" + file.getName() + "'";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("=== Model information ===\n\n");
                stringBuffer.append("Filename:     " + file.getName() + "\n");
                stringBuffer.append("Scheme:       " + clusterer.getClass().getName());
                if (clusterer instanceof OptionHandler) {
                    object3 = ((OptionHandler)((Object)clusterer)).getOptions();
                    stringBuffer.append(" " + Utils.joinOptions((String[])object3));
                }
                stringBuffer.append("\n");
                if (instances != null) {
                    stringBuffer.append("Relation:     " + instances.relationName() + '\n');
                    stringBuffer.append("Attributes:   " + instances.numAttributes() + '\n');
                    if (instances.numAttributes() < 100) {
                        int n2;
                        object3 = new boolean[instances.numAttributes()];
                        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                            object3[n2] = true;
                        }
                        if (nArray != null) {
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                object3[nArray[n2]] = false;
                            }
                        }
                        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                            if (object3[n2] == false) continue;
                            stringBuffer.append("              " + instances.attribute(n2).name() + '\n');
                        }
                        if (nArray != null) {
                            stringBuffer.append("Ignored:\n");
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                stringBuffer.append("              " + instances.attribute(nArray[n2]).name() + '\n');
                            }
                        }
                    } else {
                        stringBuffer.append("              [list of attributes omitted]\n");
                    }
                } else {
                    stringBuffer.append("\nTraining data unknown\n");
                }
                stringBuffer.append("\n=== Clustering model ===\n\n");
                stringBuffer.append(clusterer.toString() + "\n");
                this.m_History.addResult((String)object2, stringBuffer);
                this.m_History.setSingle((String)object2);
                object3 = new FastVector();
                ((FastVector)object3).addElement(clusterer);
                if (instances != null) {
                    ((FastVector)object3).addElement(instances);
                }
                if (nArray != null) {
                    ((FastVector)object3).addElement(nArray);
                }
                String string = null;
                if (clusterer instanceof Drawable) {
                    try {
                        string = ((Drawable)((Object)clusterer)).graph();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string != null) {
                    ((FastVector)object3).addElement(string);
                }
                this.m_History.addObject((String)object2, object3);
            }
        }
    }

    protected void reevaluateModel(final String string, final Clusterer clusterer, final Instances instances, final int[] nArray) {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_ignoreBut.setEnabled(false);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block37: {
                        Object var5_5;
                        boolean bl;
                        PlotData2D plotData2D;
                        Instances instances3;
                        block34: {
                            ClustererPanel.this.m_Log.statusMessage("Setting up...");
                            StringBuffer stringBuffer = ClustererPanel.this.m_History.getNamedBuffer(string);
                            instances3 = null;
                            plotData2D = null;
                            if (ClustererPanel.this.m_TestInstances != null) {
                                instances3 = new Instances(ClustererPanel.this.m_TestInstances);
                            }
                            bl = ClustererPanel.this.m_StorePredictionsBut.isSelected();
                            var5_5 = null;
                            if (instances3 == null) {
                                throw new Exception("No user test set has been opened");
                            }
                            if (instances != null && !instances.equalHeaders(instances3)) {
                                throw new Exception("Train and test set are not compatible");
                            }
                            ClustererPanel.this.m_Log.statusMessage("Evaluating on test data...");
                            ClustererPanel.this.m_Log.logMessage("Re-evaluating clusterer (" + string + ") on test set");
                            ClustererPanel.this.m_Log.logMessage("Started reevaluate model");
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskStarted();
                            }
                            ClusterEvaluation clusterEvaluation = new ClusterEvaluation();
                            clusterEvaluation.setClusterer(clusterer);
                            Instances instances2 = new Instances(instances3);
                            if (nArray != null) {
                                instances2 = ClustererPanel.this.removeIgnoreCols(instances2, nArray);
                            }
                            clusterEvaluation.evaluateClusterer(instances2);
                            plotData2D = ClustererPanel.setUpVisualizableInstances(instances3, clusterEvaluation);
                            stringBuffer.append("\n=== Re-evaluation on test set ===\n\n");
                            stringBuffer.append("User supplied test set\n");
                            stringBuffer.append("Relation:     " + instances3.relationName() + '\n');
                            stringBuffer.append("Instances:    " + instances3.numInstances() + '\n');
                            stringBuffer.append("Attributes:   " + instances3.numAttributes() + "\n\n");
                            if (instances == null) {
                                stringBuffer.append("NOTE - if test set is not compatible then results are unpredictable\n\n");
                            }
                            stringBuffer.append(clusterEvaluation.clusterResultsToString());
                            stringBuffer.append("\n");
                            ClustererPanel.this.m_History.updateResult(string);
                            ClustererPanel.this.m_Log.logMessage("Finished re-evaluation");
                            ClustererPanel.this.m_Log.statusMessage("OK");
                            Object var9_9 = null;
                            if (plotData2D == null) break block34;
                            ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                            ClustererPanel.this.m_CurrentVis.setName(string + " (" + instances3.relationName() + ")");
                            ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                            plotData2D.setPlotName(string + " (" + instances3.relationName() + ")");
                            try {
                                ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                            }
                            catch (Exception serializable) {
                                System.err.println(serializable);
                            }
                            serializable = new FastVector();
                            ((FastVector)serializable).addElement(clusterer);
                            if (instances != null) {
                                ((FastVector)serializable).addElement(instances);
                            }
                            if (nArray != null) {
                                ((FastVector)serializable).addElement(nArray);
                            }
                            if (bl) {
                                ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                if (var5_5 != null) {
                                    ((FastVector)serializable).addElement(var5_5);
                                }
                            }
                            ClustererPanel.this.m_History.addObject(string, serializable);
                        }
                        if (this.isInterrupted()) {
                            ClustererPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                            ClustererPanel.this.m_Log.statusMessage("See error log");
                        }
                        ClustererPanel.this.m_RunThread = null;
                        ClustererPanel.this.m_StartBut.setEnabled(true);
                        ClustererPanel.this.m_StopBut.setEnabled(false);
                        ClustererPanel.this.m_ignoreBut.setEnabled(true);
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                        }
                        break block37;
                        {
                            catch (Exception exception) {
                                exception.printStackTrace();
                                ClustererPanel.this.m_Log.logMessage(exception.getMessage());
                                JOptionPane.showMessageDialog(ClustererPanel.this, "Problem evaluating clusterer:\n" + exception.getMessage(), "Evaluate clusterer", 0);
                                ClustererPanel.this.m_Log.statusMessage("Problem evaluating clusterer");
                                Object var9_10 = null;
                                if (plotData2D != null) {
                                    ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClustererPanel.this.m_CurrentVis.setName(string + " (" + instances3.relationName() + ")");
                                    ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                    plotData2D.setPlotName(string + " (" + instances3.relationName() + ")");
                                    try {
                                        ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                                    }
                                    catch (Exception serializable) {
                                        System.err.println(serializable);
                                    }
                                    serializable = new FastVector();
                                    ((FastVector)serializable).addElement(clusterer);
                                    if (instances != null) {
                                        ((FastVector)serializable).addElement(instances);
                                    }
                                    if (nArray != null) {
                                        ((FastVector)serializable).addElement(nArray);
                                    }
                                    if (bl) {
                                        ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                        if (var5_5 != null) {
                                            ((FastVector)serializable).addElement(var5_5);
                                        }
                                    }
                                    ClustererPanel.this.m_History.addObject(string, serializable);
                                }
                                if (this.isInterrupted()) {
                                    ClustererPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                                    ClustererPanel.this.m_Log.statusMessage("See error log");
                                }
                                ClustererPanel.this.m_RunThread = null;
                                ClustererPanel.this.m_StartBut.setEnabled(true);
                                ClustererPanel.this.m_StopBut.setEnabled(false);
                                ClustererPanel.this.m_ignoreBut.setEnabled(true);
                                if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            if (plotData2D != null) {
                                ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                ClustererPanel.this.m_CurrentVis.setName(string + " (" + instances3.relationName() + ")");
                                ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                plotData2D.setPlotName(string + " (" + instances3.relationName() + ")");
                                try {
                                    ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                                }
                                catch (Exception serializable) {
                                    System.err.println(serializable);
                                }
                                serializable = new FastVector();
                                ((FastVector)serializable).addElement(clusterer);
                                if (instances != null) {
                                    ((FastVector)serializable).addElement(instances);
                                }
                                if (nArray != null) {
                                    ((FastVector)serializable).addElement(nArray);
                                }
                                if (bl) {
                                    ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                    if (var5_5 != null) {
                                        ((FastVector)serializable).addElement(var5_5);
                                    }
                                }
                                ClustererPanel.this.m_History.addObject(string, serializable);
                            }
                            if (this.isInterrupted()) {
                                ClustererPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                                ClustererPanel.this.m_Log.statusMessage("See error log");
                            }
                            ClustererPanel.this.m_RunThread = null;
                            ClustererPanel.this.m_StartBut.setEnabled(true);
                            ClustererPanel.this.m_StopBut.setEnabled(false);
                            ClustererPanel.this.m_ignoreBut.setEnabled(true);
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void updateCapabilitiesFilter(Capabilities capabilities) {
        Capabilities capabilities2;
        if (capabilities == null) {
            this.m_ClustererEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances instances = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        instances.setClassIndex(-1);
        try {
            capabilities2 = Capabilities.forInstances(instances);
        }
        catch (Exception exception) {
            capabilities2 = new Capabilities(null);
        }
        this.m_ClustererEditor.setCapabilitiesFilter(capabilities2);
        this.m_StartBut.setEnabled(true);
        Capabilities capabilities3 = this.m_ClustererEditor.getCapabilitiesFilter();
        Clusterer clusterer = (Clusterer)this.m_ClustererEditor.getValue();
        Capabilities capabilities4 = null;
        if (clusterer != null && capabilities3 != null && clusterer instanceof CapabilitiesHandler && !(capabilities4 = ((CapabilitiesHandler)((Object)clusterer)).getCapabilities()).supportsMaybe(capabilities3) && !capabilities4.supports(capabilities3)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent capabilitiesFilterChangeEvent) {
        if (capabilitiesFilterChangeEvent.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)capabilitiesFilterChangeEvent.getFilter().clone());
        }
    }

    public void setExplorer(Explorer explorer) {
        this.m_Explorer = explorer;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "Cluster";
    }

    public String getTabTitleToolTip() {
        return "Identify instance clusters";
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Weka Explorer: Cluster");
            jFrame.getContentPane().setLayout(new BorderLayout());
            ClustererPanel clustererPanel = new ClustererPanel();
            jFrame.getContentPane().add((Component)clustererPanel, "Center");
            LogPanel logPanel = new LogPanel();
            clustererPanel.setLog(logPanel);
            jFrame.getContentPane().add((Component)logPanel, "South");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            if (stringArray.length == 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                clustererPanel.setInstances(instances);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

