/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Instance;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.neighboursearch.PerformanceStats;

public abstract class AbstractStringDistanceFunction
extends NormalizableDistance {
    public AbstractStringDistanceFunction() {
    }

    public AbstractStringDistanceFunction(Instances instances) {
        super(instances);
    }

    protected double updateDistance(double d, double d2) {
        return d + d2 * d2;
    }

    protected double difference(int n, String string, String string2) {
        switch (this.m_Data.attribute(n).type()) {
            case 2: {
                double d = this.stringDistance(string, string2);
                if (this.m_DontNormalize) {
                    return d;
                }
                if (string.length() > string2.length()) {
                    return d / (double)string.length();
                }
                return d / (double)string2.length();
            }
        }
        return 0.0;
    }

    public double distance(Instance instance, Instance instance2, double d, PerformanceStats performanceStats) {
        double d2 = 0.0;
        int n = this.m_Data.numAttributes();
        this.validate();
        for (int i = 0; i < n; ++i) {
            double d3 = 0.0;
            if (this.m_ActiveIndices[i]) {
                d3 = this.difference(i, instance.stringValue(i), instance2.stringValue(i));
            }
            if (!((d2 = this.updateDistance(d2, d3)) > d * d)) continue;
            return Double.POSITIVE_INFINITY;
        }
        double d4 = Math.sqrt(d2);
        return d4;
    }

    abstract double stringDistance(String var1, String var2);
}

