/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SingleIndex;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Add
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 761386447332932389L;
    public static final Tag[] TAGS_TYPE = new Tag[]{new Tag(0, "NUM", "Numeric attribute"), new Tag(1, "NOM", "Nominal attribute"), new Tag(2, "STR", "String attribute"), new Tag(3, "DAT", "Date attribute")};
    protected int m_AttributeType = 0;
    protected String m_Name = "unnamed";
    private SingleIndex m_Insert = new SingleIndex("last");
    protected FastVector m_Labels = new FastVector();
    protected String m_DateFormat = "yyyy-MM-dd'T'HH:mm:ss";

    public String globalInfo() {
        return "An instance filter that adds a new attribute to the dataset. The new attribute will contain all missing values.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        String string = "";
        for (int i = 0; i < TAGS_TYPE.length; ++i) {
            SelectedTag selectedTag = new SelectedTag(TAGS_TYPE[i].getID(), TAGS_TYPE);
            string = string + "\t" + selectedTag.getSelectedTag().getIDStr() + " = " + selectedTag.getSelectedTag().getReadable() + "\n";
        }
        vector.addElement(new Option("\tThe type of attribute to create:\n" + string + "\t(default: " + new SelectedTag(0, TAGS_TYPE) + ")", "T", 1, "-T " + Tag.toOptionList(TAGS_TYPE)));
        vector.addElement(new Option("\tSpecify where to insert the column. First and last\n\tare valid indexes.(default: last)", "C", 1, "-C <index>"));
        vector.addElement(new Option("\tName of the new attribute.\n\t(default: 'Unnamed')", "N", 1, "-N <name>"));
        vector.addElement(new Option("\tCreate nominal attribute with given labels\n\t(default: numeric attribute)", "L", 1, "-L <label1,label2,...>"));
        vector.addElement(new Option("\tThe format of the date values (see ISO-8601)\n\t(default: yyyy-MM-dd'T'HH:mm:ss)", "F", 1, "-F <format>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('T', stringArray);
        if (string.length() != 0) {
            this.setAttributeType(new SelectedTag(string, TAGS_TYPE));
        } else {
            this.setAttributeType(new SelectedTag(0, TAGS_TYPE));
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() == 0) {
            string = "last";
        }
        this.setAttributeIndex(string);
        this.setAttributeName(Utils.unbackQuoteChars(Utils.getOption('N', stringArray)));
        if (this.m_AttributeType == 1) {
            string = Utils.getOption('L', stringArray);
            if (string.length() != 0) {
                this.setNominalLabels(string);
            }
        } else if (this.m_AttributeType == 3 && (string = Utils.getOption('F', stringArray)).length() != 0) {
            this.setDateFormat(string);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.m_AttributeType != 0) {
            vector.add("-T");
            vector.add("" + this.getAttributeType());
        }
        vector.add("-N");
        vector.add(Utils.backQuoteChars(this.getAttributeName()));
        if (this.m_AttributeType == 1) {
            vector.add("-L");
            vector.add(this.getNominalLabels());
        } else if (this.m_AttributeType == 1) {
            vector.add("-F");
            vector.add(this.getDateFormat());
        }
        vector.add("-C");
        vector.add("" + this.getAttributeIndex());
        return vector.toArray(new String[vector.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_Insert.setUpper(instances.numAttributes());
        Instances instances2 = new Instances(instances, 0);
        Attribute attribute = null;
        switch (this.m_AttributeType) {
            case 0: {
                attribute = new Attribute(this.m_Name);
                break;
            }
            case 1: {
                attribute = new Attribute(this.m_Name, this.m_Labels);
                break;
            }
            case 2: {
                attribute = new Attribute(this.m_Name, (FastVector)null);
                break;
            }
            case 3: {
                attribute = new Attribute(this.m_Name, this.m_DateFormat);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown attribute type in Add");
            }
        }
        if (this.m_Insert.getIndex() < 0 || this.m_Insert.getIndex() > this.getInputFormat().numAttributes()) {
            throw new IllegalArgumentException("Index out of range");
        }
        instances2.insertAttributeAt(attribute, this.m_Insert.getIndex());
        this.setOutputFormat(instances2);
        Range range = new Range(this.m_Insert.getSingleIndex());
        range.setInvert(true);
        range.setUpper(instances2.numAttributes() - 1);
        this.initOutputLocators(instances2, range.getSelection());
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instance instance2 = (Instance)instance.copy();
        this.copyValues(instance2, true, instance2.dataset(), this.getOutputFormat());
        instance2.setDataset(null);
        instance2.insertAttributeAt(this.m_Insert.getIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String attributeNameTipText() {
        return "Set the new attribute's name.";
    }

    public String getAttributeName() {
        return this.m_Name;
    }

    public void setAttributeName(String string) {
        this.m_Name = string.trim().equals("") ? "unnamed" : string;
    }

    public String attributeIndexTipText() {
        return "The position (starting from 1) where the attribute will be inserted (first and last are valid indices).";
    }

    public String getAttributeIndex() {
        return this.m_Insert.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_Insert.setSingleIndex(string);
    }

    public String nominalLabelsTipText() {
        return "The list of value labels (nominal attribute creation only).  The list must be comma-separated, eg: \"red,green,blue\". If this is empty, the created attribute will be numeric.";
    }

    public String getNominalLabels() {
        String string = "";
        for (int i = 0; i < this.m_Labels.size(); ++i) {
            string = i == 0 ? (String)this.m_Labels.elementAt(i) : string + "," + (String)this.m_Labels.elementAt(i);
        }
        return string;
    }

    public void setNominalLabels(String string) {
        String string2;
        int n;
        FastVector fastVector = new FastVector(10);
        while ((n = string.indexOf(44)) >= 0) {
            string2 = string.substring(0, n).trim();
            if (string2.equals("")) {
                throw new IllegalArgumentException("Invalid label list at " + string.substring(n));
            }
            fastVector.addElement(string2);
            string = string.substring(n + 1);
        }
        string2 = string.trim();
        if (!string2.equals("")) {
            fastVector.addElement(string2);
        }
        this.m_Labels = fastVector;
        this.m_AttributeType = fastVector.size() == 0 ? 0 : 1;
    }

    public String attributeTypeTipText() {
        return "Defines the type of the attribute to generate.";
    }

    public void setAttributeType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_TYPE) {
            this.m_AttributeType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getAttributeType() {
        return new SelectedTag(this.m_AttributeType, TAGS_TYPE);
    }

    public String dateFormatTipText() {
        return "The format of the date values (see ISO-8601).";
    }

    public String getDateFormat() {
        return this.m_DateFormat;
    }

    public void setDateFormat(String string) {
        try {
            new SimpleDateFormat(string);
            this.m_DateFormat = string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5543 $");
    }

    public static void main(String[] stringArray) {
        Add.runFilter(new Add(), stringArray);
    }
}

