/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.Evaluation;
import weka.classifiers.Sourcable;
import weka.classifiers.evaluation.CostCurve;
import weka.classifiers.evaluation.MarginCurve;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.Version;
import weka.core.converters.ConverterUtils;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.Loader;
import weka.core.pmml.PMMLFactory;
import weka.gui.CostMatrixEditor;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SetInstancesPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.plugins.VisualizePlugin;

public class ClassifierPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = 6959973704963624003L;
    protected Explorer m_Explorer = null;
    public static String MODEL_FILE_EXTENSION = ".model";
    public static String PMML_FILE_EXTENSION = ".xml";
    protected GenericObjectEditor m_ClassifierEditor = new GenericObjectEditor();
    protected PropertyPanel m_CEPanel = new PropertyPanel(this.m_ClassifierEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JRadioButton m_CVBut = new JRadioButton("Cross-validation");
    protected JRadioButton m_PercentBut = new JRadioButton("Percentage split");
    protected JRadioButton m_TrainBut = new JRadioButton("Use training set");
    protected JRadioButton m_TestSplitBut = new JRadioButton("Supplied test set");
    protected JCheckBox m_StorePredictionsBut = new JCheckBox("Store predictions for visualization");
    protected JCheckBox m_OutputModelBut = new JCheckBox("Output model");
    protected JCheckBox m_OutputPerClassBut = new JCheckBox("Output per-class stats");
    protected JCheckBox m_OutputConfusionBut = new JCheckBox("Output confusion matrix");
    protected JCheckBox m_OutputEntropyBut = new JCheckBox("Output entropy evaluation measures");
    protected JCheckBox m_OutputPredictionsTextBut = new JCheckBox("Output predictions");
    protected JTextField m_OutputAdditionalAttributesText = new JTextField("", 10);
    protected JLabel m_OutputAdditionalAttributesLab = new JLabel("Output additional attributes");
    protected Range m_OutputAdditionalAttributesRange = null;
    protected JCheckBox m_EvalWRTCostsBut = new JCheckBox("Cost-sensitive evaluation");
    protected JButton m_SetCostsBut = new JButton("Set...");
    protected JLabel m_CVLab = new JLabel("Folds", 4);
    protected JTextField m_CVText = new JTextField("10", 3);
    protected JLabel m_PercentLab = new JLabel("%", 4);
    protected JTextField m_PercentText = new JTextField("66", 3);
    protected JButton m_SetTestBut = new JButton("Set...");
    protected JFrame m_SetTestFrame;
    protected PropertyDialog m_SetCostsFrame;
    ActionListener m_RadioListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClassifierPanel.this.updateRadioLinks();
        }
    };
    JButton m_MoreOptions = new JButton("More options...");
    protected JTextField m_RandomSeedText = new JTextField("1", 3);
    protected JLabel m_RandomLab = new JLabel("Random seed for XVal / % Split", 4);
    protected JCheckBox m_PreserveOrderBut = new JCheckBox("Preserve order for % Split");
    protected JCheckBox m_OutputSourceCode = new JCheckBox("Output source code");
    protected JTextField m_SourceCodeClass = new JTextField("WekaClassifier", 10);
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    private Dimension COMBO_SIZE;
    protected CostMatrixEditor m_CostMatrixEditor;
    protected Instances m_Instances;
    protected Loader m_TestLoader;
    protected Thread m_RunThread;
    protected VisualizePanel m_CurrentVis;
    protected FileFilter m_ModelFilter;
    protected FileFilter m_PMMLModelFilter;
    protected JFileChooser m_FileChooser;

    public ClassifierPanel() {
        this.COMBO_SIZE = new Dimension(150, this.m_StartBut.getPreferredSize().height);
        this.m_CostMatrixEditor = new CostMatrixEditor();
        this.m_CurrentVis = null;
        this.m_ModelFilter = new ExtensionFileFilter(MODEL_FILE_EXTENSION, "Model object files");
        this.m_PMMLModelFilter = new ExtensionFileFilter(PMML_FILE_EXTENSION, "PMML model files");
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16) {
                    ClassifierPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder(BorderFactory.createTitledBorder("Result list (right-click for options)"));
        this.m_ClassifierEditor.setClassType(Classifier.class);
        this.m_ClassifierEditor.setValue(ExplorerDefaults.getClassifier());
        this.m_ClassifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClassifierPanel.this.m_StartBut.setEnabled(true);
                Capabilities capabilities = ClassifierPanel.this.m_ClassifierEditor.getCapabilitiesFilter();
                Classifier classifier = (Classifier)ClassifierPanel.this.m_ClassifierEditor.getValue();
                Capabilities capabilities2 = null;
                if (classifier != null && capabilities != null && classifier instanceof CapabilitiesHandler && !(capabilities2 = classifier.getCapabilities()).supportsMaybe(capabilities) && !capabilities2.supports(capabilities)) {
                    ClassifierPanel.this.m_StartBut.setEnabled(false);
                }
                ClassifierPanel.this.repaint();
            }
        });
        this.m_ClassCombo.setToolTipText("Select the attribute to use as the class");
        this.m_TrainBut.setToolTipText("Test on the same set that the classifier is trained on");
        this.m_CVBut.setToolTipText("Perform a n-fold cross-validation");
        this.m_PercentBut.setToolTipText("Train on a percentage of the data and test on the remainder");
        this.m_TestSplitBut.setToolTipText("Test on a user-specified dataset");
        this.m_StartBut.setToolTipText("Starts the classification");
        this.m_StopBut.setToolTipText("Stops a running classification");
        this.m_StorePredictionsBut.setToolTipText("Store predictions in the result list for later visualization");
        this.m_OutputModelBut.setToolTipText("Output the model obtained from the full training set");
        this.m_OutputPerClassBut.setToolTipText("Output precision/recall & true/false positives for each class");
        this.m_OutputConfusionBut.setToolTipText("Output the matrix displaying class confusions");
        this.m_OutputEntropyBut.setToolTipText("Output entropy-based evaluation measures");
        this.m_EvalWRTCostsBut.setToolTipText("Evaluate errors with respect to a cost matrix");
        this.m_OutputPredictionsTextBut.setToolTipText("Include the predictions in the output buffer");
        this.m_OutputAdditionalAttributesText.setToolTipText("Outputs additional attributes for the predictions, 'first' and 'last' are valid indices.");
        this.m_RandomLab.setToolTipText("The seed value for randomization");
        this.m_RandomSeedText.setToolTipText(this.m_RandomLab.getToolTipText());
        this.m_PreserveOrderBut.setToolTipText("Preserves the order in a percentage split");
        this.m_OutputSourceCode.setToolTipText("Whether to output the built classifier as Java source code");
        this.m_SourceCodeClass.setToolTipText("The classname of the built classifier");
        this.m_FileChooser.addChoosableFileFilter(this.m_PMMLModelFilter);
        this.m_FileChooser.setFileFilter(this.m_ModelFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_StorePredictionsBut.setSelected(ExplorerDefaults.getClassifierStorePredictionsForVis());
        this.m_OutputModelBut.setSelected(ExplorerDefaults.getClassifierOutputModel());
        this.m_OutputPerClassBut.setSelected(ExplorerDefaults.getClassifierOutputPerClassStats());
        this.m_OutputConfusionBut.setSelected(ExplorerDefaults.getClassifierOutputConfusionMatrix());
        this.m_EvalWRTCostsBut.setSelected(ExplorerDefaults.getClassifierCostSensitiveEval());
        this.m_OutputEntropyBut.setSelected(ExplorerDefaults.getClassifierOutputEntropyEvalMeasures());
        this.m_OutputPredictionsTextBut.setSelected(ExplorerDefaults.getClassifierOutputPredictions());
        this.m_OutputPredictionsTextBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierPanel.this.m_OutputAdditionalAttributesText.setEnabled(ClassifierPanel.this.m_OutputPredictionsTextBut.isSelected());
            }
        });
        this.m_OutputAdditionalAttributesText.setText(ExplorerDefaults.getClassifierOutputAdditionalAttributes());
        this.m_OutputAdditionalAttributesText.setEnabled(this.m_OutputPredictionsTextBut.isSelected());
        this.m_RandomSeedText.setText("" + ExplorerDefaults.getClassifierRandomSeed());
        this.m_PreserveOrderBut.setSelected(ExplorerDefaults.getClassifierPreserveOrder());
        this.m_OutputSourceCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierPanel.this.m_SourceCodeClass.setEnabled(ClassifierPanel.this.m_OutputSourceCode.isSelected());
            }
        });
        this.m_OutputSourceCode.setSelected(ExplorerDefaults.getClassifierOutputSourceCode());
        this.m_SourceCodeClass.setText(ExplorerDefaults.getClassifierSourceCodeClass());
        this.m_SourceCodeClass.setEnabled(this.m_OutputSourceCode.isSelected());
        this.m_ClassCombo.setEnabled(false);
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_CVBut.setSelected(true);
        this.m_CVBut.setSelected(ExplorerDefaults.getClassifierTestMode() == 1);
        this.m_PercentBut.setSelected(ExplorerDefaults.getClassifierTestMode() == 2);
        this.m_TrainBut.setSelected(ExplorerDefaults.getClassifierTestMode() == 3);
        this.m_TestSplitBut.setSelected(ExplorerDefaults.getClassifierTestMode() == 4);
        this.m_PercentText.setText("" + ExplorerDefaults.getClassifierPercentageSplit());
        this.m_CVText.setText("" + ExplorerDefaults.getClassifierCrossvalidationFolds());
        this.updateRadioLinks();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_TrainBut);
        buttonGroup.add(this.m_CVBut);
        buttonGroup.add(this.m_PercentBut);
        buttonGroup.add(this.m_TestSplitBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_CVBut.addActionListener(this.m_RadioListener);
        this.m_PercentBut.addActionListener(this.m_RadioListener);
        this.m_TestSplitBut.addActionListener(this.m_RadioListener);
        this.m_SetTestBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierPanel.this.setTestSet();
            }
        });
        this.m_EvalWRTCostsBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierPanel.this.m_SetCostsBut.setEnabled(ClassifierPanel.this.m_EvalWRTCostsBut.isSelected());
                if (ClassifierPanel.this.m_SetCostsFrame != null && !ClassifierPanel.this.m_EvalWRTCostsBut.isSelected()) {
                    ClassifierPanel.this.m_SetCostsFrame.setVisible(false);
                }
            }
        });
        this.m_CostMatrixEditor.setValue(new CostMatrix(1));
        this.m_SetCostsBut.setEnabled(this.m_EvalWRTCostsBut.isSelected());
        this.m_SetCostsBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                ClassifierPanel.this.m_SetCostsBut.setEnabled(false);
                if (ClassifierPanel.this.m_SetCostsFrame == null) {
                    ClassifierPanel.this.m_SetCostsFrame = PropertyDialog.getParentDialog(ClassifierPanel.this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(ClassifierPanel.this), (PropertyEditor)ClassifierPanel.this.m_CostMatrixEditor, 100, 100) : new PropertyDialog(PropertyDialog.getParentFrame(ClassifierPanel.this), (PropertyEditor)ClassifierPanel.this.m_CostMatrixEditor, 100, 100);
                    ClassifierPanel.this.m_SetCostsFrame.setTitle("Cost Matrix Editor");
                    ClassifierPanel.this.m_SetCostsFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            ClassifierPanel.this.m_SetCostsBut.setEnabled(ClassifierPanel.this.m_EvalWRTCostsBut.isSelected());
                            if (ClassifierPanel.this.m_SetCostsFrame != null && !ClassifierPanel.this.m_EvalWRTCostsBut.isSelected()) {
                                ClassifierPanel.this.m_SetCostsFrame.setVisible(false);
                            }
                        }
                    });
                    ClassifierPanel.this.m_SetCostsFrame.setVisible(true);
                }
                if ((n2 = ClassifierPanel.this.m_Instances.attribute(n = ClassifierPanel.this.m_ClassCombo.getSelectedIndex()).numValues()) != ((CostMatrix)ClassifierPanel.this.m_CostMatrixEditor.getValue()).numColumns()) {
                    ClassifierPanel.this.m_CostMatrixEditor.setValue(new CostMatrix(n2));
                }
                ClassifierPanel.this.m_SetCostsFrame.setVisible(true);
            }
        });
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierPanel.this.startClassifier();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierPanel.this.stopClassifier();
            }
        });
        this.m_ClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClassifierPanel.this.m_ClassCombo.getSelectedIndex();
                if (n != -1) {
                    boolean bl = ClassifierPanel.this.m_Instances.attribute(n).isNominal();
                    ClassifierPanel.this.m_OutputPerClassBut.setEnabled(bl);
                    ClassifierPanel.this.m_OutputConfusionBut.setEnabled(bl);
                }
                ClassifierPanel.this.updateCapabilitiesFilter(ClassifierPanel.this.m_ClassifierEditor.getCapabilitiesFilter());
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                    int n = ClassifierPanel.this.m_History.getList().locationToIndex(mouseEvent.getPoint());
                    if (n != -1) {
                        String string = ClassifierPanel.this.m_History.getNameAtIndex(n);
                        ClassifierPanel.this.visualize(string, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        ClassifierPanel.this.visualize(null, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.m_MoreOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierPanel.this.m_MoreOptions.setEnabled(false);
                JPanel jPanel = new JPanel();
                jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
                jPanel.setLayout(new GridLayout(11, 1));
                jPanel.add(ClassifierPanel.this.m_OutputModelBut);
                jPanel.add(ClassifierPanel.this.m_OutputPerClassBut);
                jPanel.add(ClassifierPanel.this.m_OutputEntropyBut);
                jPanel.add(ClassifierPanel.this.m_OutputConfusionBut);
                jPanel.add(ClassifierPanel.this.m_StorePredictionsBut);
                jPanel.add(ClassifierPanel.this.m_OutputPredictionsTextBut);
                JPanel jPanel2 = new JPanel(new FlowLayout(0));
                jPanel2.add(ClassifierPanel.this.m_OutputAdditionalAttributesLab);
                jPanel2.add(ClassifierPanel.this.m_OutputAdditionalAttributesText);
                jPanel.add(jPanel2);
                JPanel jPanel3 = new JPanel(new FlowLayout(0));
                jPanel3.add(ClassifierPanel.this.m_EvalWRTCostsBut);
                jPanel3.add(ClassifierPanel.this.m_SetCostsBut);
                jPanel.add(jPanel3);
                JPanel jPanel4 = new JPanel(new FlowLayout(0));
                jPanel4.add(ClassifierPanel.this.m_RandomLab);
                jPanel4.add(ClassifierPanel.this.m_RandomSeedText);
                jPanel.add(jPanel4);
                jPanel.add(ClassifierPanel.this.m_PreserveOrderBut);
                JPanel jPanel5 = new JPanel(new FlowLayout(0));
                ClassifierPanel.this.m_OutputSourceCode.setEnabled(ClassifierPanel.this.m_ClassifierEditor.getValue() instanceof Sourcable);
                ClassifierPanel.this.m_SourceCodeClass.setEnabled(ClassifierPanel.this.m_OutputSourceCode.isEnabled() && ClassifierPanel.this.m_OutputSourceCode.isSelected());
                jPanel5.add(ClassifierPanel.this.m_OutputSourceCode);
                jPanel5.add(ClassifierPanel.this.m_SourceCodeClass);
                jPanel.add(jPanel5);
                JPanel jPanel6 = new JPanel();
                jPanel6.setLayout(new BorderLayout());
                JButton jButton = new JButton("OK");
                JPanel jPanel7 = new JPanel();
                jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                jPanel7.setLayout(new GridLayout(1, 1, 5, 5));
                jPanel7.add(jButton);
                jPanel6.add((Component)jPanel, "Center");
                jPanel6.add((Component)jPanel7, "South");
                final JDialog jDialog = new JDialog(PropertyDialog.getParentFrame(ClassifierPanel.this), "Classifier evaluation options");
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)jPanel6, "Center");
                jDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        jDialog.dispose();
                        ClassifierPanel.this.m_MoreOptions.setEnabled(true);
                    }
                });
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClassifierPanel.this.m_MoreOptions.setEnabled(true);
                        jDialog.dispose();
                    }
                });
                jDialog.pack();
                jDialog.setLocation(ClassifierPanel.this.m_MoreOptions.getLocationOnScreen());
                jDialog.setVisible(true);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Classifier"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_CEPanel, "North");
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Test options"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_TrainBut, gridBagConstraints);
        jPanel2.add(this.m_TrainBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_TestSplitBut, gridBagConstraints);
        jPanel2.add(this.m_TestSplitBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        gridBagLayout.setConstraints(this.m_SetTestBut, gridBagConstraints);
        jPanel2.add(this.m_SetTestBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_CVBut, gridBagConstraints);
        jPanel2.add(this.m_CVBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagLayout.setConstraints(this.m_CVLab, gridBagConstraints);
        jPanel2.add(this.m_CVLab);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.ipadx = 20;
        gridBagLayout.setConstraints(this.m_CVText, gridBagConstraints);
        jPanel2.add(this.m_CVText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_PercentBut, gridBagConstraints);
        jPanel2.add(this.m_PercentBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagLayout.setConstraints(this.m_PercentLab, gridBagConstraints);
        jPanel2.add(this.m_PercentLab);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.ipadx = 20;
        gridBagLayout.setConstraints(this.m_PercentText, gridBagConstraints);
        jPanel2.add(this.m_PercentText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(3, 0, 1, 0);
        gridBagLayout.setConstraints(this.m_MoreOptions, gridBagConstraints);
        jPanel2.add(this.m_MoreOptions);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 2));
        jPanel3.add(this.m_ClassCombo);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel4.add(this.m_StartBut);
        jPanel4.add(this.m_StopBut);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Classifier output"));
        jPanel5.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_OutText);
        jPanel5.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                int n = jViewport.getViewSize().height;
                if (n != this.lastHeight) {
                    this.lastHeight = n;
                    int n2 = n - jViewport.getExtentSize().height;
                    jViewport.setViewPosition(new Point(0, n2));
                }
            }
        });
        JPanel jPanel6 = new JPanel();
        gridBagLayout = new GridBagLayout();
        jPanel6.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel6.add(jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel6.add(jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.m_History, gridBagConstraints);
        jPanel6.add(this.m_History);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel6.add(jPanel5);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel6, "Center");
    }

    protected void updateRadioLinks() {
        this.m_SetTestBut.setEnabled(this.m_TestSplitBut.isSelected());
        if (this.m_SetTestFrame != null && !this.m_TestSplitBut.isSelected()) {
            this.m_SetTestFrame.setVisible(false);
        }
        this.m_CVText.setEnabled(this.m_CVBut.isSelected());
        this.m_CVLab.setEnabled(this.m_CVBut.isSelected());
        this.m_PercentText.setEnabled(this.m_PercentBut.isSelected());
        this.m_PercentLab.setEnabled(this.m_PercentBut.isSelected());
    }

    public void setLog(Logger logger) {
        this.m_Log = logger;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        String[] stringArray = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    string = "(Nom) ";
                    break;
                }
                case 0: {
                    string = "(Num) ";
                    break;
                }
                case 2: {
                    string = "(Str) ";
                    break;
                }
                case 3: {
                    string = "(Dat) ";
                    break;
                }
                case 4: {
                    string = "(Rel) ";
                    break;
                }
                default: {
                    string = "(???) ";
                }
            }
            stringArray[i] = string + this.m_Instances.attribute(i).name();
        }
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (stringArray.length > 0) {
            if (instances.classIndex() == -1) {
                this.m_ClassCombo.setSelectedIndex(stringArray.length - 1);
            } else {
                this.m_ClassCombo.setSelectedIndex(instances.classIndex());
            }
            this.m_ClassCombo.setEnabled(true);
            this.m_StartBut.setEnabled(this.m_RunThread == null);
            this.m_StopBut.setEnabled(this.m_RunThread != null);
        } else {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(false);
        }
    }

    protected void setTestSet() {
        if (this.m_SetTestFrame == null) {
            final SetInstancesPanel setInstancesPanel = new SetInstancesPanel();
            if (this.m_TestLoader != null) {
                try {
                    if (this.m_TestLoader.getStructure() != null) {
                        setInstancesPanel.setInstances(this.m_TestLoader.getStructure());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            setInstancesPanel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ClassifierPanel.this.m_TestLoader = setInstancesPanel.getLoader();
                }
            });
            this.m_SetTestFrame = new JFrame("Test Instances");
            setInstancesPanel.setParentFrame(this.m_SetTestFrame);
            this.m_SetTestFrame.getContentPane().setLayout(new BorderLayout());
            this.m_SetTestFrame.getContentPane().add((Component)setInstancesPanel, "Center");
            this.m_SetTestFrame.pack();
        }
        this.m_SetTestFrame.setVisible(true);
    }

    public static void processClassifierPrediction(Instance instance, Classifier classifier, Evaluation evaluation, Instances instances, FastVector fastVector, FastVector fastVector2) {
        try {
            double d = evaluation.evaluateModelOnceAndRecordPrediction(classifier, instance);
            if (instances != null) {
                double[] dArray = new double[instances.numAttributes()];
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    if (i < instance.classIndex()) {
                        dArray[i] = instance.value(i);
                        continue;
                    }
                    if (i == instance.classIndex()) {
                        dArray[i] = d;
                        dArray[i + 1] = instance.value(i);
                        ++i;
                        continue;
                    }
                    dArray[i] = instance.value(i - 1);
                }
                instances.add(new Instance(1.0, dArray));
                if (instance.classAttribute().isNominal()) {
                    if (instance.isMissing(instance.classIndex()) || Instance.isMissingValue(d)) {
                        fastVector.addElement(new Integer(2000));
                    } else if (d != instance.classValue()) {
                        fastVector.addElement(new Integer(1000));
                    } else {
                        fastVector.addElement(new Integer(-1));
                    }
                    fastVector2.addElement(new Integer(2));
                } else {
                    Double d2 = null;
                    if (!instance.isMissing(instance.classIndex()) && !Instance.isMissingValue(d)) {
                        d2 = new Double(d - instance.classValue());
                        fastVector.addElement(new Integer(-1));
                    } else {
                        fastVector.addElement(new Integer(2000));
                    }
                    fastVector2.addElement(d2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void postProcessPlotInfo(FastVector fastVector) {
        double d;
        Double d2;
        int n;
        int n2 = 20;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        for (n = 0; n < fastVector.size(); ++n) {
            d2 = (Double)fastVector.elementAt(n);
            if (d2 == null) continue;
            d = Math.abs(d2);
            if (d < d4) {
                d4 = d;
            }
            if (!(d > d3)) continue;
            d3 = d;
        }
        for (n = 0; n < fastVector.size(); ++n) {
            d2 = (Double)fastVector.elementAt(n);
            if (d2 != null) {
                d = Math.abs(d2);
                if (d3 - d4 > 0.0) {
                    double d5 = (d - d4) / (d3 - d4) * (double)n2;
                    fastVector.setElementAt(new Integer((int)d5), n);
                    continue;
                }
                fastVector.setElementAt(new Integer(1), n);
                continue;
            }
            fastVector.setElementAt(new Integer(1), n);
        }
    }

    public static Instances setUpVisualizableInstances(Instances instances) {
        Attribute attribute;
        FastVector fastVector = new FastVector();
        Attribute attribute2 = instances.attribute(instances.classIndex());
        if (attribute2.isNominal()) {
            FastVector fastVector2 = new FastVector();
            for (int i = 0; i < attribute2.numValues(); ++i) {
                fastVector2.addElement(attribute2.value(i));
            }
            attribute = new Attribute("predicted" + attribute2.name(), fastVector2);
        } else {
            attribute = new Attribute("predicted" + attribute2.name());
        }
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex()) {
                fastVector.addElement(attribute);
            }
            fastVector.addElement(instances.attribute(i).copy());
        }
        return new Instances(instances.relationName() + "_predicted", fastVector, instances.numInstances());
    }

    protected void printPredictionsHeader(StringBuffer stringBuffer, Instances instances, String string) {
        stringBuffer.append("=== Predictions on " + string + " ===\n\n");
        stringBuffer.append(" inst#,    actual, predicted, error");
        if (instances.classAttribute().isNominal()) {
            stringBuffer.append(", probability distribution");
        }
        if (this.m_OutputAdditionalAttributesRange != null) {
            stringBuffer.append(" (");
            boolean bl = true;
            for (int i = 0; i < instances.numAttributes() - 1; ++i) {
                if (!this.m_OutputAdditionalAttributesRange.isInRange(i)) continue;
                if (!bl) {
                    stringBuffer.append(",");
                } else {
                    bl = false;
                }
                stringBuffer.append(instances.attribute(i).name());
            }
            stringBuffer.append(")");
        }
        stringBuffer.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startClassifier() {
        if (this.m_RunThread == null) {
            ClassifierPanel classifierPanel = this;
            synchronized (classifierPanel) {
                this.m_StartBut.setEnabled(false);
                this.m_StopBut.setEnabled(true);
            }
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block127: {
                        Object object2222;
                        ClassifierPanel.this.m_Log.statusMessage("Setting up...");
                        CostMatrix costMatrix = null;
                        Instances instances = new Instances(ClassifierPanel.this.m_Instances);
                        ConverterUtils.DataSource dataSource = null;
                        Instances instances2 = null;
                        FastVector fastVector = new FastVector();
                        FastVector fastVector2 = new FastVector();
                        Instances instances3 = null;
                        long l = 0L;
                        long l2 = 0L;
                        try {
                            if (ClassifierPanel.this.m_TestLoader != null && ClassifierPanel.this.m_TestLoader.getStructure() != null) {
                                ClassifierPanel.this.m_TestLoader.reset();
                                dataSource = new ConverterUtils.DataSource(ClassifierPanel.this.m_TestLoader);
                                instances2 = dataSource.getStructure();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (ClassifierPanel.this.m_EvalWRTCostsBut.isSelected()) {
                            costMatrix = new CostMatrix((CostMatrix)ClassifierPanel.this.m_CostMatrixEditor.getValue());
                        }
                        boolean bl = ClassifierPanel.this.m_OutputModelBut.isSelected();
                        boolean bl2 = ClassifierPanel.this.m_OutputConfusionBut.isSelected();
                        boolean bl3 = ClassifierPanel.this.m_OutputPerClassBut.isSelected();
                        boolean bl4 = true;
                        boolean bl5 = ClassifierPanel.this.m_OutputEntropyBut.isSelected();
                        boolean bl6 = ClassifierPanel.this.m_StorePredictionsBut.isSelected();
                        boolean bl7 = ClassifierPanel.this.m_OutputPredictionsTextBut.isSelected();
                        if (ClassifierPanel.this.m_OutputAdditionalAttributesText.getText().equals("")) {
                            ClassifierPanel.this.m_OutputAdditionalAttributesRange = null;
                        } else {
                            ClassifierPanel.this.m_OutputAdditionalAttributesRange = new Range(ClassifierPanel.this.m_OutputAdditionalAttributesText.getText());
                            ClassifierPanel.this.m_OutputAdditionalAttributesRange.setUpper(instances.numAttributes() - 1);
                        }
                        String string = null;
                        int n = 0;
                        int n2 = 10;
                        double d = 66.0;
                        int n3 = ClassifierPanel.this.m_ClassCombo.getSelectedIndex();
                        Classifier classifier = (Classifier)ClassifierPanel.this.m_ClassifierEditor.getValue();
                        Classifier classifier2 = null;
                        try {
                            classifier2 = Classifier.makeCopy(classifier);
                        }
                        catch (Exception exception) {
                            ClassifierPanel.this.m_Log.logMessage("Problem copying classifier: " + exception.getMessage());
                        }
                        Classifier classifier3 = null;
                        StringBuffer stringBuffer = new StringBuffer();
                        String string2 = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                        String string3 = classifier.getClass().getName();
                        string2 = string3.startsWith("weka.classifiers.") ? string2 + string3.substring("weka.classifiers.".length()) : string2 + string3;
                        String string4 = ClassifierPanel.this.m_ClassifierEditor.getValue().getClass().getName();
                        if (ClassifierPanel.this.m_ClassifierEditor.getValue() instanceof OptionHandler) {
                            string4 = string4 + " " + Utils.joinOptions(((OptionHandler)ClassifierPanel.this.m_ClassifierEditor.getValue()).getOptions());
                        }
                        Evaluation evaluation = null;
                        if (ClassifierPanel.this.m_CVBut.isSelected()) {
                            n = 1;
                            n2 = Integer.parseInt(ClassifierPanel.this.m_CVText.getText());
                            if (n2 <= 1) {
                                throw new Exception("Number of folds must be greater than 1");
                            }
                        } else if (ClassifierPanel.this.m_PercentBut.isSelected()) {
                            n = 2;
                            d = Double.parseDouble(ClassifierPanel.this.m_PercentText.getText());
                            if (d <= 0.0 || d >= 100.0) {
                                throw new Exception("Percentage must be between 0 and 100");
                            }
                        } else if (ClassifierPanel.this.m_TrainBut.isSelected()) {
                            n = 3;
                        } else if (ClassifierPanel.this.m_TestSplitBut.isSelected()) {
                            n = 4;
                            if (dataSource == null) {
                                throw new Exception("No user test set has been specified");
                            }
                            if (!instances.equalHeaders(instances2)) {
                                throw new Exception("Train and test set are not compatible");
                            }
                            instances2.setClassIndex(n3);
                        } else {
                            throw new Exception("Unknown test mode");
                        }
                        instances.setClassIndex(n3);
                        if (bl6) {
                            instances3 = ClassifierPanel.setUpVisualizableInstances(instances);
                            instances3.setClassIndex(instances.classIndex() + 1);
                        }
                        ClassifierPanel.this.m_Log.logMessage("Started " + string3);
                        ClassifierPanel.this.m_Log.logMessage("Command: " + string4);
                        if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskStarted();
                        }
                        stringBuffer.append("=== Run information ===\n\n");
                        stringBuffer.append("Scheme:       " + string3);
                        if (classifier instanceof OptionHandler) {
                            String[] stringArray = classifier.getOptions();
                            stringBuffer.append(" " + Utils.joinOptions(stringArray));
                        }
                        stringBuffer.append("\n");
                        stringBuffer.append("Relation:     " + instances.relationName() + '\n');
                        stringBuffer.append("Instances:    " + instances.numInstances() + '\n');
                        stringBuffer.append("Attributes:   " + instances.numAttributes() + '\n');
                        if (instances.numAttributes() < 100) {
                            for (int i = 0; i < instances.numAttributes(); ++i) {
                                stringBuffer.append("              " + instances.attribute(i).name() + '\n');
                            }
                        } else {
                            stringBuffer.append("              [list of attributes omitted]\n");
                        }
                        stringBuffer.append("Test mode:    ");
                        switch (n) {
                            case 3: {
                                stringBuffer.append("evaluate on training data\n");
                                break;
                            }
                            case 1: {
                                stringBuffer.append("" + n2 + "-fold cross-validation\n");
                                break;
                            }
                            case 2: {
                                stringBuffer.append("split " + d + "% train, remainder test\n");
                                break;
                            }
                            case 4: {
                                if (dataSource.isIncremental()) {
                                    stringBuffer.append("user supplied test set:  size unknown (reading incrementally)\n");
                                    break;
                                }
                                stringBuffer.append("user supplied test set: " + dataSource.getDataSet().numInstances() + " instances\n");
                            }
                        }
                        if (costMatrix != null) {
                            stringBuffer.append("Evaluation cost matrix:\n").append(costMatrix.toString()).append("\n");
                        }
                        stringBuffer.append("\n");
                        ClassifierPanel.this.m_History.addResult(string2, stringBuffer);
                        ClassifierPanel.this.m_History.setSingle(string2);
                        if (bl || n == 3 || n == 4) {
                            ClassifierPanel.this.m_Log.statusMessage("Building model on training data...");
                            l = System.currentTimeMillis();
                            classifier.buildClassifier(instances);
                            l2 = System.currentTimeMillis() - l;
                        }
                        if (bl) {
                            stringBuffer.append("=== Classifier model (full training set) ===\n\n");
                            stringBuffer.append(classifier.toString() + "\n");
                            stringBuffer.append("\nTime taken to build model: " + Utils.doubleToString((double)l2 / 1000.0, 2) + " seconds\n\n");
                            ClassifierPanel.this.m_History.updateResult(string2);
                            if (classifier instanceof Drawable) {
                                string = null;
                                try {
                                    string = ((Drawable)((Object)classifier)).graph();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            SerializedObject serializedObject = new SerializedObject(classifier);
                            classifier3 = (Classifier)serializedObject.getObject();
                        }
                        switch (n) {
                            case 3: {
                                ClassifierPanel.this.m_Log.statusMessage("Evaluating on training data...");
                                evaluation = new Evaluation(instances, costMatrix);
                                if (bl7) {
                                    ClassifierPanel.this.printPredictionsHeader(stringBuffer, instances, "training set");
                                }
                                for (int i = 0; i < instances.numInstances(); ++i) {
                                    ClassifierPanel.processClassifierPrediction(instances.instance(i), classifier, evaluation, instances3, fastVector, fastVector2);
                                    if (bl7) {
                                        stringBuffer.append(ClassifierPanel.this.predictionText(classifier, instances.instance(i), i + 1));
                                    }
                                    if (i % 100 != 0) continue;
                                    ClassifierPanel.this.m_Log.statusMessage("Evaluating on training data. Processed " + i + " instances...");
                                }
                                if (bl7) {
                                    stringBuffer.append("\n");
                                }
                                stringBuffer.append("=== Evaluation on training set ===\n");
                                break;
                            }
                            case 1: {
                                ClassifierPanel.this.m_Log.statusMessage("Randomizing instances...");
                                int n4 = 1;
                                try {
                                    n4 = Integer.parseInt(ClassifierPanel.this.m_RandomSeedText.getText().trim());
                                }
                                catch (Exception exception) {
                                    ClassifierPanel.this.m_Log.logMessage("Trouble parsing random seed value");
                                    n4 = 1;
                                }
                                Random random = new Random(n4);
                                instances.randomize(random);
                                if (instances.attribute(n3).isNominal()) {
                                    ClassifierPanel.this.m_Log.statusMessage("Stratifying instances...");
                                    instances.stratify(n2);
                                }
                                evaluation = new Evaluation(instances, costMatrix);
                                if (bl7) {
                                    ClassifierPanel.this.printPredictionsHeader(stringBuffer, instances, "test data");
                                }
                                for (int i = 0; i < n2; ++i) {
                                    ClassifierPanel.this.m_Log.statusMessage("Creating splits for fold " + (i + 1) + "...");
                                    Instances instances4 = instances.trainCV(n2, i, random);
                                    evaluation.setPriors(instances4);
                                    ClassifierPanel.this.m_Log.statusMessage("Building model for fold " + (i + 1) + "...");
                                    Classifier classifier4 = null;
                                    try {
                                        classifier4 = Classifier.makeCopy(classifier2);
                                    }
                                    catch (Exception exception) {
                                        ClassifierPanel.this.m_Log.logMessage("Problem copying classifier: " + exception.getMessage());
                                    }
                                    classifier4.buildClassifier(instances4);
                                    Instances instances5 = instances.testCV(n2, i);
                                    ClassifierPanel.this.m_Log.statusMessage("Evaluating model for fold " + (i + 1) + "...");
                                    for (int j = 0; j < instances5.numInstances(); ++j) {
                                        ClassifierPanel.processClassifierPrediction(instances5.instance(j), classifier4, evaluation, instances3, fastVector, fastVector2);
                                        if (!bl7) continue;
                                        stringBuffer.append(ClassifierPanel.this.predictionText(classifier4, instances5.instance(j), j + 1));
                                    }
                                }
                                if (bl7) {
                                    stringBuffer.append("\n");
                                }
                                if (instances.attribute(n3).isNominal()) {
                                    stringBuffer.append("=== Stratified cross-validation ===\n");
                                    break;
                                }
                                stringBuffer.append("=== Cross-validation ===\n");
                                break;
                            }
                            case 2: {
                                if (!ClassifierPanel.this.m_PreserveOrderBut.isSelected()) {
                                    int n5;
                                    ClassifierPanel.this.m_Log.statusMessage("Randomizing instances...");
                                    try {
                                        n5 = Integer.parseInt(ClassifierPanel.this.m_RandomSeedText.getText().trim());
                                    }
                                    catch (Exception exception) {
                                        ClassifierPanel.this.m_Log.logMessage("Trouble parsing random seed value");
                                        n5 = 1;
                                    }
                                    instances.randomize(new Random(n5));
                                }
                                int n6 = (int)Math.round((double)instances.numInstances() * d / 100.0);
                                int n7 = instances.numInstances() - n6;
                                Instances instances6 = new Instances(instances, 0, n6);
                                Instances instances7 = new Instances(instances, n6, n7);
                                ClassifierPanel.this.m_Log.statusMessage("Building model on training split (" + n6 + " instances)...");
                                Classifier classifier5 = null;
                                try {
                                    classifier5 = Classifier.makeCopy(classifier2);
                                }
                                catch (Exception exception) {
                                    ClassifierPanel.this.m_Log.logMessage("Problem copying classifier: " + exception.getMessage());
                                }
                                classifier5.buildClassifier(instances6);
                                evaluation = new Evaluation(instances6, costMatrix);
                                ClassifierPanel.this.m_Log.statusMessage("Evaluating on test split...");
                                if (bl7) {
                                    ClassifierPanel.this.printPredictionsHeader(stringBuffer, instances, "test split");
                                }
                                for (int i = 0; i < instances7.numInstances(); ++i) {
                                    ClassifierPanel.processClassifierPrediction(instances7.instance(i), classifier5, evaluation, instances3, fastVector, fastVector2);
                                    if (bl7) {
                                        stringBuffer.append(ClassifierPanel.this.predictionText(classifier5, instances7.instance(i), i + 1));
                                    }
                                    if (i % 100 != 0) continue;
                                    ClassifierPanel.this.m_Log.statusMessage("Evaluating on test split. Processed " + i + " instances...");
                                }
                                if (bl7) {
                                    stringBuffer.append("\n");
                                }
                                stringBuffer.append("=== Evaluation on test split ===\n");
                                break;
                            }
                            case 4: {
                                ClassifierPanel.this.m_Log.statusMessage("Evaluating on test data...");
                                evaluation = new Evaluation(instances, costMatrix);
                                if (bl7) {
                                    ClassifierPanel.this.printPredictionsHeader(stringBuffer, instances, "test set");
                                }
                                int n8 = 0;
                                while (dataSource.hasMoreElements(instances2)) {
                                    Instance instance = dataSource.nextElement(instances2);
                                    ClassifierPanel.processClassifierPrediction(instance, classifier, evaluation, instances3, fastVector, fastVector2);
                                    if (bl7) {
                                        stringBuffer.append(ClassifierPanel.this.predictionText(classifier, instance, n8 + 1));
                                    }
                                    if (++n8 % 100 != 0) continue;
                                    ClassifierPanel.this.m_Log.statusMessage("Evaluating on test data. Processed " + n8 + " instances...");
                                }
                                if (bl7) {
                                    stringBuffer.append("\n");
                                }
                                stringBuffer.append("=== Evaluation on test set ===\n");
                                break;
                            }
                            default: {
                                throw new Exception("Test mode not implemented");
                            }
                        }
                        if (bl4) {
                            stringBuffer.append(evaluation.toSummaryString(bl5) + "\n");
                        }
                        if (instances.attribute(n3).isNominal()) {
                            if (bl3) {
                                stringBuffer.append(evaluation.toClassDetailsString() + "\n");
                            }
                            if (bl2) {
                                stringBuffer.append(evaluation.toMatrixString() + "\n");
                            }
                        }
                        if (classifier3 instanceof Sourcable && ClassifierPanel.this.m_OutputSourceCode.isSelected()) {
                            stringBuffer.append("=== Source code ===\n\n");
                            stringBuffer.append(Evaluation.wekaStaticWrapper((Sourcable)((Object)classifier3), ClassifierPanel.this.m_SourceCodeClass.getText()));
                        }
                        ClassifierPanel.this.m_History.updateResult(string2);
                        ClassifierPanel.this.m_Log.logMessage("Finished " + string3);
                        ClassifierPanel.this.m_Log.statusMessage("OK");
                        Object var43_58 = null;
                        try {
                            if (!bl6 && bl) {
                                object2222 = new FastVector();
                                ((FastVector)object2222).addElement(classifier3);
                                Instances instances8 = new Instances(ClassifierPanel.this.m_Instances, 0);
                                instances8.setClassIndex(n3);
                                ((FastVector)object2222).addElement(instances8);
                                if (string != null) {
                                    ((FastVector)object2222).addElement(string);
                                }
                                ClassifierPanel.this.m_History.addObject(string2, object2222);
                            } else if (bl6 && instances3 != null && instances3.numInstances() > 0) {
                                if (instances3.attribute(instances3.classIndex()).isNumeric()) {
                                    ClassifierPanel.this.postProcessPlotInfo(fastVector2);
                                }
                                ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                ClassifierPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                                ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                object2222 = new PlotData2D(instances3);
                                ((PlotData2D)object2222).setShapeSize(fastVector2);
                                ((PlotData2D)object2222).setShapeType(fastVector);
                                ((PlotData2D)object2222).setPlotName(string2 + " (" + instances.relationName() + ")");
                                ((PlotData2D)object2222).addInstanceNumberAttribute();
                                ClassifierPanel.this.m_CurrentVis.addPlot((PlotData2D)object2222);
                                ClassifierPanel.this.m_CurrentVis.setColourIndex(instances3.classIndex() + 1);
                                FastVector fastVector3 = new FastVector();
                                if (bl) {
                                    fastVector3.addElement(classifier3);
                                    Instances instances9 = new Instances(ClassifierPanel.this.m_Instances, 0);
                                    instances9.setClassIndex(n3);
                                    fastVector3.addElement(instances9);
                                    if (string != null) {
                                        fastVector3.addElement(string);
                                    }
                                }
                                fastVector3.addElement(ClassifierPanel.this.m_CurrentVis);
                                if (evaluation != null && evaluation.predictions() != null) {
                                    fastVector3.addElement(evaluation.predictions());
                                    fastVector3.addElement(instances.classAttribute());
                                }
                                ClassifierPanel.this.m_History.addObject(string2, fastVector3);
                            }
                        }
                        catch (Exception object2222) {
                            ((Throwable)object2222).printStackTrace();
                        }
                        if (this.isInterrupted()) {
                            ClassifierPanel.this.m_Log.logMessage("Interrupted " + string3);
                            ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                        }
                        object2222 = this;
                        synchronized (object2222) {
                            ClassifierPanel.this.m_StartBut.setEnabled(true);
                            ClassifierPanel.this.m_StopBut.setEnabled(false);
                            ClassifierPanel.this.m_RunThread = null;
                        }
                        if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                        }
                        break block127;
                        {
                            catch (Exception exception) {
                                Object object32222;
                                exception.printStackTrace();
                                ClassifierPanel.this.m_Log.logMessage(exception.getMessage());
                                JOptionPane.showMessageDialog(ClassifierPanel.this, "Problem evaluating classifier:\n" + exception.getMessage(), "Evaluate classifier", 0);
                                ClassifierPanel.this.m_Log.statusMessage("Problem evaluating classifier");
                                Object var43_59 = null;
                                try {
                                    if (!bl6 && bl) {
                                        object32222 = new FastVector();
                                        ((FastVector)object32222).addElement(classifier3);
                                        Instances instances10 = new Instances(ClassifierPanel.this.m_Instances, 0);
                                        instances10.setClassIndex(n3);
                                        ((FastVector)object32222).addElement(instances10);
                                        if (string != null) {
                                            ((FastVector)object32222).addElement(string);
                                        }
                                        ClassifierPanel.this.m_History.addObject(string2, object32222);
                                    } else if (bl6 && instances3 != null && instances3.numInstances() > 0) {
                                        if (instances3.attribute(instances3.classIndex()).isNumeric()) {
                                            ClassifierPanel.this.postProcessPlotInfo(fastVector2);
                                        }
                                        ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                        ClassifierPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                                        ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                        object32222 = new PlotData2D(instances3);
                                        ((PlotData2D)object32222).setShapeSize(fastVector2);
                                        ((PlotData2D)object32222).setShapeType(fastVector);
                                        ((PlotData2D)object32222).setPlotName(string2 + " (" + instances.relationName() + ")");
                                        ((PlotData2D)object32222).addInstanceNumberAttribute();
                                        ClassifierPanel.this.m_CurrentVis.addPlot((PlotData2D)object32222);
                                        ClassifierPanel.this.m_CurrentVis.setColourIndex(instances3.classIndex() + 1);
                                        FastVector fastVector4 = new FastVector();
                                        if (bl) {
                                            fastVector4.addElement(classifier3);
                                            Instances instances11 = new Instances(ClassifierPanel.this.m_Instances, 0);
                                            instances11.setClassIndex(n3);
                                            fastVector4.addElement(instances11);
                                            if (string != null) {
                                                fastVector4.addElement(string);
                                            }
                                        }
                                        fastVector4.addElement(ClassifierPanel.this.m_CurrentVis);
                                        if (evaluation != null && evaluation.predictions() != null) {
                                            fastVector4.addElement(evaluation.predictions());
                                            fastVector4.addElement(instances.classAttribute());
                                        }
                                        ClassifierPanel.this.m_History.addObject(string2, fastVector4);
                                    }
                                }
                                catch (Exception object32222) {
                                    ((Throwable)object32222).printStackTrace();
                                }
                                if (this.isInterrupted()) {
                                    ClassifierPanel.this.m_Log.logMessage("Interrupted " + string3);
                                    ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                                }
                                object32222 = this;
                                synchronized (object32222) {
                                    ClassifierPanel.this.m_StartBut.setEnabled(true);
                                    ClassifierPanel.this.m_StopBut.setEnabled(false);
                                    ClassifierPanel.this.m_RunThread = null;
                                }
                                if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object object42222;
                            Object var43_60 = null;
                            try {
                                if (!bl6 && bl) {
                                    object42222 = new FastVector();
                                    ((FastVector)object42222).addElement(classifier3);
                                    Instances instances12 = new Instances(ClassifierPanel.this.m_Instances, 0);
                                    instances12.setClassIndex(n3);
                                    ((FastVector)object42222).addElement(instances12);
                                    if (string != null) {
                                        ((FastVector)object42222).addElement(string);
                                    }
                                    ClassifierPanel.this.m_History.addObject(string2, object42222);
                                } else if (bl6 && instances3 != null && instances3.numInstances() > 0) {
                                    if (instances3.attribute(instances3.classIndex()).isNumeric()) {
                                        ClassifierPanel.this.postProcessPlotInfo(fastVector2);
                                    }
                                    ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClassifierPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                                    ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                    object42222 = new PlotData2D(instances3);
                                    ((PlotData2D)object42222).setShapeSize(fastVector2);
                                    ((PlotData2D)object42222).setShapeType(fastVector);
                                    ((PlotData2D)object42222).setPlotName(string2 + " (" + instances.relationName() + ")");
                                    ((PlotData2D)object42222).addInstanceNumberAttribute();
                                    ClassifierPanel.this.m_CurrentVis.addPlot((PlotData2D)object42222);
                                    ClassifierPanel.this.m_CurrentVis.setColourIndex(instances3.classIndex() + 1);
                                    FastVector fastVector5 = new FastVector();
                                    if (bl) {
                                        fastVector5.addElement(classifier3);
                                        Instances instances13 = new Instances(ClassifierPanel.this.m_Instances, 0);
                                        instances13.setClassIndex(n3);
                                        fastVector5.addElement(instances13);
                                        if (string != null) {
                                            fastVector5.addElement(string);
                                        }
                                    }
                                    fastVector5.addElement(ClassifierPanel.this.m_CurrentVis);
                                    if (evaluation != null && evaluation.predictions() != null) {
                                        fastVector5.addElement(evaluation.predictions());
                                        fastVector5.addElement(instances.classAttribute());
                                    }
                                    ClassifierPanel.this.m_History.addObject(string2, fastVector5);
                                }
                            }
                            catch (Exception object42222) {
                                ((Throwable)object42222).printStackTrace();
                            }
                            if (this.isInterrupted()) {
                                ClassifierPanel.this.m_Log.logMessage("Interrupted " + string3);
                                ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                            }
                            object42222 = this;
                            synchronized (object42222) {
                                ClassifierPanel.this.m_StartBut.setEnabled(true);
                                ClassifierPanel.this.m_StopBut.setEnabled(false);
                                ClassifierPanel.this.m_RunThread = null;
                            }
                            if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected String predictionText(Classifier classifier, Instance instance, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Utils.padLeft("" + n, 6) + " ");
        if (instance.classAttribute().isNominal()) {
            double d;
            if (instance.classIsMissing()) {
                stringBuffer.append(Utils.padLeft("?", 10) + " ");
            } else {
                stringBuffer.append(Utils.padLeft("" + ((int)instance.classValue() + 1) + ":" + instance.stringValue(instance.classAttribute()), 10) + " ");
            }
            double[] dArray = null;
            if (instance.classAttribute().isNominal()) {
                dArray = classifier.distributionForInstance(instance);
                if (dArray[(int)(d = (double)Utils.maxIndex(dArray))] <= 0.0) {
                    d = Instance.missingValue();
                }
            } else {
                d = classifier.classifyInstance(instance);
            }
            stringBuffer.append(Utils.padLeft(Instance.isMissingValue(d) ? "?" : (int)d + 1 + ":" + instance.classAttribute().value((int)d), 10) + " ");
            if (d == instance.classValue()) {
                stringBuffer.append(Utils.padLeft(" ", 6) + " ");
            } else {
                stringBuffer.append(Utils.padLeft("+", 6) + " ");
            }
            if (instance.classAttribute().type() == 1) {
                for (int i = 0; i < dArray.length; ++i) {
                    if (i == (int)d) {
                        stringBuffer.append(" *");
                    } else {
                        stringBuffer.append("  ");
                    }
                    stringBuffer.append(Utils.doubleToString(dArray[i], 5, 3));
                }
            }
        } else {
            if (instance.classIsMissing()) {
                stringBuffer.append(Utils.padLeft("?", 10) + " ");
            } else {
                stringBuffer.append(Utils.doubleToString(instance.classValue(), 10, 3) + " ");
            }
            double d = classifier.classifyInstance(instance);
            if (Instance.isMissingValue(d)) {
                stringBuffer.append(Utils.padLeft("?", 10) + " ");
            } else {
                stringBuffer.append(Utils.doubleToString(d, 10, 3) + " ");
            }
            if (!instance.classIsMissing() && !Instance.isMissingValue(d)) {
                stringBuffer.append(Utils.doubleToString(d - instance.classValue(), 10, 3));
            }
        }
        if (this.m_OutputAdditionalAttributesRange != null) {
            stringBuffer.append(" (");
            boolean bl = true;
            for (int i = 0; i < instance.numAttributes() - 1; ++i) {
                if (!this.m_OutputAdditionalAttributesRange.isInRange(i)) continue;
                if (!bl) {
                    stringBuffer.append(",");
                } else {
                    bl = false;
                }
                stringBuffer.append(instance.toString(i));
            }
            stringBuffer.append(")");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected void visualize(String string, int n, int n2) {
        int n3;
        Object object;
        final String string2 = string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("View in main window");
        if (string2 != null) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassifierPanel.this.m_History.setSingle(string2);
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("View in separate window");
        if (string2 != null) {
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassifierPanel.this.m_History.openFrame(string2);
                }
            });
        } else {
            jMenuItem2.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Save result buffer");
        if (string2 != null) {
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassifierPanel.this.saveBuffer(string2);
                }
            });
        } else {
            jMenuItem3.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Delete result buffer");
        if (string2 != null) {
            jMenuItem4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassifierPanel.this.m_History.removeResult(string2);
                }
            });
        } else {
            jMenuItem4.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem("Load model");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierPanel.this.loadClassifier();
            }
        });
        jPopupMenu.add(jMenuItem5);
        FastVector fastVector = null;
        if (string2 != null) {
            fastVector = (FastVector)this.m_History.getNamedObject(string2);
        }
        VisualizePanel visualizePanel = null;
        Object object2 = null;
        FastVector fastVector2 = null;
        Attribute attribute = null;
        Classifier classifier = null;
        Instances instances = null;
        if (fastVector != null) {
            for (int i = 0; i < fastVector.size(); ++i) {
                object = fastVector.elementAt(i);
                if (object instanceof Classifier) {
                    classifier = (Classifier)object;
                    continue;
                }
                if (object instanceof Instances) {
                    instances = (Instances)object;
                    continue;
                }
                if (object instanceof VisualizePanel) {
                    visualizePanel = (VisualizePanel)object;
                    continue;
                }
                if (object instanceof String) {
                    object2 = (String)object;
                    continue;
                }
                if (object instanceof FastVector) {
                    fastVector2 = (FastVector)object;
                    continue;
                }
                if (!(object instanceof Attribute)) continue;
                attribute = (Attribute)object;
            }
        }
        final VisualizePanel visualizePanel2 = visualizePanel;
        object = object2;
        final FastVector fastVector3 = fastVector2;
        final Attribute attribute2 = attribute;
        final Classifier classifier2 = classifier;
        final Instances instances2 = instances;
        JMenuItem jMenuItem6 = new JMenuItem("Save model");
        if (classifier2 != null) {
            jMenuItem6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassifierPanel.this.saveClassifier(string2, classifier2, instances2);
                }
            });
        } else {
            jMenuItem6.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Re-evaluate model on current test set");
        if (classifier2 != null && this.m_TestLoader != null) {
            jMenuItem7.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassifierPanel.this.reevaluateModel(string2, classifier2, instances2);
                }
            });
        } else {
            jMenuItem7.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem7);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem8 = new JMenuItem("Visualize classifier errors");
        if (visualizePanel2 != null) {
            if (visualizePanel2.getXIndex() == 0 && visualizePanel2.getYIndex() == 1) {
                try {
                    visualizePanel2.setXIndex(visualizePanel2.getInstances().classIndex());
                    visualizePanel2.setYIndex(visualizePanel2.getInstances().classIndex() - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            jMenuItem8.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassifierPanel.this.visualizeClassifierErrors(visualizePanel2);
                }
            });
        } else {
            jMenuItem8.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Visualize tree");
        if (object != null) {
            if (((Drawable)((Object)classifier)).graphType() == 1) {
                jMenuItem9.addActionListener(new ActionListener((String)object){
                    final /* synthetic */ String val$grph;
                    {
                        this.val$grph = string22;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = visualizePanel2 != null ? visualizePanel2.getName() : string2;
                        ClassifierPanel.this.visualizeTree(this.val$grph, string);
                    }
                });
            } else if (((Drawable)((Object)classifier)).graphType() == 2) {
                jMenuItem9.setText("Visualize graph");
                jMenuItem9.addActionListener(new ActionListener((String)object, string2){
                    final /* synthetic */ String val$grph;
                    final /* synthetic */ String val$selectedName;
                    {
                        this.val$grph = string;
                        this.val$selectedName = string2;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Thread thread = new Thread(){

                            public void run() {
                                ClassifierPanel.this.visualizeBayesNet(val$grph, val$selectedName);
                            }
                        };
                        thread.start();
                    }
                });
            } else {
                jMenuItem9.setEnabled(false);
            }
        } else {
            jMenuItem9.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem("Visualize margin curve");
        if (fastVector3 != null) {
            jMenuItem10.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MarginCurve marginCurve = new MarginCurve();
                        Instances instances = marginCurve.getCurve(fastVector3);
                        VisualizePanel visualizePanel = new VisualizePanel();
                        visualizePanel.setName(instances.relationName());
                        visualizePanel.setLog(ClassifierPanel.this.m_Log);
                        PlotData2D plotData2D = new PlotData2D(instances);
                        plotData2D.setPlotName(instances.relationName());
                        plotData2D.addInstanceNumberAttribute();
                        visualizePanel.addPlot(plotData2D);
                        ClassifierPanel.this.visualizeClassifierErrors(visualizePanel);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        } else {
            jMenuItem10.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem10);
        JMenu jMenu = new JMenu("Visualize threshold curve");
        if (fastVector3 != null && attribute2 != null) {
            int n4 = 0;
            while (n4 < attribute2.numValues()) {
                JMenuItem jMenuItem11 = new JMenuItem(attribute2.value(n4));
                final int n5 = n4++;
                jMenuItem11.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ThresholdCurve thresholdCurve = new ThresholdCurve();
                            Instances instances = thresholdCurve.getCurve(fastVector3, n5);
                            ThresholdVisualizePanel thresholdVisualizePanel = new ThresholdVisualizePanel();
                            thresholdVisualizePanel.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(instances), 4) + ")");
                            thresholdVisualizePanel.setLog(ClassifierPanel.this.m_Log);
                            thresholdVisualizePanel.setName(instances.relationName() + ". (Class value " + attribute2.value(n5) + ")");
                            PlotData2D plotData2D = new PlotData2D(instances);
                            plotData2D.setPlotName(instances.relationName());
                            plotData2D.addInstanceNumberAttribute();
                            thresholdVisualizePanel.addPlot(plotData2D);
                            ClassifierPanel.this.visualizeClassifierErrors(thresholdVisualizePanel);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu.add(jMenuItem11);
            }
        } else {
            jMenu.setEnabled(false);
        }
        jPopupMenu.add(jMenu);
        JMenu jMenu2 = new JMenu("Visualize cost curve");
        if (fastVector3 != null && attribute2 != null) {
            int n6 = 0;
            while (n6 < attribute2.numValues()) {
                JMenuItem jMenuItem12 = new JMenuItem(attribute2.value(n6));
                n3 = n6++;
                jMenuItem12.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            CostCurve costCurve = new CostCurve();
                            Instances instances = costCurve.getCurve(fastVector3, n3);
                            VisualizePanel visualizePanel = new VisualizePanel();
                            visualizePanel.setLog(ClassifierPanel.this.m_Log);
                            visualizePanel.setName(instances.relationName() + ". (Class value " + attribute2.value(n3) + ")");
                            PlotData2D plotData2D = new PlotData2D(instances);
                            plotData2D.m_displayAllPoints = true;
                            plotData2D.setPlotName(instances.relationName());
                            boolean[] blArray = new boolean[instances.numInstances()];
                            for (int i = 1; i < blArray.length; i += 2) {
                                blArray[i] = true;
                            }
                            plotData2D.setConnectPoints(blArray);
                            visualizePanel.addPlot(plotData2D);
                            ClassifierPanel.this.visualizeClassifierErrors(visualizePanel);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu2.add(jMenuItem12);
            }
        } else {
            jMenu2.setEnabled(false);
        }
        jPopupMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("Plugins");
        Vector<String> vector = GenericObjectEditor.getClassnames(VisualizePlugin.class.getName());
        n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = vector.elementAt(i);
            try {
                VisualizePlugin visualizePlugin = (VisualizePlugin)Class.forName(string3).newInstance();
                if (visualizePlugin == null) continue;
                n3 = 1;
                JMenuItem jMenuItem13 = visualizePlugin.getVisualizeMenuItem(fastVector3, attribute2);
                Version version = new Version();
                if (jMenuItem13 == null) continue;
                if (version.compareTo(visualizePlugin.getMinVersion()) < 0) {
                    jMenuItem13.setText(jMenuItem13.getText() + " (weka outdated)");
                }
                if (version.compareTo(visualizePlugin.getMaxVersion()) >= 0) {
                    jMenuItem13.setText(jMenuItem13.getText() + " (plugin outdated)");
                }
                jMenu3.add(jMenuItem13);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (n3 != 0) {
            jPopupMenu.add(jMenu3);
        }
        jPopupMenu.show(this.m_History.getList(), n, n2);
    }

    protected void visualizeTree(String string, String string2) {
        final JFrame jFrame = new JFrame("Weka Classifier Tree Visualizer: " + string2);
        jFrame.setSize(500, 400);
        jFrame.getContentPane().setLayout(new BorderLayout());
        TreeVisualizer treeVisualizer = new TreeVisualizer(null, string, (NodePlace)new PlaceNode2());
        jFrame.getContentPane().add((Component)treeVisualizer, "Center");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setVisible(true);
        treeVisualizer.fitToScreen();
    }

    protected void visualizeBayesNet(String string, String string2) {
        final JFrame jFrame = new JFrame("Weka Classifier Graph Visualizer: " + string2);
        jFrame.setSize(500, 400);
        jFrame.getContentPane().setLayout(new BorderLayout());
        GraphVisualizer graphVisualizer = new GraphVisualizer();
        try {
            graphVisualizer.readBIF(string);
        }
        catch (BIFFormatException bIFFormatException) {
            System.err.println("unable to visualize BayesNet");
            bIFFormatException.printStackTrace();
        }
        graphVisualizer.layoutGraph();
        jFrame.getContentPane().add((Component)graphVisualizer, "Center");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setVisible(true);
    }

    protected void visualizeClassifierErrors(VisualizePanel visualizePanel) {
        if (visualizePanel != null) {
            String string = visualizePanel.getName();
            final JFrame jFrame = new JFrame("Weka Classifier Visualize: " + string);
            jFrame.setSize(600, 400);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)visualizePanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.setVisible(true);
        }
    }

    protected void saveBuffer(String string) {
        StringBuffer stringBuffer = this.m_History.getNamedBuffer(string);
        if (stringBuffer != null && this.m_SaveOut.save(stringBuffer)) {
            this.m_Log.logMessage("Save successful.");
        }
    }

    protected void stopClassifier() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveClassifier(String string, Classifier classifier, Instances instances) {
        File file = null;
        boolean bl = true;
        int n = this.m_FileChooser.showSaveDialog(this);
        if (n == 0) {
            file = this.m_FileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(MODEL_FILE_EXTENSION)) {
                file = new File(file.getParent(), file.getName() + MODEL_FILE_EXTENSION);
            }
            this.m_Log.statusMessage("Saving model to file...");
            try {
                OutputStream outputStream = new FileOutputStream(file);
                if (file.getName().endsWith(".gz")) {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(classifier);
                if (instances != null) {
                    objectOutputStream.writeObject(instances);
                }
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception, "Save Failed", 0);
                bl = false;
            }
            if (bl) {
                this.m_Log.logMessage("Saved model (" + string + ") to file '" + file.getName() + "'");
            }
            this.m_Log.statusMessage("OK");
        }
    }

    protected void loadClassifier() {
        int n = this.m_FileChooser.showOpenDialog(this);
        if (n == 0) {
            Object object;
            Object object2;
            Instances instances;
            Classifier classifier;
            File file;
            block21: {
                file = this.m_FileChooser.getSelectedFile();
                classifier = null;
                instances = null;
                this.m_Log.statusMessage("Loading model from file...");
                try {
                    object2 = new FileInputStream(file);
                    if (file.getName().endsWith(PMML_FILE_EXTENSION)) {
                        object = PMMLFactory.getPMMLModel((InputStream)object2, this.m_Log);
                        if (object instanceof PMMLClassifier) {
                            classifier = (PMMLClassifier)object;
                            break block21;
                        }
                        throw new Exception("PMML model is not a classification/regression model!");
                    }
                    if (file.getName().endsWith(".gz")) {
                        object2 = new GZIPInputStream((InputStream)object2);
                    }
                    object = new ObjectInputStream((InputStream)object2);
                    classifier = (Classifier)((ObjectInputStream)object).readObject();
                    try {
                        instances = (Instances)((ObjectInputStream)object).readObject();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((ObjectInputStream)object).close();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception, "Load Failed", 0);
                }
            }
            this.m_Log.statusMessage("OK");
            if (classifier != null) {
                this.m_Log.logMessage("Loaded model from file '" + file.getName() + "'");
                object2 = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                object = classifier.getClass().getName();
                if (((String)object).startsWith("weka.classifiers.")) {
                    object = ((String)object).substring("weka.classifiers.".length());
                }
                object2 = (String)object2 + (String)object + " from file '" + file.getName() + "'";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("=== Model information ===\n\n");
                stringBuffer.append("Filename:     " + file.getName() + "\n");
                stringBuffer.append("Scheme:       " + classifier.getClass().getName());
                if (classifier instanceof OptionHandler) {
                    String[] stringArray = classifier.getOptions();
                    stringBuffer.append(" " + Utils.joinOptions(stringArray));
                }
                stringBuffer.append("\n");
                if (instances != null) {
                    stringBuffer.append("Relation:     " + instances.relationName() + '\n');
                    stringBuffer.append("Attributes:   " + instances.numAttributes() + '\n');
                    if (instances.numAttributes() < 100) {
                        for (int i = 0; i < instances.numAttributes(); ++i) {
                            stringBuffer.append("              " + instances.attribute(i).name() + '\n');
                        }
                    } else {
                        stringBuffer.append("              [list of attributes omitted]\n");
                    }
                } else {
                    stringBuffer.append("\nTraining data unknown\n");
                }
                stringBuffer.append("\n=== Classifier model ===\n\n");
                stringBuffer.append(classifier.toString() + "\n");
                this.m_History.addResult((String)object2, stringBuffer);
                this.m_History.setSingle((String)object2);
                FastVector fastVector = new FastVector();
                fastVector.addElement(classifier);
                if (instances != null) {
                    fastVector.addElement(instances);
                }
                String string = null;
                if (classifier instanceof Drawable) {
                    try {
                        string = ((Drawable)((Object)classifier)).graph();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string != null) {
                    fastVector.addElement(string);
                }
                this.m_History.addObject((String)object2, fastVector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reevaluateModel(final String string, final Classifier classifier, final Instances instances) {
        if (this.m_RunThread == null) {
            ClassifierPanel classifierPanel = this;
            synchronized (classifierPanel) {
                this.m_StartBut.setEnabled(false);
                this.m_StopBut.setEnabled(true);
            }
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block83: {
                        Object object2222;
                        Evaluation evaluation;
                        String string3;
                        boolean bl;
                        Instances instances3;
                        FastVector fastVector;
                        FastVector fastVector2;
                        Instances instances2;
                        block76: {
                            RevisionHandler revisionHandler;
                            ClassifierPanel.this.m_Log.statusMessage("Setting up...");
                            StringBuffer stringBuffer = ClassifierPanel.this.m_History.getNamedBuffer(string);
                            ConverterUtils.DataSource dataSource = null;
                            instances2 = null;
                            fastVector2 = new FastVector();
                            fastVector = new FastVector();
                            instances3 = null;
                            CostMatrix costMatrix = null;
                            if (ClassifierPanel.this.m_EvalWRTCostsBut.isSelected()) {
                                costMatrix = new CostMatrix((CostMatrix)ClassifierPanel.this.m_CostMatrixEditor.getValue());
                            }
                            boolean bl2 = ClassifierPanel.this.m_OutputConfusionBut.isSelected();
                            boolean bl3 = ClassifierPanel.this.m_OutputPerClassBut.isSelected();
                            boolean bl4 = true;
                            boolean bl5 = ClassifierPanel.this.m_OutputEntropyBut.isSelected();
                            bl = ClassifierPanel.this.m_StorePredictionsBut.isSelected();
                            boolean bl6 = ClassifierPanel.this.m_OutputPredictionsTextBut.isSelected();
                            string3 = null;
                            evaluation = null;
                            boolean bl7 = ClassifierPanel.this.m_TestLoader instanceof IncrementalConverter;
                            if (ClassifierPanel.this.m_TestLoader != null && ClassifierPanel.this.m_TestLoader.getStructure() != null) {
                                ClassifierPanel.this.m_TestLoader.reset();
                                dataSource = new ConverterUtils.DataSource(ClassifierPanel.this.m_TestLoader);
                                instances2 = dataSource.getStructure();
                            }
                            if (dataSource == null) {
                                throw new Exception("No user test set has been specified");
                            }
                            if (instances != null) {
                                if (instances.classIndex() > instances2.numAttributes() - 1) {
                                    throw new Exception("Train and test set are not compatible");
                                }
                                instances2.setClassIndex(instances.classIndex());
                                if (!instances.equalHeaders(instances2)) {
                                    throw new Exception("Train and test set are not compatible");
                                }
                            } else if (classifier instanceof PMMLClassifier) {
                                revisionHandler = ((PMMLClassifier)classifier).getMiningSchema().getMiningSchemaAsInstances();
                                String string2 = revisionHandler.classAttribute().name();
                                Attribute attribute = instances2.attribute(string2);
                                if (attribute == null) {
                                    throw new Exception("Can't find a match for the PMML target field " + string2 + " in the " + "test instances!");
                                }
                                instances2.setClass(attribute);
                            } else {
                                instances2.setClassIndex(instances2.numAttributes() - 1);
                            }
                            if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskStarted();
                            }
                            ClassifierPanel.this.m_Log.statusMessage("Evaluating on test data...");
                            ClassifierPanel.this.m_Log.logMessage("Re-evaluating classifier (" + string + ") on test set");
                            evaluation = new Evaluation(instances2, costMatrix);
                            evaluation.useNoPriors();
                            if (bl) {
                                instances3 = ClassifierPanel.setUpVisualizableInstances(instances2);
                                instances3.setClassIndex(instances2.classIndex() + 1);
                            }
                            stringBuffer.append("\n=== Re-evaluation on test set ===\n\n");
                            stringBuffer.append("User supplied test set\n");
                            stringBuffer.append("Relation:     " + instances2.relationName() + '\n');
                            if (bl7) {
                                stringBuffer.append("Instances:     unknown (yet). Reading incrementally\n");
                            } else {
                                stringBuffer.append("Instances:    " + dataSource.getDataSet().numInstances() + "\n");
                            }
                            stringBuffer.append("Attributes:   " + instances2.numAttributes() + "\n\n");
                            if (instances == null) {
                                stringBuffer.append("NOTE - if test set is not compatible then results are unpredictable\n\n");
                            }
                            if (bl6) {
                                stringBuffer.append("=== Predictions on test set ===\n\n");
                                stringBuffer.append(" inst#,    actual, predicted, error");
                                if (instances2.classAttribute().isNominal()) {
                                    stringBuffer.append(", probability distribution");
                                }
                                stringBuffer.append("\n");
                            }
                            int n = 0;
                            while (dataSource.hasMoreElements(instances2)) {
                                revisionHandler = dataSource.nextElement(instances2);
                                ClassifierPanel.processClassifierPrediction((Instance)revisionHandler, classifier, evaluation, instances3, fastVector2, fastVector);
                                if (bl6) {
                                    stringBuffer.append(ClassifierPanel.this.predictionText(classifier, (Instance)revisionHandler, n + 1));
                                }
                                if (++n % 100 != 0) continue;
                                ClassifierPanel.this.m_Log.statusMessage("Evaluating on test data. Processed " + n + " instances...");
                            }
                            if (bl6) {
                                stringBuffer.append("\n");
                            }
                            if (bl4) {
                                stringBuffer.append(evaluation.toSummaryString(bl5) + "\n");
                            }
                            if (instances2.classAttribute().isNominal()) {
                                if (bl3) {
                                    stringBuffer.append(evaluation.toClassDetailsString() + "\n");
                                }
                                if (bl2) {
                                    stringBuffer.append(evaluation.toMatrixString() + "\n");
                                }
                            }
                            ClassifierPanel.this.m_History.updateResult(string);
                            ClassifierPanel.this.m_Log.logMessage("Finished re-evaluation");
                            ClassifierPanel.this.m_Log.statusMessage("OK");
                            Object var21_22 = null;
                            try {
                                Serializable serializable2222;
                                if (classifier instanceof PMMLClassifier) {
                                    ((PMMLClassifier)classifier).done();
                                }
                                if (instances3 == null || instances3.numInstances() <= 0) break block76;
                                if (instances3.attribute(instances3.classIndex()).isNumeric()) {
                                    ClassifierPanel.this.postProcessPlotInfo(fastVector);
                                }
                                ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                ClassifierPanel.this.m_CurrentVis.setName(string + " (" + instances2.relationName() + ")");
                                ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                object2222 = new PlotData2D(instances3);
                                ((PlotData2D)object2222).setShapeSize(fastVector);
                                ((PlotData2D)object2222).setShapeType(fastVector2);
                                ((PlotData2D)object2222).setPlotName(string + " (" + instances2.relationName() + ")");
                                ((PlotData2D)object2222).addInstanceNumberAttribute();
                                ClassifierPanel.this.m_CurrentVis.addPlot((PlotData2D)object2222);
                                ClassifierPanel.this.m_CurrentVis.setColourIndex(instances3.classIndex() + 1);
                                if (classifier instanceof Drawable) {
                                    try {
                                        string3 = ((Drawable)((Object)classifier)).graph();
                                    }
                                    catch (Exception serializable2222) {
                                        // empty catch block
                                    }
                                }
                                if (bl) {
                                    serializable2222 = new FastVector();
                                    ((FastVector)serializable2222).addElement(classifier);
                                    if (instances != null) {
                                        ((FastVector)serializable2222).addElement(instances);
                                    }
                                    ((FastVector)serializable2222).addElement(ClassifierPanel.this.m_CurrentVis);
                                    if (string3 != null) {
                                        ((FastVector)serializable2222).addElement(string3);
                                    }
                                    if (evaluation != null && evaluation.predictions() != null) {
                                        ((FastVector)serializable2222).addElement(evaluation.predictions());
                                        ((FastVector)serializable2222).addElement(instances2.classAttribute());
                                    }
                                    ClassifierPanel.this.m_History.addObject(string, serializable2222);
                                } else {
                                    serializable2222 = new FastVector();
                                    ((FastVector)serializable2222).addElement(classifier);
                                    if (instances != null) {
                                        ((FastVector)serializable2222).addElement(instances);
                                    }
                                    ClassifierPanel.this.m_History.addObject(string, serializable2222);
                                }
                            }
                            catch (Exception object2222) {
                                ((Throwable)object2222).printStackTrace();
                            }
                        }
                        if (this.isInterrupted()) {
                            ClassifierPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                            ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                        }
                        object2222 = this;
                        synchronized (object2222) {
                            ClassifierPanel.this.m_StartBut.setEnabled(true);
                            ClassifierPanel.this.m_StopBut.setEnabled(false);
                            ClassifierPanel.this.m_RunThread = null;
                        }
                        if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                        }
                        break block83;
                        {
                            catch (Exception exception) {
                                Object object32222;
                                block79: {
                                    exception.printStackTrace();
                                    ClassifierPanel.this.m_Log.logMessage(exception.getMessage());
                                    ClassifierPanel.this.m_Log.statusMessage("See error log");
                                    exception.printStackTrace();
                                    ClassifierPanel.this.m_Log.logMessage(exception.getMessage());
                                    JOptionPane.showMessageDialog(ClassifierPanel.this, "Problem evaluationg classifier:\n" + exception.getMessage(), "Evaluate classifier", 0);
                                    ClassifierPanel.this.m_Log.statusMessage("Problem evaluating classifier");
                                    Object var21_23 = null;
                                    try {
                                        Serializable serializable3222;
                                        if (classifier instanceof PMMLClassifier) {
                                            ((PMMLClassifier)classifier).done();
                                        }
                                        if (instances3 == null || instances3.numInstances() <= 0) break block79;
                                        if (instances3.attribute(instances3.classIndex()).isNumeric()) {
                                            ClassifierPanel.this.postProcessPlotInfo(fastVector);
                                        }
                                        ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                        ClassifierPanel.this.m_CurrentVis.setName(string + " (" + instances2.relationName() + ")");
                                        ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                        object32222 = new PlotData2D(instances3);
                                        ((PlotData2D)object32222).setShapeSize(fastVector);
                                        ((PlotData2D)object32222).setShapeType(fastVector2);
                                        ((PlotData2D)object32222).setPlotName(string + " (" + instances2.relationName() + ")");
                                        ((PlotData2D)object32222).addInstanceNumberAttribute();
                                        ClassifierPanel.this.m_CurrentVis.addPlot((PlotData2D)object32222);
                                        ClassifierPanel.this.m_CurrentVis.setColourIndex(instances3.classIndex() + 1);
                                        if (classifier instanceof Drawable) {
                                            try {
                                                string3 = ((Drawable)((Object)classifier)).graph();
                                            }
                                            catch (Exception serializable3222) {
                                                // empty catch block
                                            }
                                        }
                                        if (bl) {
                                            serializable3222 = new FastVector();
                                            ((FastVector)serializable3222).addElement(classifier);
                                            if (instances != null) {
                                                ((FastVector)serializable3222).addElement(instances);
                                            }
                                            ((FastVector)serializable3222).addElement(ClassifierPanel.this.m_CurrentVis);
                                            if (string3 != null) {
                                                ((FastVector)serializable3222).addElement(string3);
                                            }
                                            if (evaluation != null && evaluation.predictions() != null) {
                                                ((FastVector)serializable3222).addElement(evaluation.predictions());
                                                ((FastVector)serializable3222).addElement(instances2.classAttribute());
                                            }
                                            ClassifierPanel.this.m_History.addObject(string, serializable3222);
                                        } else {
                                            serializable3222 = new FastVector();
                                            ((FastVector)serializable3222).addElement(classifier);
                                            if (instances != null) {
                                                ((FastVector)serializable3222).addElement(instances);
                                            }
                                            ClassifierPanel.this.m_History.addObject(string, serializable3222);
                                        }
                                    }
                                    catch (Exception object32222) {
                                        ((Throwable)object32222).printStackTrace();
                                    }
                                }
                                if (this.isInterrupted()) {
                                    ClassifierPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                                    ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                                }
                                object32222 = this;
                                synchronized (object32222) {
                                    ClassifierPanel.this.m_StartBut.setEnabled(true);
                                    ClassifierPanel.this.m_StopBut.setEnabled(false);
                                    ClassifierPanel.this.m_RunThread = null;
                                }
                                if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object object42222;
                            block82: {
                                Object var21_24 = null;
                                try {
                                    Serializable serializable4222;
                                    if (classifier instanceof PMMLClassifier) {
                                        ((PMMLClassifier)classifier).done();
                                    }
                                    if (instances3 == null || instances3.numInstances() <= 0) break block82;
                                    if (instances3.attribute(instances3.classIndex()).isNumeric()) {
                                        ClassifierPanel.this.postProcessPlotInfo(fastVector);
                                    }
                                    ClassifierPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClassifierPanel.this.m_CurrentVis.setName(string + " (" + instances2.relationName() + ")");
                                    ClassifierPanel.this.m_CurrentVis.setLog(ClassifierPanel.this.m_Log);
                                    object42222 = new PlotData2D(instances3);
                                    ((PlotData2D)object42222).setShapeSize(fastVector);
                                    ((PlotData2D)object42222).setShapeType(fastVector2);
                                    ((PlotData2D)object42222).setPlotName(string + " (" + instances2.relationName() + ")");
                                    ((PlotData2D)object42222).addInstanceNumberAttribute();
                                    ClassifierPanel.this.m_CurrentVis.addPlot((PlotData2D)object42222);
                                    ClassifierPanel.this.m_CurrentVis.setColourIndex(instances3.classIndex() + 1);
                                    if (classifier instanceof Drawable) {
                                        try {
                                            string3 = ((Drawable)((Object)classifier)).graph();
                                        }
                                        catch (Exception serializable4222) {
                                            // empty catch block
                                        }
                                    }
                                    if (bl) {
                                        serializable4222 = new FastVector();
                                        ((FastVector)serializable4222).addElement(classifier);
                                        if (instances != null) {
                                            ((FastVector)serializable4222).addElement(instances);
                                        }
                                        ((FastVector)serializable4222).addElement(ClassifierPanel.this.m_CurrentVis);
                                        if (string3 != null) {
                                            ((FastVector)serializable4222).addElement(string3);
                                        }
                                        if (evaluation != null && evaluation.predictions() != null) {
                                            ((FastVector)serializable4222).addElement(evaluation.predictions());
                                            ((FastVector)serializable4222).addElement(instances2.classAttribute());
                                        }
                                        ClassifierPanel.this.m_History.addObject(string, serializable4222);
                                    } else {
                                        serializable4222 = new FastVector();
                                        ((FastVector)serializable4222).addElement(classifier);
                                        if (instances != null) {
                                            ((FastVector)serializable4222).addElement(instances);
                                        }
                                        ClassifierPanel.this.m_History.addObject(string, serializable4222);
                                    }
                                }
                                catch (Exception object42222) {
                                    ((Throwable)object42222).printStackTrace();
                                }
                            }
                            if (this.isInterrupted()) {
                                ClassifierPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                                ClassifierPanel.this.m_Log.statusMessage("Interrupted");
                            }
                            object42222 = this;
                            synchronized (object42222) {
                                ClassifierPanel.this.m_StartBut.setEnabled(true);
                                ClassifierPanel.this.m_StopBut.setEnabled(false);
                                ClassifierPanel.this.m_RunThread = null;
                            }
                            if (ClassifierPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClassifierPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void updateCapabilitiesFilter(Capabilities capabilities) {
        Capabilities capabilities2;
        if (capabilities == null) {
            this.m_ClassifierEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances instances = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        instances.setClassIndex(this.m_ClassCombo.getSelectedIndex());
        try {
            capabilities2 = Capabilities.forInstances(instances);
        }
        catch (Exception exception) {
            capabilities2 = new Capabilities(null);
        }
        this.m_ClassifierEditor.setCapabilitiesFilter(capabilities2);
        this.m_StartBut.setEnabled(true);
        Capabilities capabilities3 = this.m_ClassifierEditor.getCapabilitiesFilter();
        Classifier classifier = (Classifier)this.m_ClassifierEditor.getValue();
        Capabilities capabilities4 = null;
        if (classifier != null && capabilities3 != null && classifier instanceof CapabilitiesHandler && !(capabilities4 = classifier.getCapabilities()).supportsMaybe(capabilities3) && !capabilities4.supports(capabilities3)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent capabilitiesFilterChangeEvent) {
        if (capabilitiesFilterChangeEvent.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)capabilitiesFilterChangeEvent.getFilter().clone());
        }
    }

    public void setExplorer(Explorer explorer) {
        this.m_Explorer = explorer;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "Classify";
    }

    public String getTabTitleToolTip() {
        return "Classify instances";
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Weka Explorer: Classifier");
            jFrame.getContentPane().setLayout(new BorderLayout());
            ClassifierPanel classifierPanel = new ClassifierPanel();
            jFrame.getContentPane().add((Component)classifierPanel, "Center");
            LogPanel logPanel = new LogPanel();
            classifierPanel.setLog(logPanel);
            jFrame.getContentPane().add((Component)logPanel, "South");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            if (stringArray.length == 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                classifierPanel.setInstances(instances);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

