/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ft;

import java.util.Vector;
import weka.classifiers.functions.SimpleLinearRegression;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.BinC45Split;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.Stats;
import weka.classifiers.trees.lmt.LogisticBase;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;

public abstract class FTtree
extends LogisticBase {
    static final long serialVersionUID = 1862737145870398755L;
    protected double m_totalInstanceWeight;
    protected int m_id;
    protected int m_leafModelNum;
    protected int m_minNumInstances;
    protected ModelSelection m_modelSelection;
    protected NominalToBinary m_nominalToBinary;
    protected SimpleLinearRegression[][] m_higherRegressions;
    protected int m_numHigherRegressions = 0;
    protected int m_numInstances;
    protected ClassifierSplitModel m_localModel;
    protected ClassifierSplitModel m_auxLocalModel;
    protected FTtree[] m_sons;
    protected int m_leafclass;
    protected boolean m_isLeaf;
    protected boolean m_hasConstr = true;
    protected double m_constError = 0.0;
    protected float m_CF = 0.1f;

    public abstract void buildClassifier(Instances var1) throws Exception;

    public abstract void buildTree(Instances var1, SimpleLinearRegression[][] var2, double var3, double var5) throws Exception;

    public abstract double prune() throws Exception;

    protected Instances insertNewAttr(Instances instances) throws Exception {
        for (int i = 0; i < instances.classAttribute().numValues(); ++i) {
            instances.insertAttributeAt(new Attribute("N" + i), i);
        }
        return instances;
    }

    protected Instances removeExtAttributes(Instances instances) throws Exception {
        for (int i = 0; i < instances.classAttribute().numValues(); ++i) {
            instances.deleteAttributeAt(0);
        }
        return instances;
    }

    protected double getEstimatedErrors() {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(this.m_localModel.distribution());
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            d += this.m_sons[i].getEstimatedErrors();
        }
        return d;
    }

    protected double getEstimatedErrorsForBranch(Instances instances) throws Exception {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(new Distribution(instances));
        }
        Distribution distribution = this.m_localModel.distribution();
        this.m_localModel.resetDistribution(instances);
        Instances[] instancesArray = this.m_localModel.split(instances);
        for (int i = 0; i < this.m_sons.length; ++i) {
            d += this.m_sons[i].getEstimatedErrorsForBranch(instancesArray[i]);
        }
        return d;
    }

    protected double getEstimatedErrorsForDistribution(Distribution distribution) {
        if (Utils.eq(distribution.total(), 0.0)) {
            return 0.0;
        }
        double d = distribution.numIncorrect();
        double d2 = distribution.total();
        return (Stats.addErrs(d2, d, this.m_CF) + d) / d2;
    }

    protected double getEtimateConstModel(Distribution distribution) {
        if (Utils.eq(distribution.total(), 0.0)) {
            return 0.0;
        }
        double d = distribution.total();
        return (Stats.addErrs(d, this.m_constError, this.m_CF) + this.m_constError) / d;
    }

    public int getNumInnerNodes() {
        if (this.m_isLeaf) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < this.m_sons.length; ++i) {
            n += this.m_sons[i].getNumInnerNodes();
        }
        return n;
    }

    public int getNumLeaves() {
        int n;
        if (!this.m_isLeaf) {
            n = 0;
            int n2 = 0;
            for (int i = 0; i < this.m_sons.length; ++i) {
                n += this.m_sons[i].getNumLeaves();
                if (!this.m_sons[i].m_isLeaf || this.m_sons[i].hasModels()) continue;
                ++n2;
            }
            if (n2 > 1) {
                n -= n2 - 1;
            }
        } else {
            n = 1;
        }
        return n;
    }

    protected SimpleLinearRegression[][] mergeArrays(SimpleLinearRegression[][] simpleLinearRegressionArray, SimpleLinearRegression[][] simpleLinearRegressionArray2) {
        int n;
        int n2;
        int n3 = simpleLinearRegressionArray[0].length;
        int n4 = simpleLinearRegressionArray2[0].length;
        SimpleLinearRegression[][] simpleLinearRegressionArray3 = new SimpleLinearRegression[this.m_numClasses][n3 + n4];
        for (n2 = 0; n2 < this.m_numClasses; ++n2) {
            for (n = 0; n < n3; ++n) {
                simpleLinearRegressionArray3[n2][n] = simpleLinearRegressionArray[n2][n];
            }
        }
        for (n2 = 0; n2 < this.m_numClasses; ++n2) {
            for (n = 0; n < n4; ++n) {
                simpleLinearRegressionArray3[n2][n + n3] = simpleLinearRegressionArray2[n2][n];
            }
        }
        return simpleLinearRegressionArray3;
    }

    public Vector getNodes() {
        Vector vector = new Vector();
        this.getNodes(vector);
        return vector;
    }

    public void getNodes(Vector vector) {
        if (!this.m_isLeaf) {
            vector.add(this);
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].getNodes(vector);
            }
        }
    }

    protected Instances getNumericData(Instances instances) throws Exception {
        Instances instances2 = new Instances(instances);
        this.m_nominalToBinary = new NominalToBinary();
        this.m_nominalToBinary.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, this.m_nominalToBinary);
        return super.getNumericData(instances2);
    }

    protected double[] getFs(Instance instance) throws Exception {
        double[] dArray = new double[this.m_numClasses];
        double[] dArray2 = super.getFs(instance);
        for (int i = 0; i < this.m_numHigherRegressions; ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.m_numClasses; ++n) {
                dArray[n] = this.m_higherRegressions[n][i].classifyInstance(instance);
                d += dArray[n];
            }
            d /= (double)this.m_numClasses;
            for (n = 0; n < this.m_numClasses; ++n) {
                int n2 = n;
                dArray2[n2] = dArray2[n2] + (dArray[n] - d) * (double)(this.m_numClasses - 1) / (double)this.m_numClasses;
            }
        }
        return dArray2;
    }

    public int getConstError(double[] dArray) {
        return Utils.maxIndex(dArray);
    }

    public boolean hasModels() {
        return this.m_numRegressions > 0;
    }

    public double[] modelDistributionForInstance(Instance instance) throws Exception {
        instance = (Instance)instance.copy();
        this.m_nominalToBinary.input(instance);
        instance = this.m_nominalToBinary.output();
        instance.setDataset(this.m_numericDataHeader);
        return this.probs(this.getFs(instance));
    }

    public abstract double[] distributionForInstance(Instance var1) throws Exception;

    public String toString() {
        this.assignLeafModelNumbers(0);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_isLeaf && !this.m_hasConstr) {
                stringBuffer.append(": ");
                stringBuffer.append("Class=" + this.m_leafclass);
            } else if (this.m_isLeaf && this.m_hasConstr) {
                stringBuffer.append(": ");
                stringBuffer.append("FT_" + this.m_leafModelNum + ":" + this.getModelParameters());
            } else {
                this.dumpTree(0, stringBuffer);
            }
            stringBuffer.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            stringBuffer.append("\nSize of the Tree : \t" + this.numNodes() + "\n");
            stringBuffer.append(this.modelsToString());
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print logistic model tree";
        }
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.m_sons.length; ++i) {
            n += this.m_sons[i].numLeaves();
        }
        return n;
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int n = 1;
        for (int i = 0; i < this.m_sons.length; ++i) {
            n += this.m_sons[i].numNodes();
        }
        return n;
    }

    public String getModelParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_numRegressions + this.m_numHigherRegressions;
        stringBuffer.append(this.m_numRegressions + "/" + n + " (" + this.m_numInstances + ")");
        return stringBuffer.toString();
    }

    protected void dumpTree(int n, StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("\n");
            for (int j = 0; j < n; ++j) {
                stringBuffer.append("|   ");
            }
            if (this.m_hasConstr) {
                stringBuffer.append(this.m_localModel.leftSide(this.m_train) + "#" + this.m_id);
            } else {
                stringBuffer.append(this.m_localModel.leftSide(this.m_train));
            }
            stringBuffer.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf && this.m_sons[i].m_hasConstr) {
                stringBuffer.append(": ");
                stringBuffer.append("FT_" + this.m_sons[i].m_leafModelNum + ":" + this.m_sons[i].getModelParameters());
                continue;
            }
            if (this.m_sons[i].m_isLeaf && !this.m_sons[i].m_hasConstr) {
                stringBuffer.append(": ");
                stringBuffer.append("Class=" + this.m_sons[i].m_leafclass);
                continue;
            }
            this.m_sons[i].dumpTree(n + 1, stringBuffer);
        }
    }

    public int assignIDs(int n) {
        int n2;
        this.m_id = n2 = n + 1;
        if (this.m_sons != null) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                n2 = this.m_sons[i].assignIDs(n2);
            }
        }
        return n2;
    }

    public int assignLeafModelNumbers(int n) {
        if (!this.m_isLeaf) {
            this.m_leafModelNum = 0;
            for (int i = 0; i < this.m_sons.length; ++i) {
                n = this.m_sons[i].assignLeafModelNumbers(n);
            }
        } else {
            this.m_leafModelNum = ++n;
        }
        return n;
    }

    protected double[][] getCoefficients() {
        double[][] dArray = super.getCoefficients();
        double d = (double)(this.m_numClasses - 1) / (double)this.m_numClasses;
        for (int i = 0; i < this.m_numClasses; ++i) {
            for (int j = 0; j < this.m_numHigherRegressions; ++j) {
                double d2 = this.m_higherRegressions[i][j].getSlope();
                double d3 = this.m_higherRegressions[i][j].getIntercept();
                int n = this.m_higherRegressions[i][j].getAttributeIndex();
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] + d * d3;
                double[] dArray3 = dArray[i];
                int n2 = n + 1;
                dArray3[n2] = dArray3[n2] + d * d2;
            }
        }
        return dArray;
    }

    public String modelsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_isLeaf && this.m_hasConstr) {
            stringBuffer.append("FT_" + this.m_leafModelNum + ":" + super.toString());
        } else if (!this.m_isLeaf && this.m_hasConstr) {
            if (this.m_modelSelection instanceof BinC45ModelSelection) {
                stringBuffer.append("FT_N" + ((BinC45Split)this.m_localModel).attIndex() + "#" + this.m_id + ":" + super.toString());
            } else {
                stringBuffer.append("FT_N" + ((C45Split)this.m_localModel).attIndex() + "#" + this.m_id + ":" + super.toString());
            }
            for (int i = 0; i < this.m_sons.length; ++i) {
                stringBuffer.append("\n" + this.m_sons[i].modelsToString());
            }
        } else if (!this.m_isLeaf && !this.m_hasConstr) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                stringBuffer.append("\n" + this.m_sons[i].modelsToString());
            }
        } else if (this.m_isLeaf && !this.m_hasConstr) {
            stringBuffer.append("");
        }
        return stringBuffer.toString();
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.assignIDs(-1);
        this.assignLeafModelNumbers(0);
        stringBuffer.append("digraph FTree {\n");
        if (this.m_isLeaf && this.m_hasConstr) {
            stringBuffer.append("N" + this.m_id + " [label=\"FT_" + this.m_leafModelNum + ":" + this.getModelParameters() + "\" " + "shape=box style=filled");
            stringBuffer.append("]\n");
        } else if (this.m_isLeaf && !this.m_hasConstr) {
            stringBuffer.append("N" + this.m_id + " [label=\"Class=" + this.m_leafclass + "\" " + "shape=box style=filled");
            stringBuffer.append("]\n");
        } else {
            stringBuffer.append("N" + this.m_id + " [label=\"" + this.m_localModel.leftSide(this.m_train) + "\" ");
            stringBuffer.append("]\n");
            this.graphTree(stringBuffer);
        }
        return stringBuffer.toString() + "}\n";
    }

    protected void graphTree(StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("N" + this.m_id + "->" + "N" + this.m_sons[i].m_id + " [label=\"" + this.m_localModel.rightSide(i, this.m_train).trim() + "\"]\n");
            if (this.m_sons[i].m_isLeaf && this.m_sons[i].m_hasConstr) {
                stringBuffer.append("N" + this.m_sons[i].m_id + " [label=\"FT_" + this.m_sons[i].m_leafModelNum + ":" + this.m_sons[i].getModelParameters() + "\" " + "shape=box style=filled");
                stringBuffer.append("]\n");
                continue;
            }
            if (this.m_sons[i].m_isLeaf && !this.m_sons[i].m_hasConstr) {
                stringBuffer.append("N" + this.m_sons[i].m_id + " [label=\"Class=" + this.m_sons[i].m_leafclass + "\" " + "shape=box style=filled");
                stringBuffer.append("]\n");
                continue;
            }
            stringBuffer.append("N" + this.m_sons[i].m_id + " [label=\"" + this.m_sons[i].m_localModel.leftSide(this.m_train) + "\" ");
            stringBuffer.append("]\n");
            this.m_sons[i].graphTree(stringBuffer);
        }
    }

    public void cleanup() {
        super.cleanup();
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].cleanup();
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

