/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;

public class ResultSetHelper {
    protected ResultSet m_ResultSet;
    protected boolean m_Initialized = false;
    protected int m_MaxRows = 0;
    protected int m_ColumnCount = 0;
    protected int m_RowCount = 0;
    protected String[] m_ColumnNames = null;
    protected boolean[] m_NumericColumns = null;
    protected Class[] m_ColumnClasses = null;

    public ResultSetHelper(ResultSet resultSet) {
        this(resultSet, 0);
    }

    public ResultSetHelper(ResultSet resultSet, int n) {
        this.m_ResultSet = resultSet;
        this.m_MaxRows = n;
    }

    protected void initialize() {
        if (this.m_Initialized) {
            return;
        }
        try {
            block17: {
                int n;
                ResultSetMetaData resultSetMetaData = this.m_ResultSet.getMetaData();
                this.m_ColumnNames = new String[resultSetMetaData.getColumnCount()];
                for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                    this.m_ColumnNames[n - 1] = resultSetMetaData.getColumnName(n);
                }
                this.m_NumericColumns = new boolean[resultSetMetaData.getColumnCount()];
                for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                    this.m_NumericColumns[n - 1] = ResultSetHelper.typeIsNumeric(resultSetMetaData.getColumnType(n));
                }
                this.m_ColumnClasses = new Class[resultSetMetaData.getColumnCount()];
                for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                    try {
                        this.m_ColumnClasses[n - 1] = Class.forName(resultSetMetaData.getColumnClassName(n));
                        continue;
                    }
                    catch (Exception exception) {
                        try {
                            this.m_ColumnClasses[n - 1] = ResultSetHelper.typeToClass(resultSetMetaData.getColumnType(n));
                            continue;
                        }
                        catch (Exception exception2) {
                            this.m_ColumnClasses[n - 1] = String.class;
                        }
                    }
                }
                this.m_ColumnCount = resultSetMetaData.getColumnCount();
                this.m_RowCount = 0;
                this.m_ResultSet.first();
                if (this.m_MaxRows > 0) {
                    try {
                        this.m_ResultSet.absolute(this.m_MaxRows);
                        this.m_RowCount = this.m_ResultSet.getRow();
                    }
                    catch (Exception exception) {}
                } else {
                    this.m_ResultSet.last();
                    this.m_RowCount = this.m_ResultSet.getRow();
                }
                try {
                    if (this.m_RowCount != 0 || !this.m_ResultSet.first()) break block17;
                    this.m_RowCount = 1;
                    while (this.m_ResultSet.next()) {
                        ++this.m_RowCount;
                        if (this.m_ResultSet.getRow() != this.m_MaxRows) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_Initialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResultSet getResultSet() {
        return this.m_ResultSet;
    }

    public int getColumnCount() {
        this.initialize();
        return this.m_ColumnCount;
    }

    public int getRowCount() {
        this.initialize();
        return this.m_RowCount;
    }

    public String[] getColumnNames() {
        this.initialize();
        return this.m_ColumnNames;
    }

    public boolean[] getNumericColumns() {
        this.initialize();
        return this.m_NumericColumns;
    }

    public Class[] getColumnClasses() {
        this.initialize();
        return this.m_ColumnClasses;
    }

    public boolean hasMaxRows() {
        return this.m_MaxRows > 0;
    }

    public int getMaxRows() {
        return this.m_MaxRows;
    }

    public Object[][] getCells() {
        this.initialize();
        Object[][] objectArray = new Object[this.getRowCount()][this.getColumnCount()];
        try {
            this.m_ResultSet.first();
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    try {
                        objectArray[i][j] = this.m_ResultSet.getObject(j + 1);
                        continue;
                    }
                    catch (Exception exception) {
                        objectArray[i][j] = null;
                    }
                }
                if (i != this.getRowCount() - 1) {
                    this.m_ResultSet.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return objectArray;
    }

    public static Class typeToClass(int n) {
        Class clazz;
        switch (n) {
            case -5: {
                clazz = Long.class;
                break;
            }
            case -2: {
                clazz = String.class;
            }
            case -7: {
                clazz = Boolean.class;
                break;
            }
            case 1: {
                clazz = Character.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 3: {
                clazz = Double.class;
                break;
            }
            case 8: {
                clazz = Double.class;
                break;
            }
            case 6: {
                clazz = Float.class;
                break;
            }
            case 4: {
                clazz = Integer.class;
                break;
            }
            case -4: {
                clazz = String.class;
                break;
            }
            case -1: {
                clazz = String.class;
                break;
            }
            case 0: {
                clazz = String.class;
                break;
            }
            case 2: {
                clazz = Double.class;
                break;
            }
            case 1111: {
                clazz = String.class;
                break;
            }
            case 7: {
                clazz = Double.class;
                break;
            }
            case 5: {
                clazz = Short.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case -6: {
                clazz = Short.class;
                break;
            }
            case -3: {
                clazz = String.class;
                break;
            }
            case 12: {
                clazz = String.class;
                break;
            }
            default: {
                clazz = null;
            }
        }
        return clazz;
    }

    public static boolean typeIsNumeric(int n) {
        boolean bl;
        switch (n) {
            case -5: {
                bl = true;
                break;
            }
            case -2: {
                bl = false;
            }
            case -7: {
                bl = false;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            case 91: {
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 8: {
                bl = true;
                break;
            }
            case 6: {
                bl = true;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case -4: {
                bl = false;
                break;
            }
            case -1: {
                bl = false;
                break;
            }
            case 0: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 1111: {
                bl = false;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            case 92: {
                bl = false;
                break;
            }
            case 93: {
                bl = true;
                break;
            }
            case -6: {
                bl = true;
                break;
            }
            case -3: {
                bl = false;
                break;
            }
            case 12: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

