/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.core.Queue;
import weka.experiment.Compute;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;

public class RemoteEngine
extends UnicastRemoteObject
implements Compute {
    private static final long serialVersionUID = -1021538162895448259L;
    private String m_HostName = "local";
    private Queue m_TaskQueue = new Queue();
    private Queue m_TaskIdQueue = new Queue();
    private Hashtable m_TaskStatus = new Hashtable();
    private boolean m_TaskRunning = false;

    public RemoteEngine(String string) throws RemoteException {
        this.m_HostName = string;
        Thread thread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(3600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (RemoteEngine.this.m_TaskStatus.size() > 0) {
                        RemoteEngine.this.purge();
                        continue;
                    }
                    System.err.println("RemoteEngine : purge - no tasks to check.");
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public synchronized Object executeTask(Task task) throws RemoteException {
        String string = "" + System.currentTimeMillis() + ":";
        string = string + task.hashCode();
        this.addTaskToQueue(task, string);
        return string;
    }

    public Object checkStatus(Object object) throws Exception {
        TaskStatusInfo taskStatusInfo = (TaskStatusInfo)this.m_TaskStatus.get(object);
        if (taskStatusInfo == null) {
            throw new Exception("RemoteEngine (" + this.m_HostName + ") : Task not found.");
        }
        TaskStatusInfo taskStatusInfo2 = new TaskStatusInfo();
        taskStatusInfo2.setExecutionStatus(taskStatusInfo.getExecutionStatus());
        taskStatusInfo2.setStatusMessage(taskStatusInfo.getStatusMessage());
        taskStatusInfo2.setTaskResult(taskStatusInfo.getTaskResult());
        if (taskStatusInfo.getExecutionStatus() == 3 || taskStatusInfo.getExecutionStatus() == 2) {
            System.err.println("Finished/failed Task id : " + object + " checked by client. Removing.");
            taskStatusInfo.setTaskResult(null);
            taskStatusInfo = null;
            this.m_TaskStatus.remove(object);
        }
        taskStatusInfo = null;
        return taskStatusInfo2;
    }

    private synchronized void addTaskToQueue(Task task, String string) {
        TaskStatusInfo taskStatusInfo = task.getTaskStatus();
        if (taskStatusInfo == null) {
            taskStatusInfo = new TaskStatusInfo();
        }
        this.m_TaskQueue.push(task);
        this.m_TaskIdQueue.push(string);
        taskStatusInfo.setStatusMessage("RemoteEngine (" + this.m_HostName + ") : task queued at postion: " + this.m_TaskQueue.size());
        this.m_TaskStatus.put(string, taskStatusInfo);
        System.err.println("Task id : " + string + "Queued.");
        if (!this.m_TaskRunning) {
            this.startTask();
        }
    }

    private void startTask() {
        if (!this.m_TaskRunning && this.m_TaskQueue.size() > 0) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    RemoteEngine.this.m_TaskRunning = true;
                    Task task = (Task)RemoteEngine.this.m_TaskQueue.pop();
                    String string = (String)RemoteEngine.this.m_TaskIdQueue.pop();
                    TaskStatusInfo taskStatusInfo = (TaskStatusInfo)RemoteEngine.this.m_TaskStatus.get(string);
                    taskStatusInfo.setExecutionStatus(1);
                    taskStatusInfo.setStatusMessage("RemoteEngine (" + RemoteEngine.this.m_HostName + ") : task running...");
                    try {
                        System.err.println("Launching task id : " + string + "...");
                        task.execute();
                        TaskStatusInfo taskStatusInfo2 = task.getTaskStatus();
                        taskStatusInfo.setExecutionStatus(taskStatusInfo2.getExecutionStatus());
                        taskStatusInfo.setStatusMessage("RemoteExperiment (" + RemoteEngine.this.m_HostName + ") " + taskStatusInfo2.getStatusMessage());
                        taskStatusInfo.setTaskResult(taskStatusInfo2.getTaskResult());
                    }
                    catch (Exception exception) {
                        taskStatusInfo.setExecutionStatus(2);
                        taskStatusInfo.setStatusMessage("RemoteEngine (" + RemoteEngine.this.m_HostName + ") : task failed.");
                        System.err.println("Task id " + string + "Failed!");
                    }
                    finally {
                        if (RemoteEngine.this.m_TaskStatus.size() == 0) {
                            RemoteEngine.this.purgeClasses();
                        }
                        RemoteEngine.this.m_TaskRunning = false;
                        RemoteEngine.this.startTask();
                    }
                }
            };
            thread.setPriority(1);
            thread.start();
        }
    }

    private void purgeClasses() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{new URL("file:.")}, classLoader);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void purge() {
        Enumeration enumeration = this.m_TaskStatus.keys();
        long l = System.currentTimeMillis();
        System.err.println("RemoteEngine purge. Current time : " + l);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.err.print("Examining task id : " + string + "...");
            String string2 = string.substring(0, string.indexOf(58));
            long l2 = Long.valueOf(string2);
            if (l - l2 > 3600000L) {
                TaskStatusInfo taskStatusInfo = null;
                if ((taskStatusInfo = (TaskStatusInfo)this.m_TaskStatus.get(taskStatusInfo)) == null || taskStatusInfo.getExecutionStatus() != 3 && taskStatusInfo.getExecutionStatus() != 2) continue;
                System.err.println("\nTask id : " + string + " has gone stale. Removing.");
                this.m_TaskStatus.remove(string);
                taskStatusInfo.setTaskResult(null);
                taskStatusInfo = null;
                continue;
            }
            System.err.println("ok.");
        }
        if (this.m_TaskStatus.size() == 0) {
            this.purgeClasses();
        }
    }

    public static void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            System.err.println("Host name : " + inetAddress.getHostName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = inetAddress != null ? "//" + inetAddress.getHostName() + "/RemoteEngine" : "//localhost/RemoteEngine";
        try {
            RemoteEngine remoteEngine = new RemoteEngine(string);
            Naming.rebind(string, remoteEngine);
            System.out.println("RemoteEngine bound in RMI registry");
        }
        catch (Exception exception) {
            System.err.println("RemoteEngine exception: " + exception.getMessage());
            try {
                System.err.println("Attempting to start rmi registry...");
                LocateRegistry.createRegistry(1099);
                RemoteEngine remoteEngine = new RemoteEngine(string);
                Naming.rebind(string, remoteEngine);
                System.out.println("RemoteEngine bound in RMI registry");
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }
}

