/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;

public class InstancesSummaryPanel
extends JPanel {
    private static final long serialVersionUID = -5243579535296681063L;
    protected static final String NO_SOURCE = "None";
    protected JLabel m_RelationNameLab = new JLabel("None");
    protected JLabel m_NumInstancesLab = new JLabel("None");
    protected JLabel m_NumAttributesLab = new JLabel("None");
    protected Instances m_Instances;

    public InstancesSummaryPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Relation:", 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(this.m_RelationNameLab, gridBagConstraints);
        this.add(this.m_RelationNameLab);
        this.m_RelationNameLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        jLabel = new JLabel("Instances:", 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagLayout.setConstraints(this.m_NumInstancesLab, gridBagConstraints);
        this.add(this.m_NumInstancesLab);
        this.m_NumInstancesLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        jLabel = new JLabel("Attributes:", 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagLayout.setConstraints(this.m_NumAttributesLab, gridBagConstraints);
        this.add(this.m_NumAttributesLab);
        this.m_NumAttributesLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_RelationNameLab.setText(this.m_Instances.relationName());
        this.m_NumInstancesLab.setText("" + this.m_Instances.numInstances());
        this.m_NumAttributesLab.setText("" + this.m_Instances.numAttributes());
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Instances Panel");
            jFrame.getContentPane().setLayout(new BorderLayout());
            InstancesSummaryPanel instancesSummaryPanel = new InstancesSummaryPanel();
            instancesSummaryPanel.setBorder(BorderFactory.createTitledBorder("Relation"));
            jFrame.getContentPane().add((Component)instancesSummaryPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            if (stringArray.length == 1) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                instancesSummaryPanel.setInstances(instances);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

