/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import weka.gui.ListSelectorDialog;
import weka.gui.sql.DbUtils;
import weka.gui.sql.event.ConnectionEvent;
import weka.gui.sql.event.ConnectionListener;
import weka.gui.sql.event.HistoryChangedEvent;
import weka.gui.sql.event.HistoryChangedListener;
import weka.gui.sql.event.QueryExecuteEvent;
import weka.gui.sql.event.QueryExecuteListener;

public class QueryPanel
extends JPanel
implements ConnectionListener,
CaretListener {
    private static final long serialVersionUID = 4348967824619706636L;
    public static final String HISTORY_NAME = "query";
    public static final String MAX_ROWS = "max_rows";
    protected JFrame m_Parent;
    protected JTextArea m_TextQuery;
    protected JButton m_ButtonExecute = new JButton("Execute");
    protected JButton m_ButtonClear = new JButton("Clear");
    protected JButton m_ButtonHistory = new JButton("History...");
    protected JSpinner m_SpinnerMaxRows = new JSpinner();
    protected HashSet m_QueryExecuteListeners;
    protected HashSet m_HistoryChangedListeners;
    protected DbUtils m_DbUtils;
    protected boolean m_Connected;
    protected DefaultListModel m_History = new DefaultListModel();

    public QueryPanel(JFrame jFrame) {
        this.m_Parent = jFrame;
        this.m_QueryExecuteListeners = new HashSet();
        this.m_HistoryChangedListeners = new HashSet();
        this.m_DbUtils = null;
        this.m_Connected = false;
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.m_TextQuery = new JTextArea();
        this.m_TextQuery.addCaretListener(this);
        this.m_TextQuery.setFont(new Font("Monospaced", 0, this.m_TextQuery.getFont().getSize()));
        this.add((Component)new JScrollPane(this.m_TextQuery), "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "East");
        this.m_ButtonExecute.setMnemonic('E');
        this.m_ButtonExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryPanel.this.execute();
            }
        });
        jPanel.add((Component)this.m_ButtonExecute, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        this.m_ButtonClear.setMnemonic('C');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryPanel.this.clear();
            }
        });
        jPanel2.add((Component)this.m_ButtonClear, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel3, "Center");
        this.m_ButtonHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryPanel.this.showHistory();
            }
        });
        jPanel3.add((Component)this.m_ButtonHistory, "North");
        jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(new JLabel("max. rows"));
        jPanel3.add(this.m_SpinnerMaxRows);
        jPanel2.add((Component)jPanel3, "South");
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.m_SpinnerMaxRows.getModel();
        spinnerNumberModel.setMaximum(new Integer(Integer.MAX_VALUE));
        spinnerNumberModel.setMinimum(new Integer(0));
        spinnerNumberModel.setValue(new Integer(100));
        spinnerNumberModel.setStepSize(new Integer(100));
        this.m_SpinnerMaxRows.setMinimumSize(new Dimension(50, this.m_SpinnerMaxRows.getHeight()));
        this.m_SpinnerMaxRows.setToolTipText("with 0 all rows are retrieved");
        this.setButtons();
    }

    public void setFocus() {
        this.m_TextQuery.requestFocus();
    }

    protected void setButtons() {
        boolean bl = this.m_TextQuery.getText().trim().equals("");
        this.m_ButtonExecute.setEnabled(this.m_Connected && !bl);
        this.m_ButtonClear.setEnabled(!bl);
        this.m_ButtonHistory.setEnabled(this.m_History.size() > 0);
    }

    public void connectionChange(ConnectionEvent connectionEvent) {
        this.m_Connected = connectionEvent.isConnected();
        this.m_DbUtils = connectionEvent.getDbUtils();
        this.setButtons();
    }

    public void execute() {
        if (!this.m_ButtonExecute.isEnabled()) {
            return;
        }
        if (this.m_TextQuery.getText().trim().equals("")) {
            return;
        }
        try {
            if (this.m_DbUtils.getResultSet() != null) {
                this.m_DbUtils.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Exception exception = null;
        ResultSet resultSet = null;
        try {
            if (this.m_DbUtils.execute(this.getQuery())) {
                resultSet = this.m_DbUtils.getResultSet();
                this.addHistory(this.getQuery());
            }
        }
        catch (Exception exception2) {
            exception = new Exception(exception2.getMessage());
        }
        this.notifyQueryExecuteListeners(resultSet, exception);
        this.setButtons();
    }

    public void clear() {
        this.m_TextQuery.setText("");
        this.m_SpinnerMaxRows.setValue(new Integer(100));
    }

    protected void addHistory(String string) {
        if (string.equals("")) {
            return;
        }
        if (this.m_History.contains(string)) {
            this.m_History.removeElement(string);
        }
        this.m_History.add(0, string);
        this.notifyHistoryChangedListeners();
    }

    public void setHistory(DefaultListModel defaultListModel) {
        this.m_History.clear();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            this.m_History.addElement(defaultListModel.get(i));
        }
        this.setButtons();
    }

    public DefaultListModel getHistory() {
        return this.m_History;
    }

    public void showHistory() {
        JList jList = new JList(this.m_History);
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog((Frame)this.m_Parent, jList);
        if (listSelectorDialog.showDialog() == 0 && jList.getSelectedValue() != null) {
            this.setQuery(jList.getSelectedValue().toString());
        }
        this.setButtons();
    }

    public void setQuery(String string) {
        this.m_TextQuery.setText(string);
    }

    public String getQuery() {
        return this.m_TextQuery.getText();
    }

    public void setMaxRows(int n) {
        if (n >= 0) {
            this.m_SpinnerMaxRows.setValue(new Integer(n));
        }
    }

    public int getMaxRows() {
        return (Integer)this.m_SpinnerMaxRows.getValue();
    }

    public void addQueryExecuteListener(QueryExecuteListener queryExecuteListener) {
        this.m_QueryExecuteListeners.add(queryExecuteListener);
    }

    public void removeQueryExecuteListener(QueryExecuteListener queryExecuteListener) {
        this.m_QueryExecuteListeners.remove(queryExecuteListener);
    }

    protected void notifyQueryExecuteListeners(ResultSet resultSet, Exception exception) {
        for (QueryExecuteListener queryExecuteListener : this.m_QueryExecuteListeners) {
            queryExecuteListener.queryExecuted(new QueryExecuteEvent(this, this.m_DbUtils, this.getQuery(), this.getMaxRows(), resultSet, exception));
        }
    }

    public void addHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.m_HistoryChangedListeners.add(historyChangedListener);
    }

    public void removeHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.m_HistoryChangedListeners.remove(historyChangedListener);
    }

    protected void notifyHistoryChangedListeners() {
        for (HistoryChangedListener historyChangedListener : this.m_HistoryChangedListeners) {
            historyChangedListener.historyChanged(new HistoryChangedEvent(this, HISTORY_NAME, this.getHistory()));
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.setButtons();
    }
}

