/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.Serializable;
import weka.classifiers.misc.monotone.DiscreteDistribution;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public class CumulativeDiscreteDistribution
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -2959806903004453176L;
    private static final double TOLERANCE = Utils.SMALL;
    private double[] m_cdf;

    public CumulativeDiscreteDistribution(DiscreteEstimator e) {
        this.m_cdf = new double[e.getNumSymbols()];
        if (this.m_cdf.length != 0) {
            this.m_cdf[0] = e.getProbability(0.0);
        }
        for (int i = 1; i < this.m_cdf.length; ++i) {
            this.m_cdf[i] = this.m_cdf[i - 1] + e.getProbability(i);
        }
    }

    public CumulativeDiscreteDistribution(DiscreteDistribution d) {
        this.m_cdf = new double[d.getNumSymbols()];
        if (this.m_cdf.length != 0) {
            this.m_cdf[0] = d.getProbability(0);
        }
        for (int i = 1; i < this.m_cdf.length; ++i) {
            this.m_cdf[i] = this.m_cdf[i - 1] + d.getProbability(i);
        }
    }

    public CumulativeDiscreteDistribution(double[] cdf) throws IllegalArgumentException {
        if (!CumulativeDiscreteDistribution.validCumulativeDistribution(cdf)) {
            throw new IllegalArgumentException("Not a cumulative probability distribution");
        }
        this.m_cdf = new double[cdf.length];
        System.arraycopy(cdf, 0, this.m_cdf, 0, cdf.length);
    }

    public int getNumSymbols() {
        return this.m_cdf != null ? this.m_cdf.length : 0;
    }

    public double getCumulativeProbability(int index) {
        return this.m_cdf[index];
    }

    public double[] toArray() {
        double[] cdf = new double[this.m_cdf.length];
        System.arraycopy(this.m_cdf, 0, cdf, 0, cdf.length);
        return cdf;
    }

    public boolean stochasticDominatedBy(CumulativeDiscreteDistribution cdf) throws IllegalArgumentException {
        if (this.getNumSymbols() != cdf.getNumSymbols()) {
            throw new IllegalArgumentException("Cumulative distributions are not defined over the same number of symbols");
        }
        for (int i = 0; i < this.m_cdf.length; ++i) {
            if (!(this.m_cdf[i] < cdf.m_cdf[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CumulativeDiscreteDistribution)) {
            return false;
        }
        CumulativeDiscreteDistribution cdf = (CumulativeDiscreteDistribution)o;
        if (this.m_cdf.length != cdf.getNumSymbols()) {
            return false;
        }
        for (int i = 0; i < this.m_cdf.length; ++i) {
            if (!(Math.abs(this.m_cdf[i] - cdf.m_cdf[i]) > TOLERANCE)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "[" + this.getNumSymbols() + "]:";
        for (int i = 0; i < this.getNumSymbols(); ++i) {
            s = s + " " + this.getCumulativeProbability(i);
        }
        return s;
    }

    private static boolean validCumulativeDistribution(double[] cdf) {
        if (cdf == null || cdf.length == 0 || Math.abs(cdf[cdf.length - 1] - 1.0) > TOLERANCE || cdf[0] < 0.0) {
            return false;
        }
        for (int i = 1; i < cdf.length; ++i) {
            if (!(cdf[i] < cdf[i - 1] - TOLERANCE)) continue;
            return false;
        }
        return true;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5922 $");
    }
}

