/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class HierarchyPropertyParser
implements Serializable {
    private static final long serialVersionUID = -4151103338506077544L;
    private TreeNode m_Root = new TreeNode();
    private TreeNode m_Current;
    private String m_Seperator = ".";
    private int m_Depth = 0;

    public HierarchyPropertyParser() {
        this.m_Root.parent = null;
        this.m_Root.children = new Vector();
        this.goToRoot();
    }

    public HierarchyPropertyParser(String p, String delim) throws Exception {
        this();
        this.build(p, delim);
    }

    public void setSeperator(String s) {
        this.m_Seperator = s;
    }

    public String getSeperator() {
        return this.m_Seperator;
    }

    public void build(String p, String delim) throws Exception {
        StringTokenizer st = new StringTokenizer(p, delim);
        while (st.hasMoreTokens()) {
            String property = st.nextToken().trim();
            if (!this.isHierachic(property)) {
                throw new Exception("The given property is not inhierachy structure with seperators!");
            }
            this.add(property);
        }
        this.goToRoot();
    }

    public synchronized void add(String property) {
        String[] values = this.tokenize(property);
        if (this.m_Root.value == null) {
            this.m_Root.value = values[0];
        }
        this.buildBranch(this.m_Root, values, 1);
    }

    private void buildBranch(TreeNode parent, String[] values, int lvl) {
        Vector kids;
        int index;
        if (lvl == values.length) {
            parent.children = null;
            return;
        }
        if (lvl > this.m_Depth - 1) {
            this.m_Depth = lvl + 1;
        }
        if ((index = this.search(kids = parent.children, values[lvl])) != -1) {
            TreeNode newParent = (TreeNode)kids.elementAt(index);
            if (newParent.children == null) {
                newParent.children = new Vector();
            }
            this.buildBranch(newParent, values, lvl + 1);
        } else {
            TreeNode added = new TreeNode();
            added.parent = parent;
            added.value = values[lvl];
            added.children = new Vector();
            added.level = lvl;
            added.context = parent != this.m_Root ? parent.context + this.m_Seperator + parent.value : parent.value;
            kids.addElement(added);
            this.buildBranch(added, values, lvl + 1);
        }
    }

    public String[] tokenize(String rawString) {
        Vector<String> result = new Vector<String>();
        StringTokenizer tk = new StringTokenizer(rawString, this.m_Seperator);
        while (tk.hasMoreTokens()) {
            result.addElement(tk.nextToken());
        }
        String[] newStrings = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            newStrings[i] = (String)result.elementAt(i);
        }
        return newStrings;
    }

    public boolean contains(String string) {
        String[] item = this.tokenize(string);
        if (!item[0].equals(this.m_Root.value)) {
            return false;
        }
        return this.isContained(this.m_Root, item, 1);
    }

    private boolean isContained(TreeNode parent, String[] values, int lvl) {
        if (lvl == values.length) {
            return true;
        }
        if (lvl > values.length) {
            return false;
        }
        Vector kids = parent.children;
        int index = this.search(kids, values[lvl]);
        if (index != -1) {
            TreeNode newParent = (TreeNode)kids.elementAt(index);
            return this.isContained(newParent, values, lvl + 1);
        }
        return false;
    }

    public boolean isHierachic(String string) {
        int index = string.indexOf(this.m_Seperator);
        return index != string.length() - 1 && index != -1;
    }

    public int search(Vector vct, String target) {
        if (vct == null) {
            return -1;
        }
        for (int i = 0; i < vct.size(); ++i) {
            if (!target.equals(((TreeNode)vct.elementAt((int)i)).value)) continue;
            return i;
        }
        return -1;
    }

    public synchronized boolean goTo(String path) {
        if (!this.isHierachic(path)) {
            if (this.m_Root.value.equals(path)) {
                this.goToRoot();
                return true;
            }
            return false;
        }
        TreeNode old = this.m_Current;
        this.m_Current = new TreeNode();
        this.goToRoot();
        String[] nodes = this.tokenize(path);
        if (!this.m_Current.value.equals(nodes[0])) {
            return false;
        }
        for (int i = 1; i < nodes.length; ++i) {
            int pos = this.search(this.m_Current.children, nodes[i]);
            if (pos == -1) {
                this.m_Current = old;
                return false;
            }
            this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
        }
        return true;
    }

    public synchronized boolean goDown(String path) {
        if (!this.isHierachic(path)) {
            return this.goToChild(path);
        }
        TreeNode old = this.m_Current;
        this.m_Current = new TreeNode();
        String[] nodes = this.tokenize(path);
        int pos = this.search(old.children, nodes[0]);
        if (pos == -1) {
            this.m_Current = old;
            return false;
        }
        this.m_Current = (TreeNode)old.children.elementAt(pos);
        for (int i = 1; i < nodes.length; ++i) {
            pos = this.search(this.m_Current.children, nodes[i]);
            if (pos == -1) {
                this.m_Current = old;
                return false;
            }
            this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
        }
        return true;
    }

    public synchronized void goToRoot() {
        this.m_Current = this.m_Root;
    }

    public synchronized void goToParent() {
        if (this.m_Current.parent != null) {
            this.m_Current = this.m_Current.parent;
        }
    }

    public synchronized boolean goToChild(String value) {
        if (this.m_Current.children == null) {
            return false;
        }
        int pos = this.search(this.m_Current.children, value);
        if (pos == -1) {
            return false;
        }
        this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
        return true;
    }

    public synchronized void goToChild(int pos) throws Exception {
        if (this.m_Current.children == null || pos < 0 || pos >= this.m_Current.children.size()) {
            throw new Exception("Position out of range or leaf reached");
        }
        this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
    }

    public synchronized int numChildren() {
        if (this.m_Current.children == null) {
            return 0;
        }
        return this.m_Current.children.size();
    }

    public synchronized String[] childrenValues() {
        if (this.m_Current.children == null) {
            return null;
        }
        Vector kids = this.m_Current.children;
        String[] values = new String[kids.size()];
        for (int i = 0; i < kids.size(); ++i) {
            values[i] = ((TreeNode)kids.elementAt((int)i)).value;
        }
        return values;
    }

    public synchronized String parentValue() {
        if (this.m_Current.parent != null) {
            return this.m_Current.parent.value;
        }
        return null;
    }

    public synchronized boolean isLeafReached() {
        return this.m_Current.children == null;
    }

    public synchronized boolean isRootReached() {
        return this.m_Current.parent == null;
    }

    public synchronized String getValue() {
        return this.m_Current.value;
    }

    public synchronized int getLevel() {
        return this.m_Current.level;
    }

    public int depth() {
        return this.m_Depth;
    }

    public synchronized String context() {
        return this.m_Current.context;
    }

    public synchronized String fullValue() {
        if (this.m_Current == this.m_Root) {
            return this.m_Root.value;
        }
        return this.m_Current.context + this.m_Seperator + this.m_Current.value;
    }

    public String showTree() {
        return this.showNode(this.m_Root, null);
    }

    private String showNode(TreeNode node, boolean[] hasBar) {
        int i;
        StringBuffer text = new StringBuffer();
        for (i = 0; i < node.level - 1; ++i) {
            if (hasBar[i]) {
                text.append("  |       ");
                continue;
            }
            text.append("          ");
        }
        if (node.level != 0) {
            text.append("  |------ ");
        }
        text.append(node.value + "(" + node.level + ")" + "[" + node.context + "]\n");
        if (node.children != null) {
            for (i = 0; i < node.children.size(); ++i) {
                boolean[] newBar = new boolean[node.level + 1];
                int lvl = node.level;
                if (hasBar != null) {
                    for (int j = 0; j < lvl; ++j) {
                        newBar[j] = hasBar[j];
                    }
                }
                newBar[lvl] = i != node.children.size() - 1;
                text.append(this.showNode((TreeNode)node.children.elementAt(i), newBar));
            }
        }
        return text.toString();
    }

    public static void main(String[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("node1.node1_1.node1_1_1.node1_1_1_1, ");
        sb.append("node1.node1_1.node1_1_1.node1_1_1_2, ");
        sb.append("node1.node1_1.node1_1_1.node1_1_1_3, ");
        sb.append("node1.node1_1.node1_1_2.node1_1_2_1, ");
        sb.append("node1.node1_1.node1_1_3.node1_1_3_1, ");
        sb.append("node1.node1_2.node1_2_1.node1_2_1_1, ");
        sb.append("node1.node1_2.node1_2_3.node1_2_3_1, ");
        sb.append("node1.node1_3.node1_3_3.node1_3_3_1, ");
        sb.append("node1.node1_3.node1_3_3.node1_3_3_2, ");
        String p = sb.toString();
        try {
            HierarchyPropertyParser hpp = new HierarchyPropertyParser(p, ", ");
            System.out.println("seperator: " + hpp.getSeperator());
            System.out.println("depth: " + hpp.depth());
            System.out.println("The tree:\n\n" + hpp.showTree());
            hpp.goToRoot();
            System.out.println("goto: " + hpp.goTo("node1.node1_2.node1_2_1") + ": " + hpp.getValue() + " | " + hpp.fullValue() + " leaf? " + hpp.isLeafReached());
            System.out.println("go down(wrong): " + hpp.goDown("node1"));
            System.out.println("Stay still? " + hpp.getValue());
            System.out.println("go to child: " + hpp.goToChild("node1_2_1_1") + ": " + hpp.getValue() + " | " + hpp.fullValue() + " leaf? " + hpp.isLeafReached() + " root? " + hpp.isRootReached());
            System.out.println("parent: " + hpp.parentValue());
            System.out.println("level: " + hpp.getLevel());
            System.out.println("context: " + hpp.context());
            hpp.goToRoot();
            System.out.println("After gotoRoot. leaf? " + hpp.isLeafReached() + " root? " + hpp.isRootReached());
            System.out.println("Go down(correct): " + hpp.goDown("node1_1.node1_1_1") + " value: " + hpp.getValue() + " | " + hpp.fullValue() + " level: " + hpp.getLevel() + " leaf? " + hpp.isLeafReached() + " root? " + hpp.isRootReached());
            hpp.goToParent();
            System.out.println("value: " + hpp.getValue() + " | " + hpp.fullValue());
            System.out.println("level: " + hpp.getLevel());
            String[] chd = hpp.childrenValues();
            for (int i = 0; i < chd.length; ++i) {
                System.out.print("children " + i + ": " + chd[i]);
                hpp.goDown(chd[i]);
                System.out.println("real value: " + hpp.getValue() + " | " + hpp.fullValue() + "(level: " + hpp.getLevel() + ")");
                hpp.goToParent();
            }
            System.out.println("Another way to go to root:" + hpp.goTo("node1") + ": " + hpp.getValue() + " | " + hpp.fullValue());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private class TreeNode {
        public TreeNode parent = null;
        public String value = null;
        public Vector children = null;
        public int level = 0;
        public String context = null;

        private TreeNode() {
        }
    }
}

