/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.tertius;

import java.io.Serializable;
import java.util.ArrayList;
import weka.associations.tertius.Literal;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Predicate
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8374702481965026640L;
    private ArrayList m_literals = new ArrayList();
    private String m_name;
    private int m_index;
    private boolean m_isClass;

    public Predicate(String name, int index, boolean isClass) {
        this.m_name = name;
        this.m_index = index;
        this.m_isClass = isClass;
    }

    public void addLiteral(Literal lit) {
        this.m_literals.add(lit);
    }

    public Literal getLiteral(int index) {
        return (Literal)this.m_literals.get(index);
    }

    public int getIndex() {
        return this.m_index;
    }

    public int indexOf(Literal lit) {
        int index = this.m_literals.indexOf(lit);
        return index != -1 ? index : this.m_literals.indexOf(lit.getNegation());
    }

    public int numLiterals() {
        return this.m_literals.size();
    }

    public boolean isClass() {
        return this.m_isClass;
    }

    public String toString() {
        return this.m_name;
    }

    public String description() {
        StringBuffer text = new StringBuffer();
        text.append(this.toString() + "\n");
        for (int i = 0; i < this.numLiterals(); ++i) {
            Literal lit = this.getLiteral(i);
            Literal neg = lit.getNegation();
            text.append("\t" + lit + "\t" + neg + "\n");
        }
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

