/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.ConditionalDensityEstimator;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.Utils;
import weka.estimators.UnivariateDensityEstimator;
import weka.estimators.UnivariateEqualFrequencyHistogramEstimator;
import weka.estimators.UnivariateIntervalEstimator;
import weka.estimators.UnivariateKernelEstimator;
import weka.estimators.UnivariateNormalEstimator;
import weka.estimators.UnivariateQuantileEstimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;

public class RegressionByDiscretization
extends SingleClassifierEnhancer
implements IntervalEstimator,
ConditionalDensityEstimator {
    static final long serialVersionUID = 5066426153134050378L;
    protected Discretize m_Discretizer = new Discretize();
    protected int m_NumBins = 10;
    protected double[] m_ClassMeans;
    protected int[] m_ClassCounts;
    protected boolean m_DeleteEmptyBins;
    protected Instances m_DiscretizedHeader = null;
    protected boolean m_UseEqualFrequency = false;
    protected boolean m_MinimizeAbsoluteError = false;
    public static final int ESTIMATOR_HISTOGRAM = 0;
    public static final int ESTIMATOR_KERNEL = 1;
    public static final int ESTIMATOR_NORMAL = 2;
    public static final Tag[] TAGS_ESTIMATOR = new Tag[]{new Tag(0, "Histogram density estimator"), new Tag(1, "Kernel density estimator"), new Tag(2, "Normal density estimator")};
    protected int m_estimatorType = 0;
    protected double[] m_OriginalTargetValues = null;
    protected int[] m_NewTargetValues = null;

    public String globalInfo() {
        return "A regression scheme that employs any classifier on a copy of the data that has the class attribute discretized. The predicted value is the expected value of the mean class value for each discretized interval (based on the predicted probabilities for each interval). This class now also supports conditional density estimation by building a univariate density estimator from the target values in the training data, weighted by the class probabilities. \n\nFor more information on this process, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Remco R. Bouckaert");
        result.setValue(TechnicalInformation.Field.TITLE, "Conditional Density Estimation with Class Probability Estimators");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "First Asian Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.PAGES, "65-81");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer Verlag");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Berlin");
        return result;
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public RegressionByDiscretization() {
        this.m_Classifier = new J48();
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.setMinimumNumberInstances(2);
        return result;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int i;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Discretizer.setIgnoreClass(true);
        this.m_Discretizer.setAttributeIndices("" + (instances.classIndex() + 1));
        this.m_Discretizer.setBins(this.getNumBins());
        this.m_Discretizer.setUseEqualFrequency(this.getUseEqualFrequency());
        this.m_Discretizer.setInputFormat(instances);
        Instances newTrain = Filter.useFilter(instances, this.m_Discretizer);
        if (this.m_DeleteEmptyBins) {
            int numNonEmptyClasses = 0;
            boolean[] notEmptyClass = new boolean[newTrain.numClasses()];
            for (int i2 = 0; i2 < newTrain.numInstances(); ++i2) {
                if (notEmptyClass[(int)newTrain.instance(i2).classValue()]) continue;
                ++numNonEmptyClasses;
                notEmptyClass[(int)newTrain.instance((int)i2).classValue()] = true;
            }
            FastVector<String> newClassVals = new FastVector<String>(numNonEmptyClasses);
            int[] oldIndexToNewIndex = new int[newTrain.numClasses()];
            for (int i3 = 0; i3 < newTrain.numClasses(); ++i3) {
                if (!notEmptyClass[i3]) continue;
                oldIndexToNewIndex[i3] = newClassVals.size();
                newClassVals.addElement(newTrain.classAttribute().value(i3));
            }
            Attribute newClass = new Attribute(newTrain.classAttribute().name(), newClassVals);
            FastVector<Attribute> newAttributes = new FastVector<Attribute>(newTrain.numAttributes());
            for (int i4 = 0; i4 < newTrain.numAttributes(); ++i4) {
                if (i4 != newTrain.classIndex()) {
                    newAttributes.addElement((Attribute)newTrain.attribute(i4).copy());
                    continue;
                }
                newAttributes.addElement(newClass);
            }
            Instances newTrainTransformed = new Instances(newTrain.relationName(), newAttributes, newTrain.numInstances());
            newTrainTransformed.setClassIndex(newTrain.classIndex());
            for (int i5 = 0; i5 < newTrain.numInstances(); ++i5) {
                Instance inst = newTrain.instance(i5);
                newTrainTransformed.add(inst);
                newTrainTransformed.lastInstance().setClassValue(oldIndexToNewIndex[(int)inst.classValue()]);
            }
            newTrain = newTrainTransformed;
        }
        this.m_OriginalTargetValues = new double[instances.numInstances()];
        this.m_NewTargetValues = new int[instances.numInstances()];
        for (int i6 = 0; i6 < this.m_OriginalTargetValues.length; ++i6) {
            this.m_OriginalTargetValues[i6] = instances.instance(i6).classValue();
            this.m_NewTargetValues[i6] = (int)newTrain.instance(i6).classValue();
        }
        this.m_DiscretizedHeader = new Instances(newTrain, 0);
        int numClasses = newTrain.numClasses();
        this.m_ClassMeans = new double[numClasses];
        this.m_ClassCounts = new int[numClasses];
        for (i = 0; i < instances.numInstances(); ++i) {
            int classVal;
            Instance inst = newTrain.instance(i);
            if (inst.classIsMissing()) continue;
            int n = classVal = (int)inst.classValue();
            this.m_ClassCounts[n] = this.m_ClassCounts[n] + 1;
            int n2 = classVal;
            this.m_ClassMeans[n2] = this.m_ClassMeans[n2] + instances.instance(i).classValue();
        }
        for (i = 0; i < numClasses; ++i) {
            if (this.m_ClassCounts[i] <= 0) continue;
            int n = i;
            this.m_ClassMeans[n] = this.m_ClassMeans[n] / (double)this.m_ClassCounts[i];
        }
        if (this.m_Debug) {
            System.out.println("Bin Means");
            System.out.println("==========");
            for (i = 0; i < this.m_ClassMeans.length; ++i) {
                System.out.println(this.m_ClassMeans[i]);
            }
            System.out.println();
        }
        this.m_Classifier.buildClassifier(newTrain);
    }

    protected UnivariateDensityEstimator getDensityEstimator(Instance instance, boolean print) throws Exception {
        UnivariateIntervalEstimator e;
        if (this.m_estimatorType == 1) {
            e = new UnivariateKernelEstimator();
        } else if (this.m_estimatorType == 2) {
            e = new UnivariateNormalEstimator();
        } else {
            e = new UnivariateEqualFrequencyHistogramEstimator();
            ((UnivariateEqualFrequencyHistogramEstimator)e).setNumBins(this.getNumBins());
            for (int i = 0; i < this.m_OriginalTargetValues.length; ++i) {
                e.addValue(this.m_OriginalTargetValues[i], 1.0);
            }
            ((UnivariateEqualFrequencyHistogramEstimator)e).initializeStatistics();
            ((UnivariateEqualFrequencyHistogramEstimator)e).setUpdateWeightsOnly(true);
        }
        Instance newInstance = (Instance)instance.copy();
        newInstance.setDataset(this.m_DiscretizedHeader);
        double[] probs = this.m_Classifier.distributionForInstance(newInstance);
        for (int i = 0; i < this.m_OriginalTargetValues.length; ++i) {
            e.addValue(this.m_OriginalTargetValues[i], probs[this.m_NewTargetValues[i]] * (double)this.m_OriginalTargetValues.length / (double)this.m_ClassCounts[this.m_NewTargetValues[i]]);
        }
        return e;
    }

    public double[][] predictIntervals(Instance instance, double confidenceLevel) throws Exception {
        UnivariateIntervalEstimator e = (UnivariateIntervalEstimator)((Object)this.getDensityEstimator(instance, false));
        return e.predictIntervals(confidenceLevel);
    }

    public double logDensity(Instance instance, double value) throws Exception {
        UnivariateDensityEstimator e = this.getDensityEstimator(instance, true);
        return e.logDensity(value);
    }

    public double classifyInstance(Instance instance) throws Exception {
        Instance newInstance = (Instance)instance.copy();
        newInstance.setDataset(this.m_DiscretizedHeader);
        double[] probs = this.m_Classifier.distributionForInstance(newInstance);
        if (!this.m_MinimizeAbsoluteError) {
            double prediction = 0.0;
            double probSum = 0.0;
            for (int j = 0; j < probs.length; ++j) {
                prediction += probs[j] * this.m_ClassMeans[j];
                probSum += probs[j];
            }
            return prediction / probSum;
        }
        UnivariateQuantileEstimator e = (UnivariateQuantileEstimator)((Object)this.getDensityEstimator(instance, true));
        return e.predictQuantile(0.5);
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(5);
        newVector.addElement(new Option("\tNumber of bins for equal-width discretization\n\t(default 10).\n", "B", 1, "-B <int>"));
        newVector.addElement(new Option("\tWhether to delete empty bins after discretization\n\t(default false).\n", "E", 0, "-E"));
        newVector.addElement(new Option("\tWhether to minimize absolute error, rather than squared error.\n\t(default false).\n", "A", 0, "-A"));
        newVector.addElement(new Option("\tUse equal-frequency instead of equal-width discretization.", "F", 0, "-F"));
        newVector.addElement(new Option("\tWhat type of density estimator to use: 0=histogram/1=kernel/2=normal (default: 0).", "K", 1, "-K"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String binsString = Utils.getOption('B', options);
        if (binsString.length() != 0) {
            this.setNumBins(Integer.parseInt(binsString));
        } else {
            this.setNumBins(10);
        }
        this.setDeleteEmptyBins(Utils.getFlag('E', options));
        this.setUseEqualFrequency(Utils.getFlag('F', options));
        this.setMinimizeAbsoluteError(Utils.getFlag('A', options));
        String tmpStr = Utils.getOption('K', options);
        if (tmpStr.length() != 0) {
            this.setEstimatorType(new SelectedTag(Integer.parseInt(tmpStr), TAGS_ESTIMATOR));
        } else {
            this.setEstimatorType(new SelectedTag(0, TAGS_ESTIMATOR));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 7];
        int current = 0;
        options[current++] = "-B";
        options[current++] = "" + this.getNumBins();
        if (this.getDeleteEmptyBins()) {
            options[current++] = "-E";
        }
        if (this.getUseEqualFrequency()) {
            options[current++] = "-F";
        }
        if (this.getMinimizeAbsoluteError()) {
            options[current++] = "-A";
        }
        options[current++] = "-K";
        options[current++] = "" + this.m_estimatorType;
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        current += superOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String numBinsTipText() {
        return "Number of bins for discretization.";
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public void setNumBins(int numBins) {
        this.m_NumBins = numBins;
    }

    public String deleteEmptyBinsTipText() {
        return "Whether to delete empty bins after discretization.";
    }

    public boolean getDeleteEmptyBins() {
        return this.m_DeleteEmptyBins;
    }

    public void setDeleteEmptyBins(boolean b) {
        this.m_DeleteEmptyBins = b;
    }

    public String minimizeAbsoluteErrorTipText() {
        return "Whether to minimize absolute error.";
    }

    public boolean getMinimizeAbsoluteError() {
        return this.m_MinimizeAbsoluteError;
    }

    public void setMinimizeAbsoluteError(boolean b) {
        this.m_MinimizeAbsoluteError = b;
    }

    public String useEqualFrequencyTipText() {
        return "If set to true, equal-frequency binning will be used instead of equal-width binning.";
    }

    public boolean getUseEqualFrequency() {
        return this.m_UseEqualFrequency;
    }

    public void setUseEqualFrequency(boolean newUseEqualFrequency) {
        this.m_UseEqualFrequency = newUseEqualFrequency;
    }

    public String estimatorTypeTipText() {
        return "The density estimator to use.";
    }

    public SelectedTag getEstimatorType() {
        return new SelectedTag(this.m_estimatorType, TAGS_ESTIMATOR);
    }

    public void setEstimatorType(SelectedTag newEstimator) {
        if (newEstimator.getTags() == TAGS_ESTIMATOR) {
            this.m_estimatorType = newEstimator.getSelectedTag().getID();
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("Regression by discretization");
        if (this.m_ClassMeans == null) {
            text.append(": No model built yet.");
        } else {
            text.append("\n\nClass attribute discretized into " + this.m_ClassMeans.length + " values\n");
            text.append("\nClassifier spec: " + this.getClassifierSpec() + "\n");
            text.append(this.m_Classifier.toString());
        }
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6987 $");
    }

    public static void main(String[] argv) {
        RegressionByDiscretization.runClassifier(new RegressionByDiscretization(), argv);
    }
}

