/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class SMOset
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8364829283188675777L;
    private int m_number;
    private int m_first;
    private boolean[] m_indicators;
    private int[] m_next;
    private int[] m_previous;

    public SMOset(int size) {
        this.m_indicators = new boolean[size];
        this.m_next = new int[size];
        this.m_previous = new int[size];
        this.m_number = 0;
        this.m_first = -1;
    }

    public boolean contains(int index) {
        return this.m_indicators[index];
    }

    public void delete(int index) {
        if (this.m_indicators[index]) {
            if (this.m_first == index) {
                this.m_first = this.m_next[index];
            } else {
                this.m_next[this.m_previous[index]] = this.m_next[index];
            }
            if (this.m_next[index] != -1) {
                this.m_previous[this.m_next[index]] = this.m_previous[index];
            }
            this.m_indicators[index] = false;
            --this.m_number;
        }
    }

    public void insert(int index) {
        if (!this.m_indicators[index]) {
            if (this.m_number == 0) {
                this.m_first = index;
                this.m_next[index] = -1;
                this.m_previous[index] = -1;
            } else {
                this.m_previous[this.m_first] = index;
                this.m_next[index] = this.m_first;
                this.m_previous[index] = -1;
                this.m_first = index;
            }
            this.m_indicators[index] = true;
            ++this.m_number;
        }
    }

    public int getNext(int index) {
        if (index == -1) {
            return this.m_first;
        }
        return this.m_next[index];
    }

    public void printElements() {
        int i = this.getNext(-1);
        while (i != -1) {
            System.err.print(i + " ");
            i = this.getNext(i);
        }
        System.err.println();
        for (i = 0; i < this.m_indicators.length; ++i) {
            if (!this.m_indicators[i]) continue;
            System.err.print(i + " ");
        }
        System.err.println();
        System.err.println(this.m_number);
    }

    public int numElements() {
        return this.m_number;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

