/*
 * Decompiled with CFR 0.152.
 */
package weka.core.json;

import java.util.ArrayList;
import java.util.List;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.core.json.JSONNode;

public class JSONInstances {
    public static final String HEADER = "header";
    public static final String DATA = "data";
    public static final String RELATION = "relation";
    public static final String ATTRIBUTES = "attributes";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String CLASS = "class";
    public static final String LABELS = "labels";
    public static final String WEIGHT = "weight";
    public static final String DATEFORMAT = "dateformat";
    public static final String SPARSE = "sparse";
    public static final String VALUES = "values";
    public static final String SPARSE_SEPARATOR = ":";
    public static final String MISSING_VALUE = "?";

    protected static Attribute toAttribute(JSONNode att, boolean[] classAtt) {
        Attribute result;
        String name = (String)att.getChild(NAME).getValue("noname");
        String type = (String)att.getChild(TYPE).getValue("");
        double weight = (Double)att.getChild(WEIGHT).getValue(new Double(1.0));
        if (type.equals(Attribute.typeToString(0))) {
            result = new Attribute(name);
        } else if (type.equals(Attribute.typeToString(1))) {
            JSONNode labels = att.getChild(LABELS);
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < labels.getChildCount(); ++i) {
                String label = (String)((JSONNode)labels.getChildAt(i)).getValue();
                if (label.equals("'?'")) {
                    values.add(MISSING_VALUE);
                    continue;
                }
                values.add(label);
            }
            result = new Attribute(name, values);
        } else if (type.equals(Attribute.typeToString(3))) {
            String dateformat = (String)att.getChild(TYPE).getValue("yyyy-MM-dd'T'HH:mm:ss");
            result = new Attribute(name, dateformat);
        } else if (type.equals(Attribute.typeToString(2))) {
            result = new Attribute(name, (List<String>)null);
        } else {
            System.err.println("Unhandled attribute type '" + type + "'!");
            return null;
        }
        result.setWeight(weight);
        return result;
    }

    protected static Instance toInstance(JSONNode inst, Instances data) {
        boolean sparse = (Boolean)inst.getChild(SPARSE).getValue(new Boolean(false));
        double weight = (Double)inst.getChild(WEIGHT).getValue(new Double(1.0));
        JSONNode values = inst.getChild(VALUES);
        double[] vals = new double[data.numAttributes()];
        for (int i = 0; i < values.getChildCount(); ++i) {
            int index;
            String value;
            if (sparse) {
                value = "" + ((JSONNode)values.getChildAt(i)).getValue();
                int pos = value.indexOf(SPARSE_SEPARATOR);
                index = Integer.parseInt(value.substring(0, pos));
                value = value.substring(pos + 1);
            } else {
                index = i;
                value = "" + ((JSONNode)values.getChildAt(i)).getValue();
            }
            try {
                if (value.equals(MISSING_VALUE)) {
                    vals[index] = Utils.missingValue();
                    continue;
                }
                if (value.equals("'?'")) {
                    value = MISSING_VALUE;
                }
                if (data.attribute(index).isNumeric()) {
                    vals[index] = Double.parseDouble(value);
                    continue;
                }
                if (data.attribute(index).isNominal()) {
                    vals[index] = data.attribute(index).indexOfValue(value);
                    if (vals[index] == -1.0 && value.startsWith("'") && value.endsWith("'")) {
                        vals[index] = data.attribute(index).indexOfValue(Utils.unquote(value));
                    }
                    if (vals[index] == -1.0 && value.startsWith("'") && value.endsWith("'")) {
                        vals[index] = data.attribute(index).indexOfValue(Utils.unbackQuoteChars(Utils.unquote(value)));
                    }
                    if (vals[index] != -1.0) continue;
                    System.err.println("Unknown label '" + value + "' for attribute #" + (index + 1) + "!");
                    return null;
                }
                if (data.attribute(index).isDate()) {
                    vals[index] = data.attribute(index).parseDate(value);
                    continue;
                }
                if (data.attribute(index).isString()) {
                    vals[index] = data.attribute(index).addStringValue(value);
                    continue;
                }
                System.err.println("Unhandled attribute type '" + Attribute.typeToString(data.attribute(index).type()) + "'!");
                return null;
            }
            catch (Exception e) {
                System.err.println("Error parsing value #" + (index + 1) + ": " + e.toString());
                return null;
            }
        }
        AbstractInstance result = sparse ? new SparseInstance(weight, vals) : new DenseInstance(weight, vals);
        result.setDataset(data);
        return result;
    }

    protected static Instances toInstances(JSONNode json, boolean onlyHeader) {
        int i;
        JSONNode header = json.getChild(HEADER);
        if (header == null) {
            System.err.println("No 'header' section!");
            return null;
        }
        JSONNode data = json.getChild(DATA);
        if (data == null) {
            System.err.println("No 'data' section!");
            return null;
        }
        JSONNode attributes = header.getChild(ATTRIBUTES);
        if (attributes == null) {
            System.err.println("No 'attributes' array!");
            return null;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        boolean[] classAtt = new boolean[1];
        int classIndex = -1;
        for (i = 0; i < attributes.getChildCount(); ++i) {
            Attribute att = JSONInstances.toAttribute((JSONNode)attributes.getChildAt(i), classAtt);
            if (att == null) {
                System.err.println("Could not convert attribute #" + (i + 1) + "!");
                return null;
            }
            if (classAtt[0]) {
                classIndex = i;
            }
            atts.add(att);
        }
        Instances result = new Instances(header.getChild(RELATION).getValue("unknown").toString(), atts, onlyHeader ? 0 : data.getChildCount());
        result.setClassIndex(classIndex);
        if (!onlyHeader) {
            for (i = 0; i < data.getChildCount(); ++i) {
                Instance inst = JSONInstances.toInstance((JSONNode)data.getChildAt(i), result);
                if (inst == null) {
                    System.err.println("Could not convert instance #" + (i + 1) + "!");
                    return null;
                }
                result.add(inst);
            }
        }
        return result;
    }

    public static Instances toInstances(JSONNode json) {
        return JSONInstances.toInstances(json, false);
    }

    public static Instances toHeader(JSONNode json) {
        return JSONInstances.toInstances(json, true);
    }

    protected static JSONNode toJSON(Instances inst, Attribute att) {
        JSONNode result = new JSONNode();
        result.addPrimitive(NAME, att.name());
        result.addPrimitive(TYPE, Attribute.typeToString(att));
        result.addPrimitive(CLASS, att.index() == inst.classIndex());
        result.addPrimitive(WEIGHT, att.weight());
        if (att.isNominal()) {
            JSONNode labels = result.addArray(LABELS);
            for (int i = 0; i < att.numValues(); ++i) {
                if (att.value(i).equals(MISSING_VALUE)) {
                    labels.addArrayElement("'" + att.value(i) + "'");
                    continue;
                }
                labels.addArrayElement(att.value(i));
            }
        }
        if (att.isDate()) {
            result.addPrimitive(DATEFORMAT, att.getDateFormat());
        }
        return result;
    }

    protected static JSONNode toJSON(Instance inst) {
        JSONNode result = new JSONNode();
        boolean sparse = inst instanceof SparseInstance;
        result.addPrimitive(SPARSE, sparse);
        result.addPrimitive(WEIGHT, inst.weight());
        JSONNode values = result.addArray(VALUES);
        if (sparse) {
            for (int i = 0; i < inst.numValues(); ++i) {
                if (inst.isMissing(inst.index(i))) {
                    values.addArrayElement(inst.index(i) + SPARSE_SEPARATOR + MISSING_VALUE);
                    continue;
                }
                if (inst.toString(inst.index(i)).equals("'?'")) {
                    values.addArrayElement(inst.index(i) + SPARSE_SEPARATOR + "'" + MISSING_VALUE + "'");
                    continue;
                }
                values.addArrayElement(inst.index(i) + SPARSE_SEPARATOR + inst.toString(inst.index(i)));
            }
        } else {
            for (int i = 0; i < inst.numAttributes(); ++i) {
                if (inst.isMissing(i)) {
                    values.addArrayElement(MISSING_VALUE);
                    continue;
                }
                if (inst.toString(i).equals("'?'")) {
                    values.addArrayElement("'?'");
                    continue;
                }
                values.addArrayElement(inst.toString(i));
            }
        }
        return result;
    }

    public static JSONNode toJSON(Instances inst) {
        int i;
        JSONNode result = new JSONNode();
        JSONNode header = result.addObject(HEADER);
        header.addPrimitive(RELATION, inst.relationName());
        JSONNode atts = header.addArray(ATTRIBUTES);
        for (i = 0; i < inst.numAttributes(); ++i) {
            atts.add(JSONInstances.toJSON(inst, inst.attribute(i)));
        }
        JSONNode data = result.addArray(DATA);
        for (i = 0; i < inst.numInstances(); ++i) {
            data.add(JSONInstances.toJSON(inst.instance(i)));
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("No dataset supplied!");
            System.exit(1);
        }
        Instances data = ConverterUtils.DataSource.read(args[0]);
        JSONNode json = JSONInstances.toJSON(data);
        StringBuffer buffer = new StringBuffer();
        json.toString(buffer);
        System.out.println(buffer.toString());
        Instances inst = JSONInstances.toInstances(json);
        System.out.println(inst);
    }
}

