/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Ranker
extends ASSearch
implements RankedOutputSearch,
StartSetHandler,
OptionHandler {
    static final long serialVersionUID = -9086714848510751934L;
    private int[] m_starting;
    private Range m_startRange;
    private int[] m_attributeList;
    private double[] m_attributeMerit;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private double m_threshold;
    private int m_numToSelect = -1;
    private int m_calculatedNumToSelect = -1;

    public String globalInfo() {
        return "Ranker : \n\nRanks attributes by their individual evaluations. Use in conjunction with attribute evaluators (ReliefF, GainRatio, Entropy etc).\n";
    }

    public Ranker() {
        this.resetOptions();
    }

    public String numToSelectTipText() {
        return "Specify the number of attributes to retain. The default value (-1) indicates that all attributes are to be retained. Use either this option or a threshold to reduce the attribute set.";
    }

    @Override
    public void setNumToSelect(int n) {
        this.m_numToSelect = n;
    }

    @Override
    public int getNumToSelect() {
        return this.m_numToSelect;
    }

    @Override
    public int getCalculatedNumToSelect() {
        if (this.m_numToSelect >= 0) {
            this.m_calculatedNumToSelect = this.m_numToSelect > this.m_attributeMerit.length ? this.m_attributeMerit.length : this.m_numToSelect;
        }
        return this.m_calculatedNumToSelect;
    }

    public String thresholdTipText() {
        return "Set threshold by which attributes can be discarded. Default value results in no attributes being discarded. Use either this option or numToSelect to reduce the attribute set.";
    }

    @Override
    public void setThreshold(double threshold) {
        this.m_threshold = threshold;
    }

    @Override
    public double getThreshold() {
        return this.m_threshold;
    }

    public String generateRankingTipText() {
        return "A constant option. Ranker is only capable of generating  attribute rankings.";
    }

    @Override
    public void setGenerateRanking(boolean doRank) {
    }

    @Override
    public boolean getGenerateRanking() {
        return true;
    }

    public String startSetTipText() {
        return "Specify a set of attributes to ignore.  When generating the ranking, Ranker will not evaluate the attributes  in this list. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    @Override
    public void setStartSet(String startSet) throws Exception {
        this.m_startRange.setRanges(startSet);
    }

    @Override
    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.\n\tAny starting attributes specified are\n\tignored during the ranking.", "P", 1, "-P <start set>"));
        newVector.addElement(new Option("\tSpecify a theshold by which attributes\n\tmay be discarded from the ranking.", "T", 1, "-T <threshold>"));
        newVector.addElement(new Option("\tSpecify number of attributes to select", "N", 1, "-N <num to select>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('P', options);
        if (optionString.length() != 0) {
            this.setStartSet(optionString);
        }
        if ((optionString = Utils.getOption('T', options)).length() != 0) {
            Double temp = Double.valueOf(optionString);
            this.setThreshold(temp);
        }
        if ((optionString = Utils.getOption('N', options)).length() != 0) {
            this.setNumToSelect(Integer.parseInt(optionString));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (!this.getStartSet().equals("")) {
            options.add("-P");
            options.add("" + this.startSetToString());
        }
        options.add("-T");
        options.add("" + this.getThreshold());
        options.add("-N");
        options.add("" + this.getNumToSelect());
        return options.toArray(new String[0]);
    }

    private String startSetToString() {
        StringBuffer FString = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean didPrint = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                FString.append(this.m_starting[i] + 1);
                didPrint = true;
            }
            if (i == this.m_starting.length - 1) {
                FString.append("");
                continue;
            }
            if (!didPrint) continue;
            FString.append(",");
        }
        return FString.toString();
    }

    @Override
    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        int i;
        if (!(ASEval instanceof AttributeEvaluator)) {
            throw new Exception(ASEval.getClass().getName() + " is not aAttribute evaluator!");
        }
        this.m_numAttribs = data.numAttributes();
        if (ASEval instanceof UnsupervisedAttributeEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_classIndex = data.classIndex();
            this.m_hasClass = this.m_classIndex >= 0;
        }
        if (ASEval instanceof AttributeTransformer) {
            data = ((AttributeTransformer)((Object)ASEval)).transformedHeader();
            if (this.m_classIndex >= 0 && data.classIndex() >= 0) {
                this.m_classIndex = data.classIndex();
                this.m_hasClass = true;
            }
        }
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        int sl = 0;
        if (this.m_starting != null) {
            sl = this.m_starting.length;
        }
        if (this.m_starting != null && this.m_hasClass) {
            boolean ok = false;
            for (i = 0; i < sl; ++i) {
                if (this.m_starting[i] != this.m_classIndex) continue;
                ok = true;
                break;
            }
            if (!ok) {
                ++sl;
            }
        } else if (this.m_hasClass) {
            ++sl;
        }
        this.m_attributeList = new int[this.m_numAttribs - sl];
        this.m_attributeMerit = new double[this.m_numAttribs - sl];
        int j = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (this.inStarting(i)) continue;
            this.m_attributeList[j++] = i;
        }
        AttributeEvaluator ASEvaluator2 = (AttributeEvaluator)((Object)ASEval);
        for (i = 0; i < this.m_attributeList.length; ++i) {
            this.m_attributeMerit[i] = ASEvaluator2.evaluateAttribute(this.m_attributeList[i]);
        }
        double[][] tempRanked = this.rankedAttributes();
        int[] rankedAttributes = new int[this.m_attributeList.length];
        for (i = 0; i < this.m_attributeList.length; ++i) {
            rankedAttributes[i] = (int)tempRanked[i][0];
        }
        return rankedAttributes;
    }

    @Override
    public double[][] rankedAttributes() throws Exception {
        int i;
        if (this.m_attributeList == null || this.m_attributeMerit == null) {
            throw new Exception("Search must be performed before a ranked attribute list can be obtained");
        }
        int[] ranked = Utils.sort(this.m_attributeMerit);
        double[][] bestToWorst = new double[ranked.length][2];
        int j = 0;
        for (i = ranked.length - 1; i >= 0; --i) {
            bestToWorst[j++][0] = ranked[i];
        }
        for (i = 0; i < bestToWorst.length; ++i) {
            int temp = (int)bestToWorst[i][0];
            bestToWorst[i][0] = this.m_attributeList[temp];
            bestToWorst[i][1] = this.m_attributeMerit[temp];
        }
        if (this.m_numToSelect <= 0) {
            if (this.m_threshold == -1.7976931348623157E308) {
                this.m_calculatedNumToSelect = bestToWorst.length;
            } else {
                this.determineNumToSelectFromThreshold(bestToWorst);
            }
        }
        return bestToWorst;
    }

    private void determineNumToSelectFromThreshold(double[][] ranking) {
        int count = 0;
        for (double[] element : ranking) {
            if (!(element[1] > this.m_threshold)) continue;
            ++count;
        }
        this.m_calculatedNumToSelect = count;
    }

    public String toString() {
        StringBuffer BfString = new StringBuffer();
        BfString.append("\tAttribute ranking.\n");
        if (this.m_starting != null) {
            BfString.append("\tIgnored attributes: ");
            BfString.append(this.startSetToString());
            BfString.append("\n");
        }
        if (this.m_threshold != -1.7976931348623157E308) {
            BfString.append("\tThreshold for discarding attributes: " + Utils.doubleToString(this.m_threshold, 8, 4) + "\n");
        }
        return BfString.toString();
    }

    protected void resetOptions() {
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_attributeList = null;
        this.m_attributeMerit = null;
        this.m_threshold = -1.7976931348623157E308;
    }

    private boolean inStarting(int feat) {
        if (this.m_hasClass && feat == this.m_classIndex) {
            return true;
        }
        if (this.m_starting == null) {
            return false;
        }
        for (int element : this.m_starting) {
            if (element != feat) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11213 $");
    }
}

