/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;
import weka.gui.ComponentHelper;

public class ArffTableModel
extends DefaultTableModel
implements Undoable {
    private static final long serialVersionUID = 3411795562305994946L;
    protected HashSet<TableModelListener> m_Listeners = new HashSet();
    protected Instances m_Data = null;
    protected boolean m_NotificationEnabled = true;
    protected boolean m_UndoEnabled = true;
    protected boolean m_IgnoreChanges = false;
    protected Vector<File> m_UndoList = new Vector();
    protected boolean m_ReadOnly = false;
    protected boolean m_ShowAttributeIndex = false;
    protected boolean m_ShowAttributeWeights = false;
    protected boolean m_ShowInstanceWeights = false;
    protected Hashtable<String, String> m_Cache = new Hashtable();

    private ArffTableModel() {
    }

    public ArffTableModel(String filename, AbstractFileLoader ... loaders) {
        this();
        if (filename != null && !filename.equals("")) {
            this.loadFile(filename, loaders);
        }
    }

    public ArffTableModel(Instances data) {
        this();
        int i;
        this.m_Data = data;
        for (i = 0; i < data.numAttributes(); ++i) {
            if (data.attribute(i).weight() == 1.0) continue;
            this.m_ShowAttributeWeights = true;
            break;
        }
        for (i = 0; i < data.numInstances(); ++i) {
            if (data.instance(i).weight() == 1.0) continue;
            this.m_ShowInstanceWeights = true;
            break;
        }
    }

    public boolean isNotificationEnabled() {
        return this.m_NotificationEnabled;
    }

    public void setNotificationEnabled(boolean enabled) {
        this.m_NotificationEnabled = enabled;
    }

    @Override
    public boolean isUndoEnabled() {
        return this.m_UndoEnabled;
    }

    @Override
    public void setUndoEnabled(boolean enabled) {
        this.m_UndoEnabled = enabled;
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    public void setReadOnly(boolean value) {
        this.m_ReadOnly = value;
    }

    protected void loadFile(String filename, AbstractFileLoader ... loaders) {
        AbstractFileLoader loader = loaders == null || loaders.length == 0 ? ConverterUtils.getLoaderForFile(filename) : loaders[0];
        if (loader != null) {
            try {
                loader.setFile(new File(filename));
                this.setInstances(loader.getDataSet());
            }
            catch (Exception e) {
                ComponentHelper.showMessageBox(null, "Error loading file...", e.toString(), 2, 0);
                System.out.println(e);
                this.setInstances(null);
            }
        }
    }

    public void setInstances(Instances data) {
        int i;
        this.m_Data = data;
        this.m_ShowAttributeWeights = false;
        for (i = 0; i < data.numAttributes(); ++i) {
            if (data.attribute(i).weight() == 1.0) continue;
            this.m_ShowAttributeWeights = true;
            break;
        }
        this.m_ShowInstanceWeights = false;
        for (i = 0; i < data.numInstances(); ++i) {
            if (data.instance(i).weight() == 1.0) continue;
            this.m_ShowInstanceWeights = true;
            break;
        }
        this.m_Cache.clear();
        this.fireTableDataChanged();
    }

    public Instances getInstances() {
        return this.m_Data;
    }

    public int getAttributeIndex(int columnIndex) {
        if (this.m_ShowInstanceWeights) {
            return columnIndex - 2;
        }
        return columnIndex - 1;
    }

    public boolean isAttribute(int columnIndex) {
        if (this.m_ShowInstanceWeights) {
            return columnIndex > 1 && columnIndex < this.getColumnCount();
        }
        return columnIndex > 0 && columnIndex < this.getColumnCount();
    }

    public Attribute getAttributeAt(int columnIndex) {
        if (this.isAttribute(columnIndex)) {
            return this.m_Data.attribute(this.getAttributeIndex(columnIndex));
        }
        return null;
    }

    public int getType(int columnIndex) {
        return this.getType(-1, columnIndex);
    }

    public int getType(int rowIndex, int columnIndex) {
        int result = 2;
        if (rowIndex < 0 && this.isAttribute(columnIndex)) {
            result = this.m_Data.attribute(this.getAttributeIndex(columnIndex)).type();
        } else if (rowIndex >= 0 && rowIndex < this.getRowCount() && this.isAttribute(columnIndex)) {
            result = this.m_Data.instance(rowIndex).attribute(this.getAttributeIndex(columnIndex)).type();
        }
        return result;
    }

    public void deleteAttributeAt(int columnIndex) {
        this.deleteAttributeAt(columnIndex, true);
    }

    public void deleteAttributeAt(int columnIndex, boolean notify) {
        if (this.isAttribute(columnIndex)) {
            if (!this.m_IgnoreChanges) {
                this.addUndoPoint();
            }
            this.m_Data.deleteAttributeAt(this.getAttributeIndex(columnIndex));
            if (notify) {
                this.notifyListener(new TableModelEvent(this, -1));
            }
        }
    }

    public void deleteAttributes(int[] columnIndices) {
        Arrays.sort(columnIndices);
        this.addUndoPoint();
        this.m_IgnoreChanges = true;
        for (int i = columnIndices.length - 1; i >= 0; --i) {
            this.deleteAttributeAt(columnIndices[i], false);
        }
        this.m_IgnoreChanges = false;
        this.notifyListener(new TableModelEvent(this, -1));
    }

    public void renameAttributeAt(int columnIndex, String newName) {
        if (this.isAttribute(columnIndex)) {
            this.addUndoPoint();
            this.m_Data.renameAttribute(this.getAttributeIndex(columnIndex), newName);
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void setAttributeWeightAt(int columnIndex, double weight) {
        if (this.isAttribute(columnIndex)) {
            this.addUndoPoint();
            this.m_Data.setAttributeWeight(this.getAttributeIndex(columnIndex), weight);
            if (weight != 1.0) {
                this.m_ShowAttributeWeights = true;
            } else {
                this.m_ShowAttributeWeights = false;
                for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
                    if (this.m_Data.attribute(i).weight() == 1.0) continue;
                    this.m_ShowAttributeWeights = true;
                    break;
                }
            }
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void attributeAsClassAt(int columnIndex) {
        if (this.isAttribute(columnIndex)) {
            this.addUndoPoint();
            try {
                String order = "";
                for (int i = 1; i < this.m_Data.numAttributes() + 1; ++i) {
                    if (i - 1 == this.getAttributeIndex(columnIndex)) continue;
                    if (!order.equals("")) {
                        order = order + ",";
                    }
                    order = order + Integer.toString(i);
                }
                if (!order.equals("")) {
                    order = order + ",";
                }
                order = order + Integer.toString(this.getAttributeIndex(columnIndex) + 1);
                Reorder reorder = new Reorder();
                reorder.setAttributeIndices(order);
                reorder.setInputFormat(this.m_Data);
                this.m_Data = Filter.useFilter(this.m_Data, reorder);
                this.m_Data.setClassIndex(this.m_Data.numAttributes() - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.undo();
            }
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void deleteInstanceAt(int rowIndex) {
        this.deleteInstanceAt(rowIndex, true);
    }

    public void deleteInstanceAt(int rowIndex, boolean notify) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            if (!this.m_IgnoreChanges) {
                this.addUndoPoint();
            }
            this.m_Data.delete(rowIndex);
            if (notify) {
                this.notifyListener(new TableModelEvent(this, rowIndex, rowIndex, -1, -1));
            }
        }
    }

    public void setInstanceWeight(int index, double weight) {
        this.setInstanceWeight(index, weight, true);
    }

    public void setInstanceWeight(int index, double weight, boolean notify) {
        if (!this.m_IgnoreChanges) {
            this.addUndoPoint();
        }
        this.m_Data.instance(index).setWeight(weight);
        if (notify) {
            if (this.m_ShowInstanceWeights) {
                this.notifyListener(new TableModelEvent(this, index, 1));
            } else if (weight != 1.0) {
                this.m_ShowInstanceWeights = true;
                this.notifyListener(new TableModelEvent(this, -1));
            }
        }
    }

    public void insertInstance(int index) {
        this.insertInstance(index, true);
    }

    public void insertInstance(int index, boolean notify) {
        if (!this.m_IgnoreChanges) {
            this.addUndoPoint();
        }
        double[] vals = new double[this.m_Data.numAttributes()];
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            if (!this.m_Data.attribute(i).isString() && !this.m_Data.attribute(i).isRelationValued()) continue;
            vals[i] = Utils.missingValue();
        }
        DenseInstance toAdd = new DenseInstance(1.0, vals);
        if (index < 0) {
            this.m_Data.add(toAdd);
        } else {
            this.m_Data.add(index, toAdd);
        }
        if (notify) {
            this.notifyListener(new TableModelEvent(this, this.m_Data.numInstances() - 1, this.m_Data.numInstances() - 1, -1, 1));
        }
    }

    public void deleteInstances(int[] rowIndices) {
        Arrays.sort(rowIndices);
        this.addUndoPoint();
        this.m_IgnoreChanges = true;
        for (int i = rowIndices.length - 1; i >= 0; --i) {
            this.deleteInstanceAt(rowIndices[i], false);
        }
        this.m_IgnoreChanges = false;
        this.notifyListener(new TableModelEvent(this, rowIndices[0], rowIndices[rowIndices.length - 1], -1, -1));
    }

    public void sortInstances(int columnIndex) {
        this.sortInstances(columnIndex, false);
    }

    public void sortInstances(int columnIndex, boolean ascending) {
        if (this.isAttribute(columnIndex) || this.m_ShowInstanceWeights && columnIndex == 1) {
            this.addUndoPoint();
            double[] vals = new double[this.m_Data.numInstances()];
            Instance[] backup = new Instance[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                Instance inst;
                backup[i] = inst = this.m_Data.instance(i);
                vals[i] = this.isAttribute(columnIndex) ? inst.value(this.getAttributeIndex(columnIndex)) : inst.weight();
            }
            int[] sortOrder = Utils.stableSort(vals);
            for (int i = 0; i < vals.length; ++i) {
                this.m_Data.set(i, backup[sortOrder[i]]);
            }
            if (!ascending) {
                Instances reversedData = new Instances(this.m_Data, this.m_Data.numInstances());
                int i = this.m_Data.numInstances();
                while (i > 0) {
                    --i;
                    int equalCount = 1;
                    if (this.isAttribute(columnIndex)) {
                        while (i > 0 && this.m_Data.instance(i).value(this.getAttributeIndex(columnIndex)) == this.m_Data.instance(i - 1).value(this.getAttributeIndex(columnIndex))) {
                            ++equalCount;
                            --i;
                        }
                    } else {
                        while (i > 0 && this.m_Data.instance(i).weight() == this.m_Data.instance(i - 1).weight()) {
                            ++equalCount;
                            --i;
                        }
                    }
                    for (int j = 0; j < equalCount; ++j) {
                        reversedData.add(this.m_Data.instance(i + j));
                    }
                }
                this.m_Data = reversedData;
            }
            this.notifyListener(new TableModelEvent(this));
        }
    }

    public int getAttributeColumn(String name) {
        int result = -1;
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            if (!this.m_Data.attribute(i).name().equals(name)) continue;
            result = i + (this.m_ShowInstanceWeights ? 2 : 1);
            break;
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? Integer.class : (this.getType(columnIndex) == 0 || this.m_ShowInstanceWeights && columnIndex == 1 ? Double.class : String.class);
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 1;
        if (this.m_ShowInstanceWeights) {
            ++result;
        }
        if (this.m_Data != null) {
            result += this.m_Data.numAttributes();
        }
        return result;
    }

    protected boolean isClassIndex(int columnIndex) {
        int index = this.m_Data.classIndex();
        boolean result = index == -1 && this.m_Data.numAttributes() - 1 == this.getAttributeIndex(columnIndex) || index == this.getAttributeIndex(columnIndex);
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result = "";
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            if (columnIndex == 0) {
                result = "<html><center>No.<br><font size=\"-2\">&nbsp;";
                if (this.m_ShowAttributeWeights) {
                    result = result + "</font><br><font size=\"-2\">&nbsp;</font>";
                }
                result = result + "</center></html>";
            } else if (columnIndex == 1 && this.m_ShowInstanceWeights) {
                result = "<html><center>Weight<br><font size=\"-2\">&nbsp;";
                if (this.m_ShowAttributeWeights) {
                    result = result + "</font><br><font size=\"-2\">&nbsp;</font>";
                }
                result = result + "</center></html>";
            } else if (this.m_Data != null && this.getAttributeIndex(columnIndex) < this.m_Data.numAttributes()) {
                result = "<html><center>";
                if (this.m_ShowAttributeIndex) {
                    result = result + (this.m_ShowInstanceWeights ? columnIndex - 1 : columnIndex) + ": ";
                }
                result = this.isClassIndex(columnIndex) ? result + "<b>" + this.m_Data.attribute(this.getAttributeIndex(columnIndex)).name() + "</b>" : result + this.m_Data.attribute(this.getAttributeIndex(columnIndex)).name();
                switch (this.getType(columnIndex)) {
                    case 3: {
                        result = result + "<br><font size=\"-2\">Date</font>";
                        break;
                    }
                    case 1: {
                        result = result + "<br><font size=\"-2\">Nominal</font>";
                        break;
                    }
                    case 2: {
                        result = result + "<br><font size=\"-2\">String</font>";
                        break;
                    }
                    case 0: {
                        result = result + "<br><font size=\"-2\">Numeric</font>";
                        break;
                    }
                    case 4: {
                        result = result + "<br><font size=\"-2\">Relational</font>";
                        break;
                    }
                    default: {
                        result = result + "<br><font size=\"-2\">???</font>";
                    }
                }
                if (this.m_ShowAttributeWeights) {
                    result = result + "<br><font size=\"-2\">Weight : " + Utils.doubleToString(this.m_Data.attribute(this.getAttributeIndex(columnIndex)).weight(), 3) + "</font>";
                }
                result = result + "</center></html>";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.numInstances();
    }

    public boolean isMissingAt(int rowIndex, int columnIndex) {
        boolean result = false;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && this.isAttribute(columnIndex)) {
            result = this.m_Data.instance(rowIndex).isMissing(this.getAttributeIndex(columnIndex));
        }
        return result;
    }

    public double getInstancesValueAt(int rowIndex, int columnIndex) {
        double result = -1.0;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && this.isAttribute(columnIndex)) {
            result = this.m_Data.instance(rowIndex).value(this.getAttributeIndex(columnIndex));
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        String key = rowIndex + "-" + columnIndex;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            if (columnIndex == 0) {
                result = new Integer(rowIndex + 1);
            } else if (columnIndex == 1 && this.m_ShowInstanceWeights) {
                result = new Double(this.m_Data.instance(rowIndex).weight());
            } else if (this.isMissingAt(rowIndex, columnIndex)) {
                result = null;
            } else if (this.m_Cache.containsKey(key)) {
                result = this.m_Cache.get(key);
            } else {
                switch (this.getType(columnIndex)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        result = this.m_Data.instance(rowIndex).stringValue(this.getAttributeIndex(columnIndex));
                        break;
                    }
                    case 0: {
                        result = new Double(this.m_Data.instance(rowIndex).value(this.getAttributeIndex(columnIndex)));
                        break;
                    }
                    default: {
                        result = "-can't display-";
                    }
                }
                if (this.getType(columnIndex) != 0 && result != null) {
                    String tmp = result.toString();
                    boolean modified = false;
                    if (tmp.indexOf(60) > -1 || tmp.indexOf(62) > -1) {
                        tmp = tmp.replace("<", "(");
                        tmp = tmp.replace(">", ")");
                        modified = true;
                    }
                    if (tmp.indexOf("\n") > -1 || tmp.indexOf("\r") > -1) {
                        tmp = tmp.replaceAll("\\r\\n", "<font color=\"red\"><b>\\\\r\\\\n</b></font>");
                        tmp = tmp.replaceAll("\\r", "<font color=\"red\"><b>\\\\r</b></font>");
                        tmp = tmp.replaceAll("\\n", "<font color=\"red\"><b>\\\\n</b></font>");
                        tmp = "<html>" + tmp + "</html>";
                        modified = true;
                    }
                    result = tmp;
                    if (modified) {
                        this.m_Cache.put(key, tmp);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return (this.m_ShowInstanceWeights && columnIndex == 1 || this.isAttribute(columnIndex)) && !this.isReadOnly();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(aValue, rowIndex, columnIndex, true);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, boolean notify) {
        if (!this.m_IgnoreChanges) {
            this.addUndoPoint();
        }
        if (this.m_ShowInstanceWeights && columnIndex == 1) {
            double oldWeight = this.m_Data.instance(rowIndex).weight();
            try {
                double newWeight = Double.parseDouble(aValue.toString());
                if (oldWeight == newWeight) {
                    return;
                }
                this.m_Data.instance(rowIndex).setWeight(newWeight);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (notify) {
                this.notifyListener(new TableModelEvent(this, rowIndex, columnIndex));
            }
            return;
        }
        Object oldValue = this.getValueAt(rowIndex, columnIndex);
        int type = this.getType(rowIndex, columnIndex);
        int index = this.getAttributeIndex(columnIndex);
        Instance inst = this.m_Data.instance(rowIndex);
        Attribute att = inst.attribute(index);
        if (aValue == null) {
            inst.setValue(index, Utils.missingValue());
        } else {
            String tmp = aValue.toString();
            switch (type) {
                case 3: {
                    try {
                        att.parseDate(tmp);
                        inst.setValue(index, att.parseDate(tmp));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    if (att.indexOfValue(tmp) <= -1) break;
                    inst.setValue(index, (double)att.indexOfValue(tmp));
                    break;
                }
                case 2: {
                    inst.setValue(index, tmp);
                    break;
                }
                case 0: {
                    try {
                        Double.parseDouble(tmp);
                        inst.setValue(index, Double.parseDouble(tmp));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 4: {
                    try {
                        inst.setValue(index, (double)inst.attribute(index).addRelation((Instances)aValue));
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Attribute type: " + type + "!");
                }
            }
        }
        if (notify && !("" + oldValue).equals("" + aValue)) {
            this.notifyListener(new TableModelEvent(this, rowIndex, columnIndex));
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.m_Listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.m_Listeners.remove(l);
    }

    public void notifyListener(TableModelEvent e) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        for (TableModelListener l : this.m_Listeners) {
            l.tableChanged(e);
        }
    }

    @Override
    public void clearUndo() {
        this.m_UndoList = new Vector();
    }

    @Override
    public boolean canUndo() {
        return !this.m_UndoList.isEmpty();
    }

    @Override
    public void undo() {
        if (this.canUndo()) {
            File tempFile = this.m_UndoList.get(this.m_UndoList.size() - 1);
            try {
                ObjectInputStream ooi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(tempFile)));
                Instances inst = (Instances)ooi.readObject();
                ooi.close();
                this.setInstances(inst);
                this.notifyListener(new TableModelEvent(this, -1));
                this.notifyListener(new TableModelEvent(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempFile.delete();
            this.m_UndoList.remove(this.m_UndoList.size() - 1);
        }
    }

    @Override
    public void addUndoPoint() {
        if (!this.isUndoEnabled()) {
            return;
        }
        if (this.getInstances() != null) {
            try {
                File tempFile = File.createTempFile("arffviewer", null);
                tempFile.deleteOnExit();
                ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
                oos.writeObject(this.getInstances());
                oos.flush();
                oos.close();
                this.m_UndoList.add(tempFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setShowAttributeIndex(boolean value) {
        this.m_ShowAttributeIndex = value;
        this.fireTableStructureChanged();
    }

    public boolean getShowAttributeIndex() {
        return this.m_ShowAttributeIndex;
    }
}

