/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Settings;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.knowledgeflow.steps.TextViewer;

public class TextViewerInteractiveView
extends BaseInteractiveViewer
implements TextViewer.TextNotificationListener {
    private static final long serialVersionUID = -3164518320257969282L;
    protected JButton m_clearButton = new JButton("Clear results");
    protected ResultHistoryPanel m_history;
    protected JTextArea m_outText;
    protected JScrollPane m_textScroller;

    @Override
    public void init() {
        this.addButton(this.m_clearButton);
        this.m_outText = new JTextArea(20, 80);
        this.m_outText.setEditable(false);
        this.m_outText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_history = new ResultHistoryPanel(this.m_outText);
        this.m_history.setBorder(BorderFactory.createTitledBorder("Result list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.setDeleteListener(new ResultHistoryPanel.RDeleteListener(){

            @Override
            public void entryDeleted(String name, int index) {
                ((TextViewer)TextViewerInteractiveView.this.getStep()).getResults().remove(name);
            }

            @Override
            public void entriesDeleted(List<String> names, List<Integer> indexes) {
                for (String name : names) {
                    ((TextViewer)TextViewerInteractiveView.this.getStep()).getResults().remove(name);
                }
            }
        });
        this.m_history.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = TextViewerInteractiveView.this.m_history.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = TextViewerInteractiveView.this.m_history.getNameAtIndex(index);
                        TextViewerInteractiveView.this.visualize(name, e.getX(), e.getY());
                    } else {
                        TextViewerInteractiveView.this.visualize(null, e.getX(), e.getY());
                    }
                }
            }
        });
        this.m_textScroller = new JScrollPane(this.m_outText);
        this.m_textScroller.setBorder(BorderFactory.createTitledBorder("Text"));
        JSplitPane p2 = new JSplitPane(1, this.m_history, this.m_textScroller);
        this.add((Component)p2, "Center");
        Map<String, String> runResults = ((TextViewer)this.getStep()).getResults();
        if (runResults.size() > 0) {
            boolean first = true;
            String firstKey = "";
            for (Map.Entry<String, String> e : runResults.entrySet()) {
                if (first) {
                    firstKey = e.getKey();
                    first = false;
                }
                this.m_history.addResult(e.getKey(), new StringBuffer().append(e.getValue()));
            }
            this.m_history.setSingle(firstKey);
        }
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextViewerInteractiveView.this.m_history.clearResults();
                ((TextViewer)TextViewerInteractiveView.this.getStep()).getResults().clear();
                TextViewerInteractiveView.this.m_outText.setText("");
            }
        });
        this.applySettings(this.getSettings());
        ((TextViewer)this.getStep()).setTextNotificationListener(this);
    }

    @Override
    public void closePressed() {
        ((TextViewer)this.getStep()).removeTextNotificationListener(this);
    }

    @Override
    public void applySettings(Settings settings) {
        this.m_outText.setFont(settings.getSetting("weka.gui.knowledgeflow.steps.textviewer", TextViewerInteractiveViewDefaults.OUTPUT_FONT_KEY, TextViewerInteractiveViewDefaults.OUTPUT_FONT, Environment.getSystemWide()));
        this.m_history.setFont(settings.getSetting("weka.gui.knowledgeflow.steps.textviewer", TextViewerInteractiveViewDefaults.OUTPUT_FONT_KEY, TextViewerInteractiveViewDefaults.OUTPUT_FONT, Environment.getSystemWide()));
        this.m_outText.setForeground(settings.getSetting("weka.gui.knowledgeflow.steps.textviewer", TextViewerInteractiveViewDefaults.OUTPUT_TEXT_COLOR_KEY, TextViewerInteractiveViewDefaults.OUTPUT_TEXT_COLOR, Environment.getSystemWide()));
        this.m_outText.setBackground(settings.getSetting("weka.gui.knowledgeflow.steps.textviewer", TextViewerInteractiveViewDefaults.OUTPUT_BACKGROUND_COLOR_KEY, TextViewerInteractiveViewDefaults.OUTPUT_BACKGROUND_COLOR, Environment.getSystemWide()));
        this.m_textScroller.setBackground(settings.getSetting("weka.gui.knowledgeflow.steps.textviewer", TextViewerInteractiveViewDefaults.OUTPUT_BACKGROUND_COLOR_KEY, TextViewerInteractiveViewDefaults.OUTPUT_BACKGROUND_COLOR, Environment.getSystemWide()));
        this.m_outText.setRows(settings.getSetting("weka.gui.knowledgeflow.steps.textviewer", TextViewerInteractiveViewDefaults.NUM_ROWS_KEY, Integer.valueOf(20), Environment.getSystemWide()));
        this.m_outText.setColumns(settings.getSetting("weka.gui.knowledgeflow.steps.textviewer", TextViewerInteractiveViewDefaults.NUM_COLUMNS_KEY, Integer.valueOf(80), Environment.getSystemWide()));
        this.m_history.setBackground(settings.getSetting("weka.gui.knowledgeflow.steps.textviewer", TextViewerInteractiveViewDefaults.OUTPUT_BACKGROUND_COLOR_KEY, TextViewerInteractiveViewDefaults.OUTPUT_BACKGROUND_COLOR, Environment.getSystemWide()));
    }

    @Override
    public String getViewerName() {
        return "Text Viewer";
    }

    protected void visualize(String name, int x, int y) {
        final TextViewerInteractiveView panel = this;
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem visMainBuffer = new JMenuItem("View in main window");
        if (selectedName != null) {
            visMainBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextViewerInteractiveView.this.m_history.setSingle(selectedName);
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        JMenuItem visSepBuffer = new JMenuItem("View in separate window");
        if (selectedName != null) {
            visSepBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextViewerInteractiveView.this.m_history.openFrame(selectedName);
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaveBuffer saveOut = new SaveBuffer(null, panel);
                    StringBuffer sb = TextViewerInteractiveView.this.m_history.getNamedBuffer(selectedName);
                    if (sb != null) {
                        saveOut.save(sb);
                    }
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer");
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextViewerInteractiveView.this.m_history.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        resultListMenu.show(this.m_history.getList(), x, y);
    }

    @Override
    public Defaults getDefaultSettings() {
        return new TextViewerInteractiveViewDefaults();
    }

    @Override
    public void acceptTextResult(String name, String text) {
        this.m_history.addResult(name, new StringBuffer().append(text));
        this.m_history.setSingle(name);
    }

    protected static final class TextViewerInteractiveViewDefaults
    extends Defaults {
        public static final String ID = "weka.gui.knowledgeflow.steps.textviewer";
        protected static final Settings.SettingKey OUTPUT_FONT_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.steps.textviewer.outputFont", "Font for text output", "Font to use in the output area");
        protected static final Font OUTPUT_FONT = new Font("Monospaced", 0, 12);
        protected static final Settings.SettingKey OUTPUT_TEXT_COLOR_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.steps.textviewer.outputFontColor", "Output text color", "Color of output text");
        protected static final Color OUTPUT_TEXT_COLOR = Color.black;
        protected static final Settings.SettingKey OUTPUT_BACKGROUND_COLOR_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.steps.textviewer.outputBackgroundColor", "Output background color", "Output background color");
        protected static final Color OUTPUT_BACKGROUND_COLOR = Color.white;
        protected static final Settings.SettingKey NUM_COLUMNS_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.steps.textviewer.numColumns", "Number of columns of text", "Number of columns of text");
        protected static final int NUM_COLUMNS = 80;
        protected static final Settings.SettingKey NUM_ROWS_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.steps.textviewer.numRows", "Number of rows of text", "Number of rows of text");
        protected static final int NUM_ROWS = 20;
        private static final long serialVersionUID = 8361658568822013306L;

        public TextViewerInteractiveViewDefaults() {
            super(ID);
            this.m_defaults.put(OUTPUT_FONT_KEY, OUTPUT_FONT);
            this.m_defaults.put(OUTPUT_TEXT_COLOR_KEY, OUTPUT_TEXT_COLOR);
            this.m_defaults.put(OUTPUT_BACKGROUND_COLOR_KEY, OUTPUT_BACKGROUND_COLOR);
            this.m_defaults.put(NUM_COLUMNS_KEY, 80);
            this.m_defaults.put(NUM_ROWS_KEY, 20);
        }
    }
}

