% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markedData.R
\name{markedData}
\alias{markedData}
\title{Format Wildbook data for mark-recaputure analysis}
\usage{
markedData(data, varname_of_capturetime = "dateInMilliseconds",
  varlist = c("individualID"), start.dates, end.dates = NULL,
  date_format = "\%Y-\%m-\%d", origin = "1970-01-01", removeZeros = TRUE)
}
\arguments{
\item{data}{The raw data set from \code{searchWB} function in \code{RWildbook} package.}

\item{varname_of_capturetime}{A character object which is the variable name for capture/encounter sighted time.}

\item{varlist}{A character vector of the names of variables for mark-recapture analysis.}

\item{start.dates}{A character vector of dates which are the start dates of the capture occasions.
The elements should be in the form of date_format.}

\item{end.dates}{A character vector of dates which are the end dates of the capture occasions.
The elements should be in the form of date_format.}

\item{date_format}{The format for all the arguments of date value.}

\item{origin}{A point of time which set to be zero in millisecond.}

\item{removeZeros}{If TRUE (default) then individuals with no captures are removed from the data.}
}
\description{
Format data from \code{searchWB} function in \code{RWildbook} package for
mark-recapture analysis with \code{marked} and \code{RMark} packages.
}
\details{
The \code{markedData} function format the wildbook data set that users search with
the \code{searchWB} fucntion for the mark-recapture analysis with \code{mark} and
\code{RMark} package. In \code{marked} package, users can process a certain form of
data set with \code{process.data} function in \code{marked} package. The \code{markedData}
function reutrns data set which can be the input data set of \code{process.data}.

\strong{Defalut NULL value for end.dates argument}

The default value for \code{end.date} argument are NULL which means the capture occasion intervals
are divided by the elements of \code{start.date} argument. In this case, the end date of the last
capture occasion is the value of \code{Sys.Date()}.

\strong{The class of output}
The class of the ouput of \code{markedData} is "data.table" and "data.frame". With installing
the \code{data.table} package, the ouput is a data.table, otherwise it is a data.frame. That means
users can process the data with \code{data.table} package. Also users can directly process the output
with \code{process.data} function in \code{marked} package.
}
\examples{

\dontrun{
## You will need to supply your own login information for whaleshark.org to
## run these examples.

## Load packages
library(marked)

## Extract data for individual A-001 through A-099
data1 <- searchWB(username="username",
                  password="password",
                  baseURL ="whaleshark.org",
                  object="Encounter",
                  individualID=paste0("A-0",rep(0:9,rep(10,10)),rep(0:9,10))[-1])

## Define start and end dates of capture occasions
start.dates1 <- paste0(1998:2016,"-01-01") #Define the start.date value
end.dates1 <- paste0(1998:2016,"-04-01") #Define the end.date value

## Format data for use in marked
markedData1.1 <- markedData(data = data1,
                             varname_of_capturetime = "dateInMilliseconds",
                             varlist = c("individualID"),
                             start.dates = start.dates1,
                             end.dates = NULL,
                             date_format = "\%Y-\%m-\%d",
                             origin = "1970-01-01",
                             removeZeros = TRUE)


## Fit simple CJS model in marked
markedData1.proc=process.data(markedData1.1,model="CJS",begin.time=1)
markedData1.ddl=make.design.data(markedData1.proc)
markedData1.cjs=crm(markedData1.proc,
                    markedData1.ddl,
                    model.parameters=list(Phi=list(formula=~time),p=list(formula=~time)))

## Format data including location as a covariate
markedData1.2 <- markedData(data = data1,
                           varname_of_capturetime = "dateInMilliseconds",
                           varlist = c("individualID","locationID"),
                           start.dates = start.dates1,
                           end.dates = end.dates1,
                           date_format = "\%Y-\%m-\%d",
                           origin = "1970-01-01")
}                           

}

