% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{CCcorrect}
\alias{CCcorrect}
\title{Dimensional Reduction by PCA or ICA}
\usage{
CCcorrect(object, vset = NULL, CGenes = NULL, ccor = 0.4, pvalue = 0.01,
  quant = 0.01, nComp = NULL, dimR = FALSE, mode = "pca",
  logscale = FALSE, FSelect = TRUE)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{vset}{List of vectors with genes sets. The loadings of each component are tested for enrichment in any of these gene sets and if the lower \code{quant} or upper 1 - \code{quant} fraction of genes ordered by loading is enriched at a p-value < \code{pvalue} the component is discarded. Default is \code{NULL}.}

\item{CGenes}{Vector of gene names. If this argument is given, gene sets to be tested for enrichment in PCA- or ICA-components are defined by all genes with a Pearson's correlation of \code{>ccor} to a gene in \code{CGenes}. The loadings of each component are tested for enrichment in any of these gene sets and if the lower \code{quant} or upper 1 - \code{quant} fraction of genes ordered by loading is enriched at a p-value < \code{pvalue} the component is discarded. Default is \code{NULL}.}

\item{ccor}{Positive number between 0 and 1. Correlation threshold used to detrmine correlating gene sets for all genes in \code{CGenes}. Default is 0.4.}

\item{pvalue}{Positive number between 0 and 1. P-value cutoff for determining enriched components. See \code{vset} or \code{CGenes}. Default is 0.01.}

\item{quant}{Positive number between 0 and 1. Upper and lower fraction of gene loadings used for determining enriched components. See \code{vset} or \code{CGenes}.
Default is 0.01.}

\item{nComp}{Number of PCA- or ICA-components to use. Default is \code{NULL} and the maximal number of components is computed.}

\item{dimR}{logical. If \code{TRUE}, then the number of principal components to use for downstream analysis is derived from a saturation criterion.
See function \code{plotdimsat}. Default is \code{FALSE} and all \code{nComp} components are used.}

\item{mode}{\code{"pca"} or \code{"ica"} to perform either principal component analysis or independent component analysis. Default is \code{pca}.}

\item{logscale}{logical. If \code{TRUE} data are log-transformed prior to PCA or ICA. Default is \code{FALSE}.}

\item{FSelect}{logical. If \code{TRUE}, then PCA or ICA is performed on the filtered expression matrix using only the features stored in slot\code{cluster$features}
as computed in the function \code{filterdata}. See \code{FSelect} for function \code{filterdata}. Default is \code{TRUE}.}
}
\value{
The function returns an updated \code{SCseq} object with the principal or independent component matrix written to the slot \code{dimRed$x} of the \code{SCseq}
object. Additional information on the PCA or ICA is stored in slot \code{dimRed}.
}
\description{
This functions performs dimensional reduction by PCA or ICA and removes components enriched for particular gene sets, e.g. cell cycle related genes
genes associated with technical batch effects.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- CCcorrect(sc,dimR=TRUE,nComp=3)
}
